/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.nio.charset.Charset;
import java.util.Random;

public class StringTest {
    static final Charset UTF8 = Charset.forName("utf-8");
    static final Random r = new Random();

    public static String getRandomString() {
        int len = r.nextInt(600);
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = (char)r.nextInt();
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String getStringWithC(char c) {
        int len = 3;
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static int getStringUTF8EncodedByteLength1(String string) {
        return string.getBytes(UTF8).length;
    }

    public static int getStringUTF8EncodedByteLength2(String string) {
        int result = 0;
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            result = c >= '\u0000' && c <= '\u007f' ? ++result : (c >= '\u0080' && c <= '\u07ff' ? (result += 2) : (c >= '\ud800' && c <= '\udfff' ? ++result : (c >= '\u0800' && c <= '\uffff' ? (result += 3) : (c >= '\u10000' && c <= '\u10ffff' ? (result += 4) : (c >= '\u110000' && c <= '\u1fffff' ? (result += 4) : (result += 4))))));
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        int c;
        int j = c = 34969;
        System.out.println(j);
        int i = 1000000;
        while (i < Integer.MAX_VALUE) {
            int len2;
            String str = StringTest.getStringWithC((char)i);
            int len1 = StringTest.getStringUTF8EncodedByteLength1(str);
            if (len1 != (len2 = StringTest.getStringUTF8EncodedByteLength2(str))) {
                System.out.printf("i=%d, Correct=%d, My=%d, Chars=%d, %s\n", i, len1, len2, str.length(), str);
                throw new RuntimeException("length mismatch");
            }
            if ((i & 0xFFFF) == 0) {
                System.out.printf("i=%d, Correct=%d, My=%d, Chars=%d, %s\n", i, len1, len2, str.length(), str);
            }
            ++i;
        }
    }
}

