/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.repository;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.factory.BindingScheme;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.databoard.parser.DataParser;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.ParseException;
import org.simantics.databoard.parser.PrintFormat;
import org.simantics.databoard.parser.TokenMgrError;
import org.simantics.databoard.parser.ast.value.AstArray;
import org.simantics.databoard.parser.ast.value.AstBoolean;
import org.simantics.databoard.parser.ast.value.AstComponentAssignment;
import org.simantics.databoard.parser.ast.value.AstFloat;
import org.simantics.databoard.parser.ast.value.AstInteger;
import org.simantics.databoard.parser.ast.value.AstMap;
import org.simantics.databoard.parser.ast.value.AstMapAssignment;
import org.simantics.databoard.parser.ast.value.AstNull;
import org.simantics.databoard.parser.ast.value.AstRecord;
import org.simantics.databoard.parser.ast.value.AstReference;
import org.simantics.databoard.parser.ast.value.AstString;
import org.simantics.databoard.parser.ast.value.AstTaggedValue;
import org.simantics.databoard.parser.ast.value.AstTuple;
import org.simantics.databoard.parser.ast.value.AstValue;
import org.simantics.databoard.parser.ast.value.AstValueDefinition;
import org.simantics.databoard.parser.ast.value.AstVariant;
import org.simantics.databoard.parser.ast.value.visitor.AstValueVisitor;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.ValueTranslationRuntimeException;
import org.simantics.databoard.parser.unparsing.DataTypePrinter;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class DataValueRepository {
    DataTypeRepository typeRepository = Datatypes.datatypeRepository;
    BindingScheme bindingScheme = Bindings.mutableBindingFactory;
    Map<String, MutableVariant> values = new HashMap<String, MutableVariant>();
    Map<Object, String> nameMap = new IdentityHashMap<Object, String>();
    AstValueVisitor<Datatype> guessDataType = new AstValueVisitor<Datatype>(){

        @Override
        public Datatype visit(AstArray astArray) {
            if (astArray.elements.isEmpty()) {
                throw new ValueTranslationRuntimeException("Cannot guess the data type of empty array.");
            }
            return astArray.elements.get(0).accept(this);
        }

        @Override
        public Datatype visit(AstBoolean astBoolean) {
            return Datatypes.BOOLEAN;
        }

        @Override
        public Datatype visit(AstFloat astFloat) {
            return Datatypes.DOUBLE;
        }

        @Override
        public Datatype visit(AstInteger astInteger) {
            return Datatypes.INTEGER;
        }

        @Override
        public Datatype visit(AstMap astMap) {
            if (astMap.components.isEmpty()) {
                throw new ValueTranslationRuntimeException("Cannot guess the data type of empty map.");
            }
            AstMapAssignment assignment = astMap.components.get(0);
            return new MapType(assignment.key.accept(this), assignment.value.accept(this));
        }

        @Override
        public Datatype visit(AstNull astNull) {
            throw new ValueTranslationRuntimeException("Cannot guess the data type");
        }

        @Override
        public Datatype visit(AstRecord astRecord) {
            Component[] components = new Component[astRecord.components.size()];
            int i = 0;
            for (AstComponentAssignment assignment : astRecord.components) {
                components[i++] = new Component(assignment.component, assignment.value.accept(this));
            }
            return new RecordType(false, components);
        }

        @Override
        public Datatype visit(AstReference astReference) {
            MutableVariant v = DataValueRepository.this.get(astReference.name);
            if (v == null) {
                throw new ValueTranslationRuntimeException("Undefined reference to " + astReference.name + ".");
            }
            return v.type();
        }

        @Override
        public Datatype visit(AstString astString) {
            return Datatypes.STRING;
        }

        @Override
        public Datatype visit(AstTaggedValue astTaggedValue) {
            throw new ValueTranslationRuntimeException("Cannot guess the data type of tagged value");
        }

        @Override
        public Datatype visit(AstTuple astTuple) {
            Component[] components = new Component[astTuple.elements.size()];
            int i = 0;
            for (AstValue value : astTuple.elements) {
                components[i] = new Component(Integer.toString(i), value.accept(this));
                ++i;
            }
            return new RecordType(false, components);
        }

        @Override
        public Datatype visit(AstVariant astVariant) {
            return Datatypes.VARIANT;
        }
    };

    public MutableVariant get(String name) {
        return this.values.get(name);
    }

    public String getName(Object value) {
        return this.nameMap.get(value);
    }

    public void put(String name, Binding binding, Object value) {
        this.put(name, new MutableVariant(binding, value));
    }

    public void put(String name, MutableVariant value) {
        this.values.put(name, value);
        this.nameMap.put(value.getValue(), name);
    }

    public MutableVariant remove(String name) {
        MutableVariant value = this.values.remove(name);
        if (value == null) {
            return null;
        }
        this.nameMap.remove(value.getValue());
        return value;
    }

    public void clear() {
        this.values.clear();
        this.nameMap.clear();
    }

    public Set<String> getValueNames() {
        return this.values.keySet();
    }

    public Object translate(AstValue value, Binding binding) throws DataTypeSyntaxError {
        try {
            if (value instanceof AstReference) {
                String name = ((AstReference)value).name;
                MutableVariant v = this.get(name);
                if (v == null) {
                    UnionBinding b;
                    UnionType type;
                    Integer index;
                    if (binding instanceof UnionBinding && (index = (type = (b = (UnionBinding)binding).type()).getComponentIndex(name)) != null) {
                        try {
                            return b.create(index, b.getComponentBinding(index).createDefault());
                        }
                        catch (BindingException e) {
                            throw new DataTypeSyntaxError(e);
                        }
                    }
                    throw new DataTypeSyntaxError("Undefined reference to " + name + ".");
                }
                return Bindings.adaptUnchecked(v.getValue(), v.getBinding(), binding);
            }
            return binding.accept(new ValueTranslator(value));
        }
        catch (ValueTranslationRuntimeException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public Object translate(String value, Binding binding) throws DataTypeSyntaxError {
        try {
            return this.translate(new DataParser(new StringReader(value)).value(), binding);
        }
        catch (TokenMgrError e) {
            throw new DataTypeSyntaxError(e);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public void addValueDefinition(AstValueDefinition def) throws DataTypeSyntaxError {
        Datatype type = this.typeRepository.translate(def.type);
        Object binding = Bindings.getMutableBinding(type);
        MutableVariant variant = new MutableVariant((Binding)binding, this.translate(def.value, (Binding)binding));
        this.values.put(def.name, variant);
        this.nameMap.put(variant.getValue(), def.name);
    }

    public String addValueDefinition(String def) throws DataTypeSyntaxError {
        try {
            StringReader reader = new StringReader(def);
            DataParser parser = new DataParser(reader);
            AstValueDefinition valueAstDef = parser.valueDefinition();
            this.addValueDefinition(valueAstDef);
            return valueAstDef.name;
        }
        catch (TokenMgrError e) {
            throw new DataTypeSyntaxError(e);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public void addValueDefinitions(Collection<AstValueDefinition> defs) throws DataTypeSyntaxError {
        for (AstValueDefinition def : defs) {
            this.addValueDefinition(def);
        }
    }

    public void addValueDefinitions(String def) throws DataTypeSyntaxError {
        try {
            this.addValueDefinitions(new DataParser(new StringReader(def)).valueDefinitions());
        }
        catch (TokenMgrError e) {
            throw new DataTypeSyntaxError(e);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public DataTypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public void setTypeRepository(DataTypeRepository typeRepository) {
        this.typeRepository = typeRepository;
    }

    public BindingScheme getBindingScheme() {
        return this.bindingScheme;
    }

    public void setBindingScheme(BindingScheme bindingScheme) {
        this.bindingScheme = bindingScheme;
    }

    public String printValue(String valueName) throws IOException, BindingException {
        MutableVariant value = this.get(valueName);
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        DataValuePrinter vp = new DataValuePrinter(sb, this);
        vp.print(value);
        return sb.toString();
    }

    public void print(StringBuilder sb) throws IOException, BindingException {
        DataValuePrinter vp = new DataValuePrinter(sb, this);
        vp.setFormat(PrintFormat.SINGLE_LINE);
        DataTypePrinter tp = new DataTypePrinter(sb);
        tp.setLinedeed(false);
        for (Map.Entry<String, MutableVariant> e : this.values.entrySet()) {
            String name = e.getKey();
            MutableVariant value = e.getValue();
            Datatype type = value.type();
            sb.append(String.valueOf(name) + " : ");
            tp.print(type);
            sb.append(" = ");
            vp.print(value);
            sb.append("\n");
        }
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.print(sb);
            return sb.toString();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public Datatype guessDataType(AstValue value) throws DataTypeSyntaxError {
        return value.accept(this.guessDataType);
    }

    public Datatype guessDataType(String value) throws DataTypeSyntaxError {
        try {
            return this.guessDataType(new DataParser(new StringReader(value)).value());
        }
        catch (TokenMgrError e) {
            throw new DataTypeSyntaxError(e);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    class ValueTranslator
    implements Binding.Visitor<Object> {
        AstValue value;

        public ValueTranslator(AstValue value) {
            this.value = value;
        }

        private ValueTranslationRuntimeException typeError(Binding expectedType, AstValue actualValue) {
            throw new ValueTranslationRuntimeException("Expected " + expectedType.type().toSingleLineString() + " but got " + actualValue.getClass().getSimpleName() + ".");
        }

        @Override
        public Object visit(ArrayBinding b) {
            if (this.value instanceof AstArray) {
                AstArray array = (AstArray)this.value;
                Object[] components = new Object[array.elements.size()];
                Binding componentBinding = b.getComponentBinding();
                int i = 0;
                Iterator<AstValue> iterator = array.elements.iterator();
                while (iterator.hasNext()) {
                    AstValue component;
                    this.value = component = iterator.next();
                    components[i++] = componentBinding.accept(this);
                }
                return b.createUnchecked(components);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(BooleanBinding b) {
            if (this.value instanceof AstBoolean) {
                return b.createUnchecked(((AstBoolean)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(DoubleBinding b) {
            if (this.value instanceof AstFloat) {
                return b.createUnchecked(((AstFloat)this.value).value);
            }
            if (this.value instanceof AstInteger) {
                return b.createUnchecked(((AstInteger)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(FloatBinding b) {
            if (this.value instanceof AstFloat) {
                return b.createUnchecked(((AstFloat)this.value).value);
            }
            if (this.value instanceof AstInteger) {
                return b.createUnchecked(((AstInteger)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(IntegerBinding b) {
            if (this.value instanceof AstInteger) {
                return b.createUnchecked(((AstInteger)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(ByteBinding b) {
            if (this.value instanceof AstInteger) {
                return b.createUnchecked(((AstInteger)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(LongBinding b) {
            if (this.value instanceof AstInteger) {
                return b.createUnchecked(((AstInteger)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(OptionalBinding b) {
            if (this.value == AstNull.NULL) {
                return b.createNoValueUnchecked();
            }
            return b.createValueUnchecked(b.getComponentBinding().accept(this));
        }

        @Override
        public Object visit(RecordBinding b) {
            if (this.value instanceof AstRecord) {
                AstRecord record = (AstRecord)this.value;
                Object[] components = new Object[b.getComponentCount()];
                boolean[] assigned = new boolean[b.getComponentCount()];
                for (AstComponentAssignment assignment : record.components) {
                    this.value = assignment.value;
                    Integer index = b.type().getComponentIndex(assignment.component);
                    if (index == null) {
                        throw new ValueTranslationRuntimeException("Invalid record component " + assignment.component + ".");
                    }
                    components[index.intValue()] = b.getComponentBinding(index).accept(this);
                    assigned[index.intValue()] = true;
                }
                int i = 0;
                while (i < assigned.length) {
                    if (!assigned[i]) {
                        Binding binding = b.getComponentBinding(i);
                        if (binding instanceof OptionalBinding) {
                            components[i] = ((OptionalBinding)binding).createNoValueUnchecked();
                        } else {
                            throw new ValueTranslationRuntimeException("Non-optional field " + b.type().getComponent((int)i).name + " is not defined.");
                        }
                    }
                    ++i;
                }
                return b.createUnchecked(components);
            }
            if (this.value instanceof AstTuple) {
                AstTuple tuple = (AstTuple)this.value;
                Object[] components = new Object[b.getComponentCount()];
                int i = 0;
                Iterator<AstValue> iterator = tuple.elements.iterator();
                while (iterator.hasNext()) {
                    AstValue element;
                    this.value = element = iterator.next();
                    components[i] = b.getComponentBinding(i).accept(this);
                    ++i;
                }
                return b.createUnchecked(components);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(StringBinding b) {
            if (this.value instanceof AstString) {
                return b.createUnchecked(((AstString)this.value).value);
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(UnionBinding b) {
            if (this.value instanceof AstTaggedValue) {
                AstTaggedValue taggedValue = (AstTaggedValue)this.value;
                Integer tagIndex = b.type().getComponentIndex(taggedValue.tag);
                if (tagIndex == null) {
                    throw new ValueTranslationRuntimeException("Invalid union tag " + taggedValue.tag + ".");
                }
                this.value = taggedValue.value;
                return b.createUnchecked(tagIndex, b.getComponentBinding(tagIndex).accept(this));
            }
            if (this.value instanceof AstReference) {
                AstReference ref = (AstReference)this.value;
                Integer tagIndex = b.type().getComponentIndex(ref.name);
                if (tagIndex == null) {
                    throw new ValueTranslationRuntimeException("Invalid union tag " + ref.name + ".");
                }
                try {
                    return b.createUnchecked(tagIndex, b.getComponentBinding(tagIndex).createDefault());
                }
                catch (BindingException bindingException) {
                    // empty catch block
                }
            }
            throw this.typeError(b, this.value);
        }

        @Override
        public Object visit(VariantBinding b) {
            try {
                if (this.value instanceof AstVariant) {
                    AstVariant variant = (AstVariant)this.value;
                    Datatype dataType = DataValueRepository.this.typeRepository.translate(variant.type);
                    Binding binding = DataValueRepository.this.bindingScheme.getBinding(dataType);
                    this.value = variant.value;
                    return b.createUnchecked(binding, binding.accept(this));
                }
                Datatype dataType = DataValueRepository.this.guessDataType(this.value);
                Binding binding = DataValueRepository.this.bindingScheme.getBinding(dataType);
                return b.createUnchecked(binding, binding.accept(this));
            }
            catch (DataTypeSyntaxError e) {
                throw new ValueTranslationRuntimeException(e);
            }
            catch (BindingConstructionException e) {
                throw new ValueTranslationRuntimeException(e);
            }
        }

        @Override
        public Object visit(MapBinding b) {
            if (this.value instanceof AstMap) {
                AstMap map = (AstMap)this.value;
                Object[] keys = new Object[map.components.size()];
                Object[] values = new Object[map.components.size()];
                Binding keyBinding = b.getKeyBinding();
                Binding valueBinding = b.getValueBinding();
                int i = 0;
                for (AstMapAssignment assignment : map.components) {
                    this.value = assignment.key;
                    keys[i] = keyBinding.accept(this);
                    this.value = assignment.value;
                    values[i] = valueBinding.accept(this);
                    ++i;
                }
                return b.createUnchecked(keys, values);
            }
            throw this.typeError(b, this.value);
        }
    }
}

