/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.AsmBindingClassLoader;
import org.simantics.databoard.binding.reflection.ClassInfo;
import org.simantics.databoard.binding.reflection.RecordBindingSubFactory;
import org.simantics.databoard.type.RecordType;

public class AsmBindingFactory
implements RecordBindingSubFactory {
    WeakHashMap<ClassLoader, AsmBindingClassLoader> bindingClassLoaders = new WeakHashMap();

    @Override
    public synchronized RecordBinding createRecordBinding(Class<?> clazz, RecordType type) throws BindingConstructionException {
        AsmBindingClassLoader bcl;
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((bcl = this.bindingClassLoaders.get(cl)) == null) {
            bcl = new AsmBindingClassLoader(cl);
            this.bindingClassLoaders.put(cl, bcl);
        }
        ClassInfo ci = ClassInfo.getInfo(clazz);
        try {
            Class<?> bindingClass = bcl.getBindingClass(clazz);
            Constructor<?> c = bindingClass.getConstructor(RecordType.class);
            RecordBinding binding = (RecordBinding)c.newInstance(type);
            binding.componentBindings = new Binding[ci.fields.length];
            return binding;
        }
        catch (InstantiationException e) {
            throw new BindingConstructionException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingConstructionException(e);
        }
        catch (SecurityException e) {
            throw new BindingConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BindingConstructionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConstructionException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingConstructionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BindingConstructionException(e);
        }
    }
}

