/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.ClassInfo;

public class AsmBindingClassLoader
extends ClassLoader
implements Opcodes {
    Map<String, Class<?>> map = new HashMap();

    public AsmBindingClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public AsmBindingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public String toBindingClassName(String targetClassName) {
        if (targetClassName.startsWith("java")) {
            return "x" + targetClassName + ".Binding";
        }
        return String.valueOf(targetClassName) + ".Binding";
    }

    public String toTargetClassName(String bindingClassName) {
        if (!bindingClassName.endsWith(".Binding")) {
            return null;
        }
        if (bindingClassName.substring(1, 5).equals("java")) {
            return bindingClassName.substring(1, bindingClassName.length() - 8);
        }
        return bindingClassName.substring(0, bindingClassName.length() - 8);
    }

    @Override
    protected synchronized Class<?> findClass(String bindingClassName) throws ClassNotFoundException {
        Class<?> c = this.map.get(bindingClassName);
        if (c != null) {
            return c;
        }
        try {
            String targetClassName = this.toTargetClassName(bindingClassName);
            if (targetClassName == null) {
                return super.findClass(bindingClassName);
            }
            ClassLoader cl = this.getParent();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            Class<?> targetClass = cl.loadClass(targetClassName);
            ClassInfo ci = ClassInfo.getInfo(targetClass);
            byte[] data = this.createBindingClass(ci, bindingClassName);
            Class<?> bindingClass = this.defineClass(bindingClassName, data, 0, data.length);
            this.map.put(bindingClassName, bindingClass);
            return bindingClass;
        }
        catch (BindingConstructionException e) {
            throw new ClassNotFoundException(e.getMessage(), e.getCause());
        }
    }

    public synchronized Class<?> getBindingClass(Class<?> targetClass) throws ClassNotFoundException {
        String targetClassName = targetClass.getName();
        String bindingClassName = this.toBindingClassName(targetClassName);
        Class<?> c = this.map.get(bindingClassName);
        if (c != null) {
            return c;
        }
        try {
            ClassInfo ci = ClassInfo.getInfo(targetClass);
            byte[] data = this.createBindingClass(ci, bindingClassName);
            Class<?> bindingClass = this.defineClass(bindingClassName, data, 0, data.length);
            this.map.put(bindingClassName, bindingClass);
            return bindingClass;
        }
        catch (BindingConstructionException e) {
            throw new ClassNotFoundException(e.getMessage(), e.getCause());
        }
    }

    public byte[] createBindingClass(ClassInfo ci, String bindingClassName) {
        Class<?> fieldClass;
        ClassWriter cw;
        int count = ci.fields.length;
        ClassWriter cv = cw = new ClassWriter(3);
        String className = ci.clazz.getName().replaceAll("\\.", "/");
        bindingClassName = bindingClassName.replaceAll("\\.", "/");
        Object[] classNameX = new Object[]{className};
        String signature = "L" + bindingClassName + ";";
        String superClass = "org/simantics/databoard/binding/reflection/ClassBinding";
        cv.visit(50, 33, bindingClassName, null, superClass, null);
        MethodVisitor mv = cv.visitMethod(1, "<init>", "(Lorg/simantics/databoard/type/RecordType;)V", null, new String[]{"org/simantics/databoard/binding/error/BindingConstructionException"});
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(Type.getType("L" + className + ";"));
        mv.visitMethodInsn(183, superClass, "<init>", "(Ljava/lang/Class;)V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, bindingClassName, "type", "Lorg/simantics/databoard/type/Datatype;");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", signature, null, l0, l3, 0);
        mv.visitLocalVariable("type", "Lorg/simantics/databoard/type/RecordType;", null, l0, l3, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cv.visitMethod(1, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitVarInsn(58, 3);
        l1 = new Label();
        mv.visitLabel(l1);
        Label[] caseLabels = AsmBindingClassLoader.createFieldLabels(ci);
        Label elseLabel = new Label();
        if (count > 0) {
            mv.visitVarInsn(21, 2);
            mv.visitTableSwitchInsn(0, count - 1, elseLabel, caseLabels);
            int i = 0;
            while (i < count) {
                Label label = caseLabels[i];
                Field field = ci.fields[i];
                String fieldName = field.getName();
                fieldClass = ci.fields[i].getType();
                String typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(fieldClass);
                Method getter = ci.getters[i];
                boolean useGetter = (field.getModifiers() & 1) == 0 && getter != null;
                mv.visitLabel(label);
                if (i == 0) {
                    mv.visitFrame(1, 1, classNameX, 0, null);
                } else {
                    mv.visitFrame(3, 0, null, 0, null);
                }
                mv.visitVarInsn(25, 3);
                if (useGetter) {
                    mv.visitMethodInsn(182, className, getter.getName(), "()" + typeDescriptor);
                } else {
                    mv.visitFieldInsn(180, className, fieldName, typeDescriptor);
                }
                AsmBindingClassLoader.box(mv, fieldClass);
                mv.visitInsn(176);
                ++i;
            }
        }
        mv.visitLabel(elseLabel);
        if (count > 0) {
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitTypeInsn(187, "org/simantics/databoard/binding/error/BindingException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Illegal field index");
        mv.visitMethodInsn(183, "org/simantics/databoard/binding/error/BindingException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        Label l19 = new Label();
        mv.visitLabel(l19);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l19, 0);
        mv.visitLocalVariable("obj", "Ljava/lang/Object;", null, l0, l19, 1);
        mv.visitLocalVariable("index", "I", null, l0, l19, 2);
        mv.visitMaxs(3, 4);
        mv.visitEnd();
        mv = cv.visitMethod(129, "create", "([Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        if (ci.beanConstructor != null) {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, className, "<init>", "(Lorg/simantics/databoard/binding/Binding;)V");
            mv.visitVarInsn(58, 2);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, bindingClassName, "setComponents", "(Ljava/lang/Object;[Ljava/lang/Object;)V");
            l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l3, 0);
            mv.visitLocalVariable("values", "[Ljava/lang/Object;", null, l0, l3, 1);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
        } else if (ci.argsConstructor != null) {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            String constArgsDescriptor = "(";
            Class<?>[] args = ci.argsConstructor.getParameterTypes();
            int i = 0;
            while (i < count) {
                Label label = new Label();
                Class<?> field = args[i];
                String fieldName = field.getName();
                Method getter = ci.getters[i];
                fieldClass = ci.fields[i].getType();
                Class<?> boxClass = AsmBindingClassLoader.getBoxClass(fieldClass);
                String typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(fieldClass);
                String boxTypeDescriptor = AsmBindingClassLoader.toTypeDescriptor(boxClass);
                constArgsDescriptor = String.valueOf(constArgsDescriptor) + typeDescriptor;
                mv.visitLabel(label);
                mv.visitVarInsn(25, 1);
                if (i < 6) {
                    mv.visitInsn(3 + i);
                } else {
                    mv.visitIntInsn(16, i);
                }
                mv.visitInsn(50);
                mv.visitTypeInsn(192, AsmBindingClassLoader.toClassCanonicalName(boxClass));
                AsmBindingClassLoader.unbox(mv, fieldClass);
                ++i;
            }
            Label l17 = new Label();
            mv.visitLabel(l17);
            constArgsDescriptor = String.valueOf(constArgsDescriptor) + ")V";
            mv.visitMethodInsn(183, className, "<init>", constArgsDescriptor);
            mv.visitInsn(176);
            Label l18 = new Label();
            mv.visitLabel(l18);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l18, 0);
            mv.visitLocalVariable("values", "[Ljava/lang/Object;", null, l0, l18, 1);
            mv.visitMaxs(21, 2);
            mv.visitEnd();
        } else {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, className, "<init>", "()V");
            mv.visitVarInsn(58, 2);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, bindingClassName, "setComponents", "(Ljava/lang/Object;[Ljava/lang/Object;)V");
            l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l3, 0);
            mv.visitLocalVariable("values", "[Ljava/lang/Object;", null, l0, l3, 1);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
        }
        mv = cv.visitMethod(1, "createPartial", "()Ljava/lang/Object;", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        if (ci.beanConstructor != null) {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, className, "<init>", "(Lorg/simantics/databoard/binding/Binding;)V");
            mv.visitInsn(176);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l1, 0);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        } else if (ci.noArgsConstructor != null) {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, className, "<init>", "()V");
            mv.visitInsn(176);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l1, 0);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        } else {
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitIntInsn(16, count);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitVarInsn(58, 1);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitVarInsn(54, 2);
            l2 = new Label();
            mv.visitLabel(l2);
            l3 = new Label();
            mv.visitJumpInsn(167, l3);
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitFrame(1, 2, new Object[]{"[Ljava/lang/Object;", Opcodes.INTEGER}, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, bindingClassName, "componentBindings", "[Lorg/simantics/databoard/binding/Binding;");
            mv.visitVarInsn(21, 2);
            mv.visitInsn(50);
            mv.visitVarInsn(58, 3);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/Binding", "createDefault", "()Ljava/lang/Object;");
            mv.visitInsn(83);
            Label l6 = new Label();
            mv.visitLabel(l6);
            mv.visitIincInsn(2, 1);
            mv.visitLabel(l3);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(190);
            mv.visitJumpInsn(161, l4);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitLineNumber(109, l7);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, bindingClassName, "create", "([Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(176);
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, l8, 0);
            mv.visitLocalVariable("values", "[Ljava/lang/Object;", null, l1, l8, 1);
            mv.visitLocalVariable("i", "I", null, l2, l7, 2);
            mv.visitLocalVariable("fb", "Lorg/simantics/databoard/binding/Binding;", null, l5, l6, 3);
            mv.visitMaxs(3, 4);
            mv.visitEnd();
        }
        mv = cv.visitMethod(1, "setComponent", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitVarInsn(58, 4);
        Label endLabel = new Label();
        Label l12 = new Label();
        mv.visitLabel(l12);
        elseLabel = new Label();
        Label[] labels = new Label[count];
        int i = 0;
        while (i < count) {
            labels[i] = new Label();
            ++i;
        }
        if (count > 0) {
            mv.visitVarInsn(21, 2);
            mv.visitTableSwitchInsn(0, count - 1, elseLabel, labels);
            i = 0;
            while (i < count) {
                boolean useSetter;
                Label label = labels[i];
                mv.visitLabel(label);
                Field field = ci.fields[i];
                String fieldName = field.getName();
                Class<?> fieldClass2 = ci.fields[i].getType();
                Class<?> boxClass = AsmBindingClassLoader.getBoxClass(fieldClass2);
                String typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(fieldClass2);
                String boxTypeDescriptor = AsmBindingClassLoader.toTypeDescriptor(boxClass);
                Method setter = ci.setters[i];
                Class<?> setterClass = setter != null ? setter.getParameterTypes()[0] : null;
                boolean bl = useSetter = (field.getModifiers() & 1) == 0 && setter != null;
                if (i == 0) {
                    mv.visitFrame(1, 1, classNameX, 0, null);
                } else {
                    mv.visitFrame(3, 0, null, 0, null);
                }
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 3);
                mv.visitTypeInsn(192, AsmBindingClassLoader.toClassCanonicalName(boxClass));
                if (useSetter) {
                    AsmBindingClassLoader.unbox(mv, setterClass);
                    mv.visitMethodInsn(182, className, setter.getName(), "(" + typeDescriptor + ")V");
                } else {
                    AsmBindingClassLoader.unbox(mv, fieldClass2);
                    mv.visitFieldInsn(181, className, field.getName(), typeDescriptor);
                }
                mv.visitInsn(177);
                ++i;
            }
        }
        mv.visitLabel(elseLabel);
        mv.visitLineNumber(178, elseLabel);
        if (count > 0) {
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitTypeInsn(187, "org/simantics/databoard/binding/error/BindingException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Illegal field index");
        mv.visitMethodInsn(183, "org/simantics/databoard/binding/error/BindingException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitLabel(endLabel);
        mv.visitLocalVariable("this", "L" + bindingClassName + ";", null, l0, endLabel, 0);
        mv.visitLocalVariable("obj", "Ljava/lang/Object;", null, l0, endLabel, 1);
        mv.visitLocalVariable("index", "I", null, l0, endLabel, 2);
        mv.visitLocalVariable("value", "Ljava/lang/Object;", null, l0, endLabel, 3);
        mv.visitMaxs(3, 5);
        mv.visitEnd();
        mv = cv.visitMethod(1, "isImmutable", "()Z", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitInsn(172);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cv.visitMethod(1, "isInstance", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, className);
        mv.visitInsn(172);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("obj", "Ljava/lang/Object;", null, l0, l1, 1);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cv.visitMethod(129, "setComponents", "(Ljava/lang/Object;[Ljava/lang/Object;)V", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitVarInsn(58, 3);
        Label firstLabel = l0;
        int i2 = 0;
        while (i2 < count) {
            Label label = new Label();
            if (firstLabel == l0) {
                firstLabel = label;
            }
            Field field = ci.fields[i2];
            String fieldName = field.getName();
            Class<?> fieldClass3 = ci.fields[i2].getType();
            Class<?> boxClass = AsmBindingClassLoader.getBoxClass(fieldClass3);
            String typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(fieldClass3);
            String boxTypeDescriptor = AsmBindingClassLoader.toTypeDescriptor(boxClass);
            Method setter = ci.setters[i2];
            Class<?> setterClass = setter != null ? setter.getParameterTypes()[0] : null;
            boolean useSetter = (field.getModifiers() & 1) == 0 && setter != null;
            mv.visitLabel(label);
            mv.visitVarInsn(25, 3);
            mv.visitVarInsn(25, 2);
            if (i2 < 6) {
                mv.visitInsn(3 + i2);
            } else {
                mv.visitIntInsn(16, i2);
            }
            mv.visitInsn(50);
            mv.visitTypeInsn(192, AsmBindingClassLoader.toClassCanonicalName(boxClass));
            if (useSetter) {
                AsmBindingClassLoader.unbox(mv, setterClass);
                mv.visitMethodInsn(182, className, setter.getName(), "(" + typeDescriptor + ")V");
            } else {
                AsmBindingClassLoader.unbox(mv, fieldClass3);
                mv.visitFieldInsn(181, className, field.getName(), typeDescriptor);
            }
            ++i2;
        }
        Label l17 = new Label();
        mv.visitLabel(l17);
        mv.visitInsn(177);
        Label endLabel2 = new Label();
        mv.visitLabel(endLabel2);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, endLabel2, 0);
        mv.visitLocalVariable("obj", "Ljava/lang/Object;", null, l0, endLabel2, 1);
        mv.visitLocalVariable("value", "[Ljava/lang/Object;", null, l0, endLabel2, 2);
        mv.visitMaxs(3, 4);
        mv.visitEnd();
        this.addGetSetPrimitive(ci, cv, "Boolean", "Z", bindingClassName);
        this.addGetSetPrimitive(ci, cv, "Byte", "B", bindingClassName);
        this.addGetSetPrimitive(ci, cv, "Int", "I", bindingClassName);
        this.addGetSetPrimitive(ci, cv, "Long", "J", bindingClassName);
        this.addGetSetPrimitive(ci, cv, "Float", "F", bindingClassName);
        this.addGetSetPrimitive(ci, cv, "Double", "D", bindingClassName);
        cv.visitEnd();
        return cw.toByteArray();
    }

    private void addGetSetPrimitive(ClassInfo ci, ClassVisitor cv, String setterName, String signature, String bindingClassName) {
        String typeDescriptor;
        Class<?> fieldClass;
        Field field;
        String className = ci.clazz.getName().replaceAll("\\.", "/");
        Label firstLabel = new Label();
        Label secondLabel = new Label();
        Label errorLabel = new Label();
        Label exitLabel = new Label();
        Label lastLabel = new Label();
        boolean oneByte = !signature.equals("J") && !signature.equals("D");
        int c = 0;
        Field[] fieldArray = ci.fields;
        int n = ci.fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (AsmBindingClassLoader.toTypeDescriptor(AsmBindingClassLoader.getPrimitiveClass(f.getType())).equals(signature)) {
                ++c;
            }
            ++n2;
        }
        int[] indices = new int[c];
        Label[] caseLabel = new Label[c];
        c = 0;
        int i = 0;
        while (i < ci.fields.length) {
            Class<?> fieldClass2 = ci.fields[i].getType();
            String s = AsmBindingClassLoader.toTypeDescriptor(fieldClass2 = AsmBindingClassLoader.getPrimitiveClass(fieldClass2));
            if (s.equals(signature)) {
                indices[c] = i;
                caseLabel[c] = new Label();
                ++c;
            }
            ++i;
        }
        MethodVisitor mv = cv.visitMethod(1, "set" + setterName, "(Ljava/lang/Object;I" + signature + ")V", null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        mv.visitCode();
        mv.visitLabel(firstLabel);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitVarInsn(58, oneByte ? 4 : 5);
        mv.visitLabel(secondLabel);
        mv.visitVarInsn(21, 2);
        mv.visitLookupSwitchInsn(errorLabel, indices, caseLabel);
        if (c > 0) {
            int i2 = 0;
            while (i2 < c) {
                int index = indices[i2];
                Method setter = ci.setters[index];
                field = ci.fields[index];
                fieldClass = field.getType();
                Class<?> setterClass = setter != null ? setter.getParameterTypes()[0] : null;
                boolean useSetter = (field.getModifiers() & 1) == 0 && setter != null;
                typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(useSetter ? setterClass : fieldClass);
                mv.visitLabel(caseLabel[i2]);
                if (i2 == 0) {
                    mv.visitFrame(1, 1, new Object[]{className}, 0, null);
                } else {
                    mv.visitFrame(3, 0, new Object[]{className}, 0, null);
                }
                if (signature.equals("F")) {
                    mv.visitVarInsn(25, 4);
                    mv.visitVarInsn(23, 3);
                } else if (signature.equals("D")) {
                    mv.visitVarInsn(25, 5);
                    mv.visitVarInsn(24, 3);
                } else if (signature.equals("J")) {
                    mv.visitVarInsn(25, 5);
                    mv.visitVarInsn(22, 3);
                } else {
                    mv.visitVarInsn(25, 4);
                    mv.visitVarInsn(21, 3);
                }
                if (useSetter) {
                    AsmBindingClassLoader.boxTo(mv, setterClass);
                    mv.visitMethodInsn(182, className, setter.getName(), "(" + typeDescriptor + ")V");
                } else {
                    AsmBindingClassLoader.boxTo(mv, fieldClass);
                    mv.visitFieldInsn(181, className, field.getName(), typeDescriptor);
                }
                mv.visitJumpInsn(167, exitLabel);
                ++i2;
            }
        } else {
            mv.visitInsn(87);
        }
        mv.visitLabel(errorLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, bindingClassName, "componentBindings", "[Lorg/simantics/databoard/binding/Binding;");
        mv.visitVarInsn(21, 2);
        mv.visitInsn(50);
        if (signature.equals("F")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/FloatBinding");
            mv.visitVarInsn(23, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/FloatBinding", "create", "(F)Ljava/lang/Object;");
        } else if (signature.equals("D")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/DoubleBinding");
            mv.visitVarInsn(24, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/DoubleBinding", "create", "(D)Ljava/lang/Object;");
        } else if (signature.equals("J")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/LongBinding");
            mv.visitVarInsn(22, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/LongBinding", "create", "(J)Ljava/lang/Object;");
        } else if (signature.equals("Z")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/BooleanBinding");
            mv.visitVarInsn(21, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/BooleanBinding", "create", "(Z)Ljava/lang/Object;");
        } else if (signature.equals("I")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/IntBinding");
            mv.visitVarInsn(21, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/IntBinding", "create", "(I)Ljava/lang/Object;");
        } else if (signature.equals("B")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/ByteBinding");
            mv.visitVarInsn(21, 3);
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/ByteBinding", "create", "(B)Ljava/lang/Object;");
        }
        mv.visitMethodInsn(182, bindingClassName, "setComponent", "(Ljava/lang/Object;ILjava/lang/Object;)V");
        mv.visitLabel(exitLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitLabel(lastLabel);
        mv.visitMaxs(oneByte ? 5 : 6, oneByte ? 5 : 6);
        mv.visitEnd();
        firstLabel = new Label();
        secondLabel = new Label();
        errorLabel = new Label();
        exitLabel = new Label();
        lastLabel = new Label();
        int i3 = 0;
        while (i3 < c) {
            caseLabel[i3] = new Label();
            ++i3;
        }
        mv = cv.visitMethod(1, "get" + setterName, "(Ljava/lang/Object;I)" + signature, null, new String[]{"org/simantics/databoard/binding/error/BindingException"});
        mv.visitCode();
        mv.visitLabel(firstLabel);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitVarInsn(58, 3);
        mv.visitLabel(secondLabel);
        mv.visitVarInsn(21, 2);
        if (c > 0) {
            mv.visitLookupSwitchInsn(errorLabel, indices, caseLabel);
            i3 = 0;
            while (i3 < c) {
                int index = indices[i3];
                Method getter = ci.getters[index];
                field = ci.fields[index];
                fieldClass = field.getType();
                Class<?> getterClass = getter != null ? getter.getReturnType() : null;
                boolean useGetter = (field.getModifiers() & 1) == 0 && getter != null;
                typeDescriptor = AsmBindingClassLoader.toTypeDescriptor(useGetter ? getterClass : fieldClass);
                mv.visitLabel(caseLabel[i3]);
                if (i3 == 0) {
                    mv.visitFrame(1, 1, new Object[]{className}, 0, null);
                } else {
                    mv.visitFrame(3, 0, new Object[]{className}, 0, null);
                }
                mv.visitVarInsn(25, 3);
                if (useGetter) {
                    mv.visitMethodInsn(182, className, getter.getName(), "()" + typeDescriptor);
                    AsmBindingClassLoader.unboxFrom(mv, getterClass);
                } else {
                    mv.visitFieldInsn(180, className, field.getName(), typeDescriptor);
                    AsmBindingClassLoader.unboxFrom(mv, fieldClass);
                }
                if (signature.equals("F")) {
                    mv.visitInsn(174);
                } else if (signature.equals("D")) {
                    mv.visitInsn(175);
                } else if (signature.equals("J")) {
                    mv.visitInsn(173);
                } else {
                    mv.visitInsn(172);
                }
                ++i3;
            }
        } else {
            mv.visitInsn(87);
        }
        mv.visitLabel(errorLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, bindingClassName, "componentBindings", "[Lorg/simantics/databoard/binding/Binding;");
        mv.visitVarInsn(21, 2);
        mv.visitInsn(50);
        if (signature.equals("Z")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/BooleanBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/BooleanBinding", "getValue_", "(Ljava/lang/Object;)Z");
            mv.visitInsn(172);
        } else if (signature.equals("B")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/ByteBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/ByteBinding", "getValue_", "(Ljava/lang/Object;)B");
            mv.visitInsn(172);
        } else if (signature.equals("I")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/IntBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/IntBinding", "getValue_", "(Ljava/lang/Object;)I");
            mv.visitInsn(172);
        } else if (signature.equals("J")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/LongBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/LongBinding", "getValue_", "(Ljava/lang/Object;)J");
            mv.visitInsn(173);
        } else if (signature.equals("F")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/FloatBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/FloatBinding", "getValue_", "(Ljava/lang/Object;)F");
            mv.visitInsn(174);
        } else if (signature.equals("D")) {
            mv.visitTypeInsn(192, "org/simantics/databoard/binding/DoubleBinding");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, bindingClassName, "getComponent", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            mv.visitMethodInsn(182, "org/simantics/databoard/binding/DoubleBinding", "getValue_", "(Ljava/lang/Object;)D");
            mv.visitInsn(175);
        }
        mv.visitLabel(lastLabel);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
    }

    public static Label[] createFieldLabels(ClassInfo ci) {
        Label[] caseLabels = new Label[ci.fields.length];
        int i = 0;
        while (i < ci.fields.length) {
            caseLabels[i] = new Label();
            ++i;
        }
        return caseLabels;
    }

    public static String toTypeDescriptor(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz.isArray()) {
            return clazz.getName().replaceAll("\\.", "/");
        }
        return "L" + clazz.getName().replaceAll("\\.", "/") + ";";
    }

    public static Class<?> getBoxClass(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Long.TYPE || clazz == Double.TYPE;
    }

    public static void unbox(MethodVisitor mv, Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (clazz == Character.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        } else if (clazz == Byte.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (clazz == Short.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (clazz == Integer.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (clazz == Float.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (clazz == Long.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (clazz == Double.TYPE) {
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        }
    }

    public static void box(MethodVisitor mv, Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (clazz == Character.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (clazz == Byte.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (clazz == Short.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (clazz == Integer.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (clazz == Float.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (clazz == Long.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (clazz == Double.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    public static void boxTo(MethodVisitor mv, Class<?> clazz) {
        if (clazz == Boolean.class) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (clazz == Character.class) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (clazz == Byte.class) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (clazz == Short.class) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (clazz == Integer.class) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (clazz == Float.class) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (clazz == Long.class) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (clazz == Double.class) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    public static void unboxFrom(MethodVisitor mv, Class<?> clazz) {
        if (clazz == Boolean.class) {
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (clazz == Character.class) {
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        } else if (clazz == Byte.class) {
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (clazz == Short.class) {
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (clazz == Integer.class) {
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (clazz == Float.class) {
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (clazz == Long.class) {
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (clazz == Double.class) {
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        }
    }

    public static String toClassCanonicalName(Class<?> clazz) {
        return clazz.getName().replaceAll("\\.", "/");
    }
}

