/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.LongType;

public class LongBindingDefault
extends LongBinding {
    public LongBindingDefault(LongType type) {
        super(type);
    }

    @Override
    public Object create(long value) {
        return value;
    }

    @Override
    public Object create(Long value) {
        return (long)value;
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Long.class) {
            return value;
        }
        return value.longValue();
    }

    @Override
    public Object create(String value) {
        return Long.parseLong(value);
    }

    @Override
    public Long getValue(Object o) throws BindingException {
        if (o.getClass() != Long.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Long expected");
        }
        return (Long)o;
    }

    @Override
    public long getValue_(Object o) throws BindingException {
        if (o.getClass() != Long.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Long expected");
        }
        return (Long)o;
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Long");
    }

    @Override
    public void setValue(Object obj, long value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Long");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Long;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }
}

