/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.Set;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.Range;

public abstract class NumberBinding
extends Binding {
    public abstract Object create(Number var1) throws BindingException;

    public abstract Object create(String var1) throws BindingException;

    @Override
    public NumberType type() {
        return (NumberType)this.type;
    }

    public Number getValue(Object obj) throws BindingException {
        return (Number)obj;
    }

    public abstract void setValue(Object var1, Number var2) throws BindingException;

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        Number value;
        if (!this.isInstance(obj)) {
            throw new BindingException("Not a correct instance");
        }
        NumberType type = this.type();
        Range range = type.getRange();
        if (range != null && !range.contains(value = this.getValue(obj))) {
            throw new BindingException("Value (" + value + ") out of range (" + range + ")");
        }
    }

    public Object createUnchecked(String value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked(Number value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        ctx.b.append(this.getValue(value).toString());
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        Number v = ((NumberBinding)srcBinding).getValue(src);
        this.setValue(dst, v);
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Binding getComponentBinding(int index) {
        throw new IllegalArgumentException();
    }
}

