/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.IntegerAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.IntegerInterestSet;
import org.simantics.databoard.accessor.java.JavaArray;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.java.JavaRecord;
import org.simantics.databoard.accessor.java.JavaVariant;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.IntegerType;

public class JavaInteger
extends JavaObject
implements IntegerAccessor {
    public JavaInteger(Accessor parent, IntegerBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
    }

    @Override
    public IntegerBinding getBinding() {
        return (IntegerBinding)this.binding;
    }

    @Override
    public IntegerType type() {
        return this.getBinding().type();
    }

    @Override
    public int getValue() throws AccessorException {
        this.readLock();
        try {
            int n = this.getBinding().getValue_(this.object);
            return n;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setValue(int newValue) throws AccessorException {
        if (newValue == this.getValue()) {
            return;
        }
        try {
            Object nv;
            JavaObject jo;
            if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaArray) {
                jo = (JavaObject)this.parent;
                ArrayBinding ab = (ArrayBinding)jo.binding;
                nv = this.getBinding().create(newValue);
                ab.set(jo.object, (Integer)this.keyInParent, nv);
                this.object = nv;
            } else if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaRecord) {
                jo = (JavaObject)this.parent;
                RecordBinding rb = (RecordBinding)jo.binding;
                nv = this.getBinding().create(newValue);
                rb.setComponent(jo.object, (Integer)this.keyInParent, nv);
                this.object = nv;
            } else if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaVariant) {
                jo = (JavaObject)this.parent;
                VariantBinding vb = (VariantBinding)jo.binding;
                nv = this.getBinding().create(newValue);
                vb.setContent(jo.object, this.getBinding(), nv);
                this.object = nv;
            } else {
                this.getBinding().setValue(this.object, newValue);
            }
            ListenerEntry le = this.listeners;
            while (le != null) {
                IntegerInterestSet is = (IntegerInterestSet)le.getInterestSet();
                if (is.inNotifications()) {
                    ValueAssigned e = new ValueAssigned(Bindings.INTEGER, is.inValues() ? Integer.valueOf(newValue) : null);
                    this.emitEvent(le, e);
                }
                le = le.next;
            }
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValue(Binding binding, Object newValue) throws AccessorException {
        try {
            int nv = ((IntegerBinding)binding).getValue_(newValue);
            this.setValue(nv);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(reference.getClass() + " is not a subreference of BooleanType");
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback;
        ValueAssigned valueAssigned = rollback = makeRollback ? new ValueAssigned(Bindings.INTEGER, this.getValue()) : null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (va.newValue == null) {
                throw new AccessorException("Integer value expected, got null");
            }
            this.setValue(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Integer");
    }
}

