/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.accessor.interestset.ArrayInterestSet;
import org.simantics.databoard.accessor.interestset.BooleanInterestSet;
import org.simantics.databoard.accessor.interestset.ByteInterestSet;
import org.simantics.databoard.accessor.interestset.DoubleInterestSet;
import org.simantics.databoard.accessor.interestset.FloatInterestSet;
import org.simantics.databoard.accessor.interestset.IntegerInterestSet;
import org.simantics.databoard.accessor.interestset.LongInterestSet;
import org.simantics.databoard.accessor.interestset.MapInterestSet;
import org.simantics.databoard.accessor.interestset.OptionalInterestSet;
import org.simantics.databoard.accessor.interestset.RecordInterestSet;
import org.simantics.databoard.accessor.interestset.StringInterestSet;
import org.simantics.databoard.accessor.interestset.UnionInterestSet;
import org.simantics.databoard.accessor.interestset.VariantInterestSet;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;

@Union(value={BooleanInterestSet.class, ByteInterestSet.class, IntegerInterestSet.class, LongInterestSet.class, FloatInterestSet.class, DoubleInterestSet.class, StringInterestSet.class, RecordInterestSet.class, ArrayInterestSet.class, MapInterestSet.class, OptionalInterestSet.class, UnionInterestSet.class, VariantInterestSet.class})
public abstract class InterestSet {
    public abstract boolean inNotifications();

    public abstract boolean inValues();

    public static InterestSet newInterestSet(Datatype type, boolean notification, boolean value, boolean recursive) {
        if (type instanceof BooleanType) {
            if (recursive) {
                return BooleanInterestSet.MONITOR_EVERYTHING;
            }
            return new BooleanInterestSet(notification, value);
        }
        if (type instanceof ByteType) {
            if (recursive) {
                return ByteInterestSet.MONITOR_EVERYTHING;
            }
            return new ByteInterestSet(notification, value);
        }
        if (type instanceof IntegerType) {
            if (recursive) {
                return IntegerInterestSet.MONITOR_EVERYTHING;
            }
            return new IntegerInterestSet(notification, value);
        }
        if (type instanceof LongType) {
            if (recursive) {
                return LongInterestSet.MONITOR_EVERYTHING;
            }
            return new LongInterestSet(notification, value);
        }
        if (type instanceof FloatType) {
            if (recursive) {
                return FloatInterestSet.MONITOR_EVERYTHING;
            }
            return new FloatInterestSet(notification, value);
        }
        if (type instanceof DoubleType) {
            if (recursive) {
                return DoubleInterestSet.MONITOR_EVERYTHING;
            }
            return new DoubleInterestSet(notification, value);
        }
        if (type instanceof StringType) {
            if (recursive) {
                return StringInterestSet.MONITOR_EVERYTHING;
            }
            return new StringInterestSet(notification, value);
        }
        if (type instanceof OptionalType) {
            OptionalType ot = (OptionalType)type;
            InterestSet cis = recursive ? InterestSet.newInterestSet(ot.getComponentType(), notification, value, true) : null;
            return new OptionalInterestSet(notification, value, cis);
        }
        if (type instanceof RecordType) {
            if (!recursive) {
                return new RecordInterestSet(notification, null, value, null, null);
            }
            RecordType rt = (RecordType)type;
            InterestSet[] componentInterests = new InterestSet[rt.getComponentCount()];
            int i = 0;
            while (i < componentInterests.length) {
                componentInterests[i] = InterestSet.newInterestSet(rt.getComponentType(i), notification, value, true);
                ++i;
            }
            return new RecordInterestSet(true, null, true, null, componentInterests);
        }
        if (type instanceof UnionType) {
            if (!recursive) {
                return new UnionInterestSet(notification, value, null);
            }
            UnionType ut = (UnionType)type;
            InterestSet[] componentInterests = new InterestSet[ut.getComponentCount()];
            int i = 0;
            while (i < componentInterests.length) {
                componentInterests[i] = InterestSet.newInterestSet(ut.getComponent((int)i).type, notification, value, true);
                ++i;
            }
            return new UnionInterestSet(notification, value, componentInterests);
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            InterestSet cis = recursive ? InterestSet.newInterestSet(at.componentType(), notification, value, true) : null;
            return new ArrayInterestSet(notification, null, value, null, cis, null);
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            InterestSet cis = recursive ? InterestSet.newInterestSet(mt.valueType, notification, value, true) : null;
            return new MapInterestSet(notification, null, value, null, cis, null);
        }
        if (type instanceof VariantType) {
            return new VariantInterestSet(notification, value, null, recursive);
        }
        throw new IllegalArgumentException(type.toSingleLineString());
    }
}

