/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class DirectoryWatch {
    public static final long POLL_INTERVAL = 10000L;
    Timer timer;
    FileFilter filter;
    File directory;
    List<File> knownFiles;
    CopyOnWriteArrayList<DirectoryListener> listeners = new CopyOnWriteArrayList();
    TimerTask task = new TimerTask(){

        @Override
        public void run() {
            DirectoryWatch.this.poll();
        }
    };

    public DirectoryWatch(File directory, FileFilter filter) {
        this.directory = directory;
        this.filter = filter;
        this.knownFiles = this.readFiles();
        this.timer = new Timer(String.valueOf(directory.toString()) + " watcher", true);
        this.timer.schedule(this.task, 1L, 10000L);
    }

    public void close() {
        this.timer.cancel();
        this.poll();
    }

    public void addListener(DirectoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DirectoryListener listener) {
        this.listeners.remove(listener);
    }

    public List<File> files() {
        return this.knownFiles;
    }

    public void refresh() {
        this.poll();
    }

    public synchronized void add(File f) {
        ArrayList<File> newList = new ArrayList<File>(this.knownFiles);
        newList.add(f);
        this.knownFiles = newList;
    }

    public synchronized void remove(File f) {
        ArrayList<File> newList = new ArrayList<File>(this.knownFiles);
        newList.remove(f);
        this.knownFiles = newList;
    }

    private List<File> readFiles() {
        File[] files = this.directory.listFiles(this.filter);
        ArrayList<File> newFiles = new ArrayList<File>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            newFiles.add(f);
            ++n2;
        }
        return newFiles;
    }

    private synchronized void poll() {
        DirectoryEvent e = this.read();
        if (e.filesAdded.isEmpty() && e.filesRemoved.isEmpty()) {
            return;
        }
        for (DirectoryListener l : this.listeners) {
            l.onWatchEvent(e);
        }
    }

    private DirectoryEvent read() {
        List<File> oldFiles = this.knownFiles;
        List<File> newFiles = this.readFiles();
        this.knownFiles = newFiles;
        DirectoryEvent result = new DirectoryEvent();
        result.filesAdded.addAll(newFiles);
        result.filesAdded.removeAll(oldFiles);
        result.filesRemoved.addAll(oldFiles);
        result.filesRemoved.removeAll(newFiles);
        return result;
    }

    public static class DirectoryEvent {
        public Set<File> filesAdded = new HashSet<File>();
        public Set<File> filesRemoved = new HashSet<File>();
    }

    public static interface DirectoryListener {
        public void onWatchEvent(DirectoryEvent var1);
    }
}

