/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.adapter.RuntimeAdapterConstructionException;
import org.simantics.databoard.annotations.ArgumentImpl;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.classfactory.ImmutableClassesFactory;
import org.simantics.databoard.binding.classfactory.TypeClassFactory;
import org.simantics.databoard.binding.classfactory.TypeClassSubFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.factory.BindingRepository;
import org.simantics.databoard.binding.factory.DefaultBindingFactory;
import org.simantics.databoard.binding.factory.JavaUtilBindingsFactory;
import org.simantics.databoard.binding.factory.MutableBindingFactory;
import org.simantics.databoard.binding.factory.TroveBindingsFactory;
import org.simantics.databoard.binding.factory.TypeBindingFactory;
import org.simantics.databoard.binding.impl.BeanBinding;
import org.simantics.databoard.binding.impl.ObjectVariantBinding;
import org.simantics.databoard.binding.impl.StringVariantBinding;
import org.simantics.databoard.binding.mutable.ImmutableVariantBinding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.BindingSubFactory;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.serialization.DefaultSerializerFactory;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerFactory;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.DataValueUtil;

public class Databoard {
    public final Map<Datatype, Binding> mutableBindingRepository = Collections.synchronizedMap(new HashMap());
    public final Map<Datatype, Binding> defaultBindingRepository = Collections.synchronizedMap(new HashMap());
    public final BindingRepository bindingRepository = new BindingRepository();
    public final Map<Binding, Serializer> serializerRepository = Collections.synchronizedMap(new HashMap());
    public final TypeBindingFactory mutableBindingFactory = new MutableBindingFactory(this.mutableBindingRepository);
    public final TypeBindingFactory defaultBindingFactory = new DefaultBindingFactory(this.defaultBindingRepository);
    public final ClassBindingFactory classBindingFactory = new ClassBindingFactory(this.bindingRepository);
    public final SerializerFactory serializationFactory = new DefaultSerializerFactory(this.serializerRepository);
    public final AdapterFactory adapterFactory = new AdapterFactory();
    public final TypeClassFactory typeClassFactory = new TypeClassFactory();
    public final VariantBinding VARIANT;
    public final VariantBinding OBJECT;
    public final VariantBinding STR_VARIANT;
    public final Binding BEAN;

    public Databoard() {
        this.classBindingFactory.addFactory(new TroveBindingsFactory());
        this.classBindingFactory.addFactory(new JavaUtilBindingsFactory());
        this.VARIANT = new ImmutableVariantBinding(this.classBindingFactory, this.adapterFactory);
        this.OBJECT = new ObjectVariantBinding(this.classBindingFactory, this.adapterFactory);
        this.BEAN = new BeanBinding(this.classBindingFactory, this.typeClassFactory, this.adapterFactory);
        this.STR_VARIANT = new StringVariantBinding(this.serializationFactory, this.VARIANT);
        this.classBindingFactory.addFactory(new DataboardBindings());
        this.typeClassFactory.addFactory(new ImmutableClassesFactory());
        try {
            Class.forName("org.objectweb.asm.ClassWriter");
            Class<?> y = Class.forName("org.simantics.databoard.binding.classfactory.AsmTypeClassFactory");
            Constructor<?> c = y.getConstructor(TypeClassFactory.class);
            TypeClassSubFactory f = (TypeClassSubFactory)c.newInstance(this.typeClassFactory);
            this.typeClassFactory.addFactory(f);
            BindingRequest br = new BindingRequest(Datatype.class, new Annotation[0]);
            Object datatypeBinding = this.getBinding(br);
            this.typeClassFactory.getRepository().put(((Binding)datatypeBinding).type(), br);
        }
        catch (ClassNotFoundException y) {
        }
        catch (InstantiationException y) {
        }
        catch (IllegalAccessException y) {
        }
        catch (IllegalArgumentException y) {
        }
        catch (InvocationTargetException y) {
        }
        catch (SecurityException y) {
        }
        catch (NoSuchMethodException y) {
        }
        catch (BindingConstructionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getMutableBinding(Datatype type) {
        try {
            Binding binding = this.mutableBindingRepository.get(type);
            if (binding != null) {
                return (T)binding;
            }
            Map<Datatype, Binding> map = this.mutableBindingRepository;
            synchronized (map) {
                return (T)this.mutableBindingFactory.getBinding(type);
            }
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getBinding(Datatype type) {
        try {
            Binding binding = this.defaultBindingRepository.get(type);
            if (binding != null) {
                return (T)binding;
            }
            Map<Datatype, Binding> map = this.defaultBindingRepository;
            synchronized (map) {
                return (T)this.defaultBindingFactory.getBinding(type);
            }
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getBinding(Class<?> clazz) throws BindingConstructionException {
        Binding binding = this.bindingRepository.get(clazz);
        if (binding != null) {
            return (T)binding;
        }
        BindingRequest request = new BindingRequest(clazz, new Annotation[0]);
        ClassBindingFactory classBindingFactory = this.classBindingFactory;
        synchronized (classBindingFactory) {
            binding = this.classBindingFactory.construct(request);
        }
        return (T)binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getBinding(BindingRequest request) throws BindingConstructionException {
        ClassBindingFactory classBindingFactory = this.classBindingFactory;
        synchronized (classBindingFactory) {
            return (T)this.classBindingFactory.construct(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getBinding(Class<?> clazz, Class<?> ... parameters) throws BindingConstructionException {
        BindingRequest request = new BindingRequest(clazz, parameters);
        ClassBindingFactory classBindingFactory = this.classBindingFactory;
        synchronized (classBindingFactory) {
            return (T)this.classBindingFactory.construct(request);
        }
    }

    public <T extends Binding> T getBindingUnchecked(Class<?> clazz) throws RuntimeBindingConstructionException {
        try {
            return this.getBinding(clazz);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Binding> T getBindingUnchecked(Class<?> clazz, Class<?> ... parameters) throws RuntimeBindingConstructionException {
        try {
            ArgumentImpl args = new ArgumentImpl(parameters);
            BindingRequest request = new BindingRequest(clazz, args);
            Binding binding = this.bindingRepository.get(request);
            if (binding != null) {
                // empty if block
            }
            ClassBindingFactory classBindingFactory = this.classBindingFactory;
            synchronized (classBindingFactory) {
                binding = this.classBindingFactory.construct(request);
            }
            return (T)binding;
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public void addBinding(Binding binding, Class<?> clazz, Class<?> ... parameters) {
        ArgumentImpl args = new ArgumentImpl(parameters);
        BindingRequest request = new BindingRequest(clazz, args);
        this.bindingRepository.put(request, binding);
    }

    public void addBindingFactory(BindingSubFactory factory) {
        this.classBindingFactory.addFactory(factory);
    }

    public BindingRequest getBeanBindingRequest(Datatype type) throws RuntimeBindingConstructionException {
        try {
            return this.typeClassFactory.getClass(type);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public Class<?> getBeanClass(Datatype type) throws BindingConstructionException {
        BindingRequest br = this.typeClassFactory.getClass(type);
        return br.getClazz();
    }

    public Binding getBeanBinding(Datatype type) throws RuntimeBindingConstructionException {
        try {
            BindingRequest br = this.typeClassFactory.getClass(type);
            return this.getBinding(br);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public Serializer getSerializer(Binding binding) throws SerializerConstructionException {
        return this.serializationFactory.construct(binding);
    }

    public Serializer getSerializerUnchecked(Binding binding) throws RuntimeSerializerConstructionException {
        try {
            return this.serializationFactory.construct(binding);
        }
        catch (SerializerConstructionException e) {
            throw new RuntimeSerializerConstructionException(e);
        }
    }

    public Serializer getSerializer(Class<?> clazz) throws SerializerConstructionException {
        try {
            Object binding = this.getBinding(clazz);
            return this.serializationFactory.construct((Binding)binding);
        }
        catch (BindingConstructionException e) {
            throw new SerializerConstructionException(e);
        }
    }

    public Serializer getSerializerUnchecked(Class<?> clazz) throws RuntimeSerializerConstructionException {
        try {
            Object binding = this.getBinding(clazz);
            return this.serializationFactory.construct((Binding)binding);
        }
        catch (SerializerConstructionException e) {
            throw new RuntimeSerializerConstructionException(e);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeSerializerConstructionException(new SerializerConstructionException(e));
        }
    }

    public Adapter getAdapter(Binding domain, Binding range) throws AdapterConstructionException {
        return this.adapterFactory.getAdapter(domain, range, false, false);
    }

    public Adapter getAdapterUnchecked(Binding domain, Binding range) throws RuntimeAdapterConstructionException {
        try {
            return this.adapterFactory.getAdapter(domain, range, false, false);
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdapterConstructionException(e);
        }
    }

    public Adapter getTypeAdapter(Binding domain, Binding range) throws AdapterConstructionException {
        return this.adapterFactory.getAdapter(domain, range, true, false);
    }

    public Adapter getTypeAdapterUnchecked(Binding domain, Binding range) {
        try {
            return this.adapterFactory.getAdapter(domain, range, true, false);
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdapterConstructionException(e);
        }
    }

    public Object adapt(Object value, Binding domain, Binding range) throws AdaptException {
        try {
            if (domain == range) {
                return value;
            }
            return this.adapterFactory.getAdapter(domain, range, true, false).adapt(value);
        }
        catch (AdapterConstructionException e) {
            throw new AdaptException(e);
        }
    }

    public Object adaptUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        try {
            if (domain == range) {
                return value;
            }
            return this.adapterFactory.getAdapter(domain, range, true, false).adaptUnchecked(value);
        }
        catch (RuntimeAdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public Object clone(Object value, Binding domain, Binding range) throws AdaptException {
        try {
            if (domain == range) {
                if (domain.isImmutable()) {
                    return value;
                }
                return domain.clone(value);
            }
            return this.adapterFactory.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdapterConstructionException e) {
            throw new AdaptException(e);
        }
    }

    public Object cloneUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        try {
            return this.adapterFactory.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
        catch (RuntimeAdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public int compare(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        return DataValueUtil.compare(b1, o1, b2, o2);
    }

    public boolean equals(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        return DataValueUtil.equals(b1, o1, b2, o2);
    }

    public Comparator<Object> createComparator(Binding b1, Binding b2) {
        return DataValueUtil.createComparator(b1, b2);
    }

    public String toString(Object o) {
        try {
            Object b = this.getBinding(o.getClass());
            return ((Binding)b).printValueDefinition(o, true);
        }
        catch (BindingConstructionException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
        catch (IOException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
        catch (BindingException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
    }

    class DataboardBindings
    implements BindingSubFactory {
        DataboardBindings() {
        }

        @Override
        public Binding construct(ClassBindingFactory mainFactory, BindingRequest request) throws BindingConstructionException {
            if (request.getClazz().equals(Object.class)) {
                return Databoard.this.OBJECT;
            }
            if (request.getClazz().equals(Void.class) || request.getClazz().equals(Void.TYPE)) {
                return VoidBinding.VOID_BINDING;
            }
            if (request.getClazz().equals(Variant.class)) {
                return Bindings.VARIANT;
            }
            if (request.getClazz().equals(MutableVariant.class)) {
                return Bindings.MUTABLE_VARIANT;
            }
            if (request.getClazz().equals(Bean.class)) {
                return Databoard.this.BEAN;
            }
            return null;
        }
    }
}

