/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.maps.sg.MapInfoConstants;
import org.simantics.maps.sg.MapInfoNode;

public class MapAttributionNode
extends MapInfoNode {
    private static final long serialVersionUID = 7994492218791569147L;

    public void render(Graphics2D g2d) {
        if (!this.enabled) {
            return;
        }
        AffineTransform ot = g2d.getTransform();
        g2d.setTransform(new AffineTransform());
        Rectangle controlBounds = g2d.getClipBounds();
        if (controlBounds == null) {
            return;
        }
        g2d.setFont(MapInfoConstants.getInfoFont());
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds("Map data \u00a9 OpenStreetMap contributors", g2d);
        double yOffsetFromBottom = this.getMapInfoNextY(g2d);
        double frameMaxX = controlBounds.getMaxX();
        double frameMaxY = controlBounds.getMaxY() - yOffsetFromBottom;
        int frameWidth = (int)Math.ceil(r.getWidth()) + 20;
        int frameHeight = (int)Math.ceil(r.getHeight()) + 4;
        Composite oc = g2d.getComposite();
        g2d.setComposite(MapInfoConstants.INFO_COMPOSITE);
        g2d.setStroke(MapInfoConstants.INFO_STROKE);
        g2d.setColor(MapInfoConstants.TEXT_BG_COLOR);
        this.rect.setFrameFromDiagonal(frameMaxX - (double)frameWidth, frameMaxY - (double)frameHeight, frameMaxX, frameMaxY);
        g2d.fill(this.rect);
        g2d.setColor(Color.BLACK);
        g2d.drawString("Map data \u00a9 OpenStreetMap contributors", (int)this.rect.getMinX() + 10, (int)frameMaxY - fm.getMaxDescent() - 2);
        g2d.setComposite(oc);
        g2d.setTransform(ot);
        this.setMapInfoNextY(g2d, yOffsetFromBottom + this.rect.getHeight() + 4.0);
    }
}

