/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;

public class MouseCursors {
	
	public Cursor grab, hand, grab_horiz, grab_vert;
	
	public MouseCursors() {
		Toolkit toolkit = Toolkit.getDefaultToolkit();

		URL url = MouseCursors.class.getResource( "grab.png" );
		Image image = toolkit.getImage( url );
		Point hotspot = new Point(16, 14);
		grab = toolkit.createCustomCursor(image, hotspot, "org.simantics.trend.grab");
		
		url = MouseCursors.class.getResource( "hand.png" );
		image = toolkit.getImage( url );
		hotspot = new Point(16, 15);
		hand = toolkit.createCustomCursor(image, hotspot, "org.simantics.trend.hand");
		
		url = MouseCursors.class.getResource( "grab_horiz.png" );
		image = toolkit.getImage( url );
		hotspot = new Point(12, 10);
		grab_horiz = toolkit.createCustomCursor(image, hotspot, "org.simantics.trend.grab_horiz");

		url = MouseCursors.class.getResource( "grab_vert.png" );
		image = toolkit.getImage( url );
		hotspot = new Point(16, 11);
		grab_vert = toolkit.createCustomCursor(image, hotspot, "org.simantics.trend.grab_vert");
		
	}
		
}
