/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.configuration;

import java.awt.event.KeyEvent;

import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.events.command.Commands;

/**
 * Describes a key binding of a command
 * 
 * @See {@link Command} Command class
 * @See {@link Commands} Default commands
 * @See KeyToCommand Participant that forwards key presses to commands
 * 
 * @author Toni Kalajainen
 */
public class TrendKeyBindings {

	public static final CommandKeyBinding[] DEFAULT_BINDINGS = {
//		new ChartKeyBindings(TrendParticipant.TIME_WINDOW_MATCH_OTHERS, null, KeyEvent.VK_5),
		new CommandKeyBinding(Commands.PAN_LEFT, null, KeyEvent.VK_LEFT),
		new CommandKeyBinding(Commands.PAN_RIGHT, null, KeyEvent.VK_RIGHT),
		new CommandKeyBinding(Commands.PAN_UP, null, KeyEvent.VK_UP),
		new CommandKeyBinding(Commands.PAN_DOWN, null, KeyEvent.VK_DOWN),
		new CommandKeyBinding(Commands.ZOOM_TO_FIT, null, KeyEvent.VK_1),
        new CommandKeyBinding(Commands.ZOOM_TO_FIT_HORIZ, null, KeyEvent.VK_2),
        new CommandKeyBinding(Commands.ZOOM_TO_FIT_VERT, null, KeyEvent.VK_3),
        new CommandKeyBinding(Commands.AUTOSCALE, null, KeyEvent.VK_4),
        new CommandKeyBinding(Commands.AUTOSCALE, null, KeyEvent.VK_ESCAPE),
		new CommandKeyBinding(Commands.ZOOM_IN, null, KeyEvent.VK_PLUS),
		new CommandKeyBinding(Commands.ZOOM_IN, null, KeyEvent.VK_ADD),
		new CommandKeyBinding(Commands.ZOOM_OUT, null, KeyEvent.VK_MINUS),
		new CommandKeyBinding(Commands.ZOOM_OUT, null, KeyEvent.VK_SUBTRACT),

		new CommandKeyBinding(Commands.CUT, null, KeyEvent.VK_X, KeyEvent.VK_CONTROL),
		new CommandKeyBinding(Commands.COPY, null, KeyEvent.VK_C, KeyEvent.VK_CONTROL),
		new CommandKeyBinding(Commands.PASTE, null, KeyEvent.VK_V, KeyEvent.VK_CONTROL),
		new CommandKeyBinding(Commands.PRINT, null, KeyEvent.VK_P, KeyEvent.VK_CONTROL),
		new CommandKeyBinding(Commands.PDFPRINT, null, KeyEvent.VK_P, KeyEvent.VK_ALT),
		new CommandKeyBinding(Commands.GRID_TOGGLE, null, KeyEvent.VK_G),
		new CommandKeyBinding(Commands.RULER_TOGGLE, null, KeyEvent.VK_R),
		new CommandKeyBinding(Commands.FOCUS_TOOLTIP, null, KeyEvent.VK_F9)
	};
	
}
