package org.simantics.document.server.state;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeManagerVariableBuilder;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.document.server.state.StateNodeManager;
import org.simantics.document.server.state.StateSessionManager;

public class StateVariableBuilder extends NodeManagerVariableBuilder {

	@Override
	protected NodeSupport<?> getNodeSupport(ReadGraph graph, String sessionName) throws DatabaseException {
		return StateSessionManager.getInstance().getOrCreateNodeSupport(graph, sessionName);
	}

	@Override
	protected Object getRoot(ReadGraph graph, NodeSupport<?> support, String sessionName) {
		StateNodeManager manager = (StateNodeManager)support.manager;
		return manager.getRoot();
	}

}