/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.client;

import java.util.TreeMap;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.ICommand;

public interface WidgetManager<D extends Document, W> {

	public W createWidget(JSONObject object);

	public void updateProperties(D document, JSONObject object, W widget);

	public void updateChildren(D document, JSONObject object, W widget, TreeMap<String, WidgetData> childMap);

	public IEventCommand eventCommand(D document, JSONObject object, W widget, ICommand command, CommandContext context);

	public String getProperty(D document, JSONObject object, W widget, String property);

}