package org.simantics.document.server;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

import gnu.trove.map.hash.THashMap;

public class DocumentHistoryCollector {

	static Map<String, DocumentHistory> histories = new THashMap<String, DocumentHistory>();

	private static DocumentHistory getHistory(String location, boolean create) {

		synchronized(histories) {

			DocumentHistory history =  histories.get(location);
			if(history == null && create) {
				history = new DocumentHistory();
				pruneHistories();
				histories.put(location, history);
			}
			return history;
			
		}

	}
	
	private static void pruneHistories() {
		synchronized (histories) {
			// remove histories with no listeners
			Iterator<Map.Entry<String, DocumentHistory>> iter = histories.entrySet().iterator();
			while (iter.hasNext()) {
	        	Entry<String, DocumentHistory> entry = iter.next();
	        	DocumentHistory entryHistory = entry.getValue();
	        	synchronized(entryHistory) {
		        	if (!entryHistory.hasListeners()) {
		        		iter.remove();
		        	}
	        	}
	        }
		}
	}

	public static Pair<Integer, Collection<JSONObject>> readChanges(String location, int sequenceNumber) {
		DocumentHistory history = getHistory(location, false);
		if (history != null) {
			return history.readChanges(sequenceNumber);
		} else {
			return null;
		}
	}

	public static Pair<Integer, Collection<JSONObject>> getContent(Listener<Integer> listener, String location, int sequenceNumber) {
		DocumentHistory history = getHistory(location, true);
		return history.getContent(listener, location, sequenceNumber);
	}
}