/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.configuration.Rename;
import org.w3._2001.xmlschema.Attribute;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.AttributeGroupRef;
import org.w3._2001.xmlschema.ComplexType;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.SimpleType;

public class SchemaObject {
    private SchemaConversionBase sc;
    private String name;
    private SchemaObject parent;
    private ObjectType type;
    private OpenAttrs obj;
    private Rename rename;

    public SchemaObject(SchemaConversionBase sc, Element element) {
        this(sc, null, element);
    }

    public void setRename(Rename rename) {
        this.rename = rename;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, ComplexType complexType) {
        this(sc, null, complexType);
    }

    public SchemaObject(SchemaConversionBase sc, SimpleType simpleType) {
        this(sc, null, simpleType);
    }

    public SchemaObject(SchemaConversionBase sc, NamedGroup namedGroup) {
        this(sc, null, namedGroup);
    }

    public SchemaObject(SchemaConversionBase sc, Attribute attribute) {
        this(sc, null, attribute);
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, Element element) {
        this.parent = parent;
        this.obj = element;
        this.type = ObjectType.ELEMENT;
        this.sc = sc;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, ComplexType complexType) {
        this.parent = parent;
        this.obj = complexType;
        this.type = ObjectType.COMPLEX_TYPE;
        this.sc = sc;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, AttributeGroup attributeGroup) {
        this.parent = parent;
        this.obj = attributeGroup;
        this.type = ObjectType.ATTRIBUTE_GROUP;
        this.sc = sc;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, NamedGroup namedGroup) {
        this.parent = parent;
        this.obj = namedGroup;
        this.type = ObjectType.MODEL_GROUP;
        this.sc = sc;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, SimpleType simpleType) {
        this.parent = parent;
        this.obj = simpleType;
        this.type = ObjectType.SIMPLE_TYPE;
        this.sc = sc;
        this._init();
    }

    public SchemaObject(SchemaConversionBase sc, SchemaObject parent, Attribute attribute) {
        this.parent = parent;
        this.obj = attribute;
        this.type = ObjectType.ATTRIBUTE;
        this.sc = sc;
        this._init();
    }

    private void _init() {
        this.name = this._getName();
        if (this.name != null) {
            this.name = this.name.replaceAll("\\.", "_");
        }
    }

    public Element getElement() {
        if (this.type != ObjectType.ELEMENT) {
            return null;
        }
        return (Element)this.obj;
    }

    public ComplexType getComplexType() {
        if (this.type != ObjectType.COMPLEX_TYPE) {
            return null;
        }
        return (ComplexType)this.obj;
    }

    public SimpleType getSimpleType() {
        if (this.type != ObjectType.SIMPLE_TYPE) {
            return null;
        }
        return (SimpleType)this.obj;
    }

    public AttributeGroup getAttributeGroup() {
        if (this.type != ObjectType.ATTRIBUTE_GROUP) {
            return null;
        }
        return (AttributeGroup)this.obj;
    }

    public NamedGroup getModelGroup() {
        if (this.type != ObjectType.MODEL_GROUP) {
            return null;
        }
        return (NamedGroup)this.obj;
    }

    public Attribute getAttribute() {
        if (this.type != ObjectType.ATTRIBUTE) {
            return null;
        }
        return (Attribute)this.obj;
    }

    public SchemaObject getParent() {
        return this.parent;
    }

    public OpenAttrs getObj() {
        return this.obj;
    }

    public String getName() {
        return this.name;
    }

    public String getLibShortName() {
        return this.sc.converter.shortName;
    }

    private String _getName() {
        switch (this.type) {
            case ATTRIBUTE_GROUP: {
                if (this.obj instanceof NamedAttributeGroup) {
                    return ((NamedAttributeGroup)this.obj).getName();
                }
                return ((AttributeGroupRef)this.obj).getRef().getLocalPart();
            }
            case COMPLEX_TYPE: {
                if (this.rename != null) {
                    return this.rename.getName();
                }
                return ((ComplexType)this.obj).getName();
            }
            case ELEMENT: {
                if (this.rename != null) {
                    return this.rename.getName();
                }
                return ((Element)this.obj).getName();
            }
            case SIMPLE_TYPE: {
                return ((SimpleType)this.obj).getName();
            }
            case ATTRIBUTE: {
                return ((Attribute)this.obj).getName();
            }
            case MODEL_GROUP: {
                return ((NamedGroup)this.obj).getName();
            }
        }
        throw new RuntimeException("Unknown object type " + (Object)((Object)this.type));
    }

    public ObjectType getType() {
        return this.type;
    }

    public SchemaConversionBase getSc() {
        return this.sc;
    }

    static enum ObjectType {
        ELEMENT,
        COMPLEX_TYPE,
        SIMPLE_TYPE,
        ATTRIBUTE_GROUP,
        MODEL_GROUP,
        ATTRIBUTE;

    }
}

