/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.xml.sax.SchemaConversionComponent;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.simantics.xml.sax.configuration.Attribute;
import org.simantics.xml.sax.configuration.AttributeComposition;
import org.simantics.xml.sax.configuration.ComplexType;
import org.simantics.xml.sax.configuration.Configuration;
import org.simantics.xml.sax.configuration.ConversionRule;
import org.simantics.xml.sax.configuration.Element;
import org.simantics.xml.sax.configuration.IDProvider;
import org.simantics.xml.sax.configuration.IDReference;
import org.simantics.xml.sax.configuration.IgnoreMixed;
import org.simantics.xml.sax.configuration.OrderedChild;
import org.simantics.xml.sax.configuration.Rename;
import org.simantics.xml.sax.configuration.UnrecognizedChildElement;
import org.w3._2001.xmlschema.All;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.Any;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.ComplexContent;
import org.w3._2001.xmlschema.ComplexRestrictionType;
import org.w3._2001.xmlschema.ExplicitGroup;
import org.w3._2001.xmlschema.ExtensionType;
import org.w3._2001.xmlschema.Group;
import org.w3._2001.xmlschema.GroupRef;
import org.w3._2001.xmlschema.List;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalElement;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.RealGroup;
import org.w3._2001.xmlschema.Restriction;
import org.w3._2001.xmlschema.Schema;
import org.w3._2001.xmlschema.SimpleContent;
import org.w3._2001.xmlschema.SimpleExtensionType;
import org.w3._2001.xmlschema.SimpleType;
import org.w3._2001.xmlschema.TopLevelAttribute;
import org.w3._2001.xmlschema.TopLevelComplexType;
import org.w3._2001.xmlschema.TopLevelElement;
import org.w3._2001.xmlschema.TopLevelSimpleType;
import org.w3._2001.xmlschema.Union;

public final class SchemaConversionBase {
    protected Schema schema;
    protected SchemaConverter converter;
    protected SchemaConversionComponent component;
    protected Configuration configuration;
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String CONVERSION_NS = "http://www.simantics.org/Layer0";
    protected Map<String, Map<String, TypeEntry>> typeMap;
    protected String ontologyURI;
    protected String className;
    private Map<String, SchemaObject> elementName = new HashMap<String, SchemaObject>();
    private Map<String, SchemaObject> complexTypeName = new HashMap<String, SchemaObject>();
    private Map<String, SchemaObject> simpleTypeName = new HashMap<String, SchemaObject>();
    private Map<String, SchemaObject> modelGroupName = new HashMap<String, SchemaObject>();
    private Map<String, SchemaObject> attrName = new HashMap<String, SchemaObject>();
    private Map<org.w3._2001.xmlschema.Element, SchemaObject> elements = new HashMap<org.w3._2001.xmlschema.Element, SchemaObject>();
    private Map<org.w3._2001.xmlschema.ComplexType, SchemaObject> complexTypes = new HashMap<org.w3._2001.xmlschema.ComplexType, SchemaObject>();
    private Map<SimpleType, SchemaObject> simpleTypes = new HashMap<SimpleType, SchemaObject>();
    private Map<NamedGroup, SchemaObject> modelGroups = new HashMap<NamedGroup, SchemaObject>();
    private Map<org.w3._2001.xmlschema.Attribute, SchemaObject> attributes = new HashMap<org.w3._2001.xmlschema.Attribute, SchemaObject>();

    public SchemaConversionBase(SchemaConverter converter, String ontologyUri, String className) {
        this.converter = converter;
        this.configuration = converter.getConfiguration();
        this.ontologyURI = ontologyUri;
        this.className = className;
        this.initTypes();
    }

    protected void initTypes() {
        this.typeMap = new HashMap<String, Map<String, TypeEntry>>();
        HashMap<String, TypeEntry> schemaTypes = new HashMap<String, TypeEntry>();
        this.typeMap.put(SCHEMA_NS, schemaTypes);
        HashMap<String, TypeEntry> l0Types = new HashMap<String, TypeEntry>();
        this.typeMap.put(CONVERSION_NS, l0Types);
        schemaTypes.put("string", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("NMTOKEN", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("token", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("ID", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", "", true));
        schemaTypes.put("IDREF", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("Name", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("NCName", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("date", new TypeEntry("XML.Date", "org.simantics.xml.sax.base.datatypes.literal.Date.BINDING", "org.simantics.xml.sax.base.datatypes.literal.Date", "", "org.simantics.xml.sax.base.datatypes.literal.Date.parseDate(", ")", "(", ").toString()"));
        schemaTypes.put("time", new TypeEntry("XML.Time", "org.simantics.xml.sax.base.datatypes.literal.Time.BINDING", "org.simantics.xml.sax.base.datatypes.literal.Time", "", "org.simantics.xml.sax.base.datatypes.literal.Time.parseTime(", ")", "(", ").toString()"));
        schemaTypes.put("dateTime", new TypeEntry("XML.DateTime", "org.simantics.xml.sax.base.datatypes.literal.DateTime.BINDING", "org.simantics.xml.sax.base.datatypes.literal.DateTime", "", "org.simantics.xml.sax.base.datatypes.literal.DateTime.parseDateTime(", ")", "(", ").toString()"));
        schemaTypes.put("gYearMonth", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("gYear", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("gMonth", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("gMonthDay", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("anyURI", new TypeEntry("L0.URI", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("double", new TypeEntry("L0.Double", "Bindings.DOUBLE", "double", "java.lang.Double.NaN", "java.lang.Double.parseDouble(", ")", "java.lang.Double.toString(", ")"));
        schemaTypes.put("float", new TypeEntry("L0.Float", "Bindings.FLOAT", "float", "java.lang.Float.NaN", "java.lang.Float.parseFloat(", ")", "java.lang.Float.toString(", ")"));
        schemaTypes.put("decimal", new TypeEntry("L0.Double", "Bindings.DOUBLE", "double", "java.lang.Double.NaN", "java.lang.Double.parseDouble(", ")", "java.lang.Double.toString(", ")"));
        schemaTypes.put("boolean", new TypeEntry("L0.Boolean", "Bindings.BOOLEAN", "boolean", "false", "java.lang.Boolean.parseBoolean(", ")", "java.lang.Boolean.toString(", ")"));
        schemaTypes.put("integer", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("positiveInteger", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("nonPositiveInteger", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("nonNegativeInteger", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("negativeInteger", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("unsignedInt", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("int", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("short", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("unsignedShort", new TypeEntry("L0.Integer", "Bindings.INTEGER", "int", "0", "java.lang.Integer.parseInt(", ")", "java.lang.Integer.toString(", ")"));
        schemaTypes.put("byte", new TypeEntry("L0.Byte", "Bindings.BYTE", "byte", "0", "java.lang.Byte.parseByte(", ")", "java.lang.Byte.toString(", ")"));
        schemaTypes.put("unsignedByte", new TypeEntry("L0.Byte", "Bindings.BYTE", "byte", "0", "java.lang.Byte.parseByte(", ")", "java.lang.Byte.toString(", ")"));
        schemaTypes.put("long", new TypeEntry("L0.Long", "Bindings.LONG", "long", "0", "java.lang.Long.parseLong(", ")", "java.lang.Long.toString(", ")"));
        schemaTypes.put("unsignedLong", new TypeEntry("L0.Long", "Bindings.LONG", "long", "0", "java.lang.Long.parseLong(", ")", "java.lang.Long.toString(", ")"));
        schemaTypes.put("base64Binary", new TypeEntry("L0.ByteArray", "Bindings.BYTE_ARRAY", "byte[]", "new byte[0]", "java.util.Base64.getDecoder().decode(", ".replaceAll(\"\\n\", \"\").getBytes(java.nio.charset.StandardCharsets.UTF_8))", "java.util.Base64.getEncoder().encodeToString(", ")"));
        schemaTypes.put("normalizedString", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        schemaTypes.put("hexBinary", new TypeEntry("L0.String", "Bindings.STRING", "java.lang.String", "", "", "", "", ""));
        l0Types.put("doubleArray", new TypeEntry("L0.DoubleArray", "Bindings.DOUBLE_ARRAY", "double[]", null, null, null, "java.lang.Double.toString(", ")"));
        l0Types.put("stringArray", new TypeEntry("L0.StringArray", "Bindings.STRING_ARRAY", "string[]", null, null, null, "", ""));
    }

    protected TypeEntry getTypeEntry(QName type) {
        Map<String, TypeEntry> types = this.typeMap.get(type.getNamespaceURI());
        if (types == null) {
            return null;
        }
        TypeEntry entry = types.get(type.getLocalPart());
        return entry;
    }

    protected TypeEntry getTypeEntry(String type) {
        for (Map<String, TypeEntry> types : this.typeMap.values()) {
            TypeEntry entry = types.get(type);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    protected String getL0TypeFromPrimitiveType(QName primitiveType) {
        TypeEntry entry = this.getTypeEntry(primitiveType);
        if (entry == null) {
            return null;
        }
        return entry.l0Type;
    }

    protected String getL0Type(QName primitiveType) {
        String type = this.getL0TypeFromPrimitiveType(primitiveType);
        if (type != null) {
            return type;
        }
        SchemaObject simpleTypeObj = this.simpleTypeName.get(primitiveType.getLocalPart());
        if (simpleTypeObj == null) {
            return null;
        }
        SimpleType simpleType = simpleTypeObj.getSimpleType();
        while (simpleType != null) {
            QName base = simpleType.getRestriction().getBase();
            if (base != null) {
                return this.getL0Type(base);
            }
            simpleType = simpleType.getRestriction().getSimpleType();
        }
        return null;
    }

    protected String getBindingFromPrimitiveType(QName primitiveType) {
        TypeEntry entry = this.getTypeEntry(primitiveType);
        if (entry == null) {
            return null;
        }
        return entry.binding;
    }

    protected String getJavaTypeFromPrimitiveType(QName primitiveType) {
        TypeEntry entry = this.getTypeEntry(primitiveType);
        if (entry == null) {
            return null;
        }
        return entry.javaType;
    }

    public void init(Schema schema) {
        this.schema = schema;
        this.preload();
    }

    public void handle(SchemaConversionComponent component) {
        this.component = component;
        for (OpenAttrs attrs : this.schema.getSimpleTypeOrComplexTypeOrGroup()) {
            if (attrs instanceof TopLevelAttribute) {
                this.handle((TopLevelAttribute)attrs);
                continue;
            }
            if (attrs instanceof TopLevelComplexType) {
                this.handleComplexType(this.complexTypes.get(attrs));
                continue;
            }
            if (attrs instanceof TopLevelElement) {
                this.handleElement(this.elements.get(attrs));
                continue;
            }
            if (attrs instanceof TopLevelSimpleType) {
                this.handleSimpleType(this.simpleTypes.get(attrs));
                continue;
            }
            if (attrs instanceof NamedAttributeGroup) {
                this.handle((NamedAttributeGroup)attrs);
                continue;
            }
            if (attrs instanceof NamedGroup) {
                this.handle((NamedGroup)attrs);
                continue;
            }
            System.out.println(attrs.getClass().getName());
        }
    }

    private SchemaObject _getWithName(QName name) {
        SchemaObject obj = this.elementName.get(name.getLocalPart());
        if (obj == null) {
            obj = this.complexTypeName.get(name.getLocalPart());
        }
        if (obj == null) {
            obj = this.simpleTypeName.get(name.getLocalPart());
        }
        if (obj == null) {
            obj = this.attrName.get(name.getLocalPart());
        }
        return obj;
    }

    protected SchemaObject getWithName(QName name) {
        SchemaObject obj = this._getWithName(name);
        if (obj != null) {
            return obj;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getWithName(name)) == null) continue;
                return obj;
            }
        }
        return null;
    }

    private NamedAttributeGroup _getAttributeGroup(QName name) {
        for (OpenAttrs attrs : this.schema.getSimpleTypeOrComplexTypeOrGroup()) {
            NamedAttributeGroup group;
            if (!(attrs instanceof NamedAttributeGroup) || !(group = (NamedAttributeGroup)attrs).getName().equals(name.getLocalPart())) continue;
            return group;
        }
        return null;
    }

    public NamedAttributeGroup getAttributeGroup(QName name) {
        NamedAttributeGroup group = this._getAttributeGroup(name);
        if (group != null) {
            return group;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (group = sc.base._getAttributeGroup(name)) == null) continue;
                return group;
            }
        }
        return null;
    }

    private SchemaObject _getElement(QName name) {
        return this.elementName.get(name.getLocalPart());
    }

    protected SchemaObject getElement(QName name) {
        SchemaObject obj = this._getElement(name);
        if (obj != null) {
            return obj;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getElement(name)) == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected SchemaObject _getElement(org.w3._2001.xmlschema.Element element) {
        return this.elements.get(element);
    }

    protected SchemaObject getElement(org.w3._2001.xmlschema.Element element) {
        SchemaObject e = this._getElement(element);
        if (e != null) {
            return e;
        }
        for (SchemaConverter conv : this.converter.getSubConverters()) {
            e = conv.base._getElement(element);
            if (e == null) continue;
            return e;
        }
        return e;
    }

    private SchemaObject _getComplexType(QName name) {
        return this.complexTypeName.get(name.getLocalPart());
    }

    protected SchemaObject getComplexType(QName name) {
        SchemaObject obj = this._getComplexType(name);
        if (obj != null) {
            return obj;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getComplexType(name)) == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected SchemaObject _getComplexType(org.w3._2001.xmlschema.ComplexType complexType) {
        return this.complexTypes.get(complexType);
    }

    protected SchemaObject getComplexType(org.w3._2001.xmlschema.ComplexType complexType) {
        SchemaObject e = this._getComplexType(complexType);
        if (e != null) {
            return e;
        }
        for (SchemaConverter conv : this.converter.getSubConverters()) {
            e = conv.base._getComplexType(complexType);
            if (e == null) continue;
            return e;
        }
        return e;
    }

    private SchemaObject _getSimpleType(QName name) {
        return this.simpleTypeName.get(name.getLocalPart());
    }

    protected SchemaObject getSimpleType(QName name) {
        SchemaObject obj = this._getSimpleType(name);
        if (obj != null) {
            return obj;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getSimpleType(name)) == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected SchemaObject _getSimpleType(SimpleType simpleType) {
        return this.simpleTypes.get(simpleType);
    }

    protected SchemaObject getSimpleType(SimpleType simpleType) {
        SchemaObject e = this._getSimpleType(simpleType);
        if (e != null) {
            return e;
        }
        for (SchemaConverter conv : this.converter.getSubConverters()) {
            e = conv.base._getSimpleType(simpleType);
            if (e == null) continue;
            return e;
        }
        return e;
    }

    private SchemaObject _getModelGroup(QName name) {
        return this.modelGroupName.get(name.getLocalPart());
    }

    protected SchemaObject getModelGroup(QName name) {
        SchemaObject obj = this._getModelGroup(name);
        if (obj != null) {
            return obj;
        }
        if (name.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(name.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getModelGroup(name)) == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected SchemaObject _getModelGroup(NamedGroup group) {
        return this.modelGroups.get(group);
    }

    protected SchemaObject getModelGroup(NamedGroup group) {
        SchemaObject e = this._getModelGroup(group);
        if (e != null) {
            return e;
        }
        for (SchemaConverter conv : this.converter.getSubConverters()) {
            e = conv.base._getModelGroup(group);
            if (e == null) continue;
            return e;
        }
        return e;
    }

    protected SchemaObject getWithObj(SchemaObject referrer, OpenAttrs attrs) {
        SchemaObject obj = null;
        if (attrs instanceof org.w3._2001.xmlschema.Element) {
            obj = this.getElement((org.w3._2001.xmlschema.Element)attrs);
        } else if (attrs instanceof org.w3._2001.xmlschema.ComplexType) {
            obj = this.getComplexType((org.w3._2001.xmlschema.ComplexType)attrs);
        } else if (attrs instanceof SimpleType) {
            obj = this.getSimpleType((SimpleType)attrs);
        }
        if (obj == null) {
            throw new RuntimeException("Cannot locate referred object " + attrs + " when handling " + referrer.getName());
        }
        return obj;
    }

    private void preload() {
        ArrayDeque<SchemaObject> stack = new ArrayDeque<SchemaObject>();
        for (OpenAttrs attrs : this.schema.getSimpleTypeOrComplexTypeOrGroup()) {
            SchemaObject obj;
            if (attrs instanceof org.w3._2001.xmlschema.Element) {
                org.w3._2001.xmlschema.Element element = (org.w3._2001.xmlschema.Element)attrs;
                obj = new SchemaObject(this, element);
                obj.setRename(this.getRename(element));
                stack.push(obj);
                continue;
            }
            if (attrs instanceof org.w3._2001.xmlschema.ComplexType) {
                org.w3._2001.xmlschema.ComplexType complexType = (org.w3._2001.xmlschema.ComplexType)attrs;
                obj = new SchemaObject(this, complexType);
                obj.setRename(this.getRename(complexType));
                stack.push(obj);
                continue;
            }
            if (attrs instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)attrs;
                obj = new SchemaObject(this, simpleType);
                stack.push(obj);
                continue;
            }
            if (attrs instanceof org.w3._2001.xmlschema.Attribute) {
                org.w3._2001.xmlschema.Attribute attribute = (org.w3._2001.xmlschema.Attribute)attrs;
                obj = new SchemaObject(this, attribute);
                stack.push(obj);
                continue;
            }
            if (attrs instanceof AttributeGroup) continue;
            if (attrs instanceof NamedGroup) {
                NamedGroup group = (NamedGroup)attrs;
                obj = new SchemaObject(this, group);
                stack.push(obj);
                continue;
            }
            System.out.println(attrs.getClass().getName());
        }
        block8: while (!stack.isEmpty()) {
            SchemaObject object = (SchemaObject)stack.pop();
            switch (object.getType()) {
                case COMPLEX_TYPE: {
                    Annotated cc;
                    ExtensionType extensionType;
                    org.w3._2001.xmlschema.ComplexType ct = object.getComplexType();
                    if (ct.getName() != null && ct.getName().length() > 0 && ct instanceof TopLevelComplexType) {
                        this.complexTypeName.put(ct.getName(), object);
                    }
                    this.complexTypes.put(ct, object);
                    if (ct.getChoice() != null) {
                        this.preload(object, ct.getChoice(), stack);
                    }
                    if (ct.getSequence() != null) {
                        this.preload(object, ct.getSequence(), stack);
                    }
                    if (ct.getAll() != null) {
                        this.preload(object, ct.getAll(), stack);
                    }
                    if (ct.getGroup() != null) {
                        throw new RuntimeException("Groups not supported");
                    }
                    if (ct.getComplexContent() != null && (extensionType = ((ComplexContent)(cc = ct.getComplexContent())).getExtension()) != null) {
                        if (extensionType.getChoice() != null) {
                            this.preload(object, extensionType.getChoice(), stack);
                        }
                        if (extensionType.getSequence() != null) {
                            this.preload(object, extensionType.getSequence(), stack);
                        }
                        if (extensionType.getAll() != null) {
                            this.preload(object, extensionType.getAll(), stack);
                        }
                        if (extensionType.getGroup() != null) {
                            throw new RuntimeException("Groups not supported");
                        }
                    }
                    if (ct.getSimpleContent() == null || (extensionType = ((SimpleContent)(cc = ct.getSimpleContent())).getExtension()) == null) continue block8;
                    if (extensionType.getChoice() != null) {
                        this.preload(object, extensionType.getChoice(), stack);
                    }
                    if (extensionType.getSequence() != null) {
                        this.preload(object, extensionType.getSequence(), stack);
                    }
                    if (extensionType.getAll() != null) {
                        this.preload(object, extensionType.getAll(), stack);
                    }
                    if (extensionType.getGroup() == null) break;
                    throw new RuntimeException("Groups not supported");
                }
                case ELEMENT: {
                    Annotated e = object.getElement();
                    if (e instanceof TopLevelElement) {
                        this.elementName.put(((org.w3._2001.xmlschema.Element)e).getName(), object);
                    }
                    this.elements.put((org.w3._2001.xmlschema.Element)e, object);
                    if (((org.w3._2001.xmlschema.Element)e).getComplexType() != null) {
                        stack.push(new SchemaObject(this, object, ((org.w3._2001.xmlschema.Element)e).getComplexType()));
                    }
                    if (((org.w3._2001.xmlschema.Element)e).getSimpleType() == null) break;
                    stack.push(new SchemaObject(this, object, ((org.w3._2001.xmlschema.Element)e).getSimpleType()));
                    break;
                }
                case SIMPLE_TYPE: {
                    Annotated e = object.getSimpleType();
                    if (e instanceof TopLevelSimpleType) {
                        this.simpleTypeName.put(((SimpleType)e).getName(), object);
                    }
                    this.simpleTypes.put((SimpleType)e, object);
                    break;
                }
                case MODEL_GROUP: {
                    Annotated e = object.getModelGroup();
                    this.modelGroupName.put(((Group)e).getName(), object);
                    this.modelGroups.put((NamedGroup)e, object);
                    this.preload(object, (Group)e, stack);
                    break;
                }
                case ATTRIBUTE: {
                    Annotated e = object.getAttribute();
                    this.attrName.put(((org.w3._2001.xmlschema.Attribute)e).getName(), object);
                    this.attributes.put((org.w3._2001.xmlschema.Attribute)e, object);
                }
            }
        }
    }

    private void preload(SchemaObject parent, Group eg, Deque<SchemaObject> stack) {
        for (Object o : eg.getParticle()) {
            if (o instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)o;
                Object elemValue = element.getValue();
                if (elemValue instanceof org.w3._2001.xmlschema.Element) {
                    SchemaObject obj = new SchemaObject(this, parent, (org.w3._2001.xmlschema.Element)elemValue);
                    obj.setRename(this.getRename((org.w3._2001.xmlschema.Element)elemValue));
                    stack.add(obj);
                    continue;
                }
                if (elemValue instanceof ExplicitGroup) {
                    this.preload(parent, (ExplicitGroup)elemValue, stack);
                    continue;
                }
                if (elemValue instanceof RealGroup) {
                    this.preload(parent, (RealGroup)elemValue, stack);
                    continue;
                }
                throw new RuntimeException("Unknown ExplicitGroup element " + elemValue.getClass().getName());
            }
            if (o instanceof Any) continue;
            throw new RuntimeException("Unknown ExplicitGroup reference " + o.getClass().getName());
        }
    }

    protected void handle(TopLevelAttribute topLevelAttribute) {
        this.handle(null, topLevelAttribute);
    }

    protected void handleSimpleType(SchemaObject topLevelSimpleType) {
        this.handleSimpleType(null, topLevelSimpleType);
    }

    protected void handle(NamedAttributeGroup namedAttributeGroup) {
        this.handle(null, namedAttributeGroup);
    }

    protected void handle(NamedGroup namedAttributeGroup) {
        this.handle(null, namedAttributeGroup);
    }

    protected QName getComplexTypeBase(Object parent, org.w3._2001.xmlschema.ComplexType complexType) {
        if (complexType == null) {
            return null;
        }
        ComplexContent complexContent = complexType.getComplexContent();
        if (complexContent != null) {
            ExtensionType extensionType = complexContent.getExtension();
            if (extensionType != null) {
                QName type = extensionType.getBase();
                return type;
            }
            ComplexRestrictionType restriction = complexContent.getRestriction();
            if (restriction != null) {
                return restriction.getBase();
            }
        }
        if (complexType.isMixed()) {
            for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
                if (!(e.getValue() instanceof IgnoreMixed)) continue;
                IgnoreMixed im = (IgnoreMixed)e.getValue();
                if (this.matchesObj(complexType, im.getElementOrComplexType())) {
                    return null;
                }
                if (!(parent instanceof org.w3._2001.xmlschema.Element ? this.matchesObj((org.w3._2001.xmlschema.Element)parent, im.getElementOrComplexType()) : (parent instanceof org.w3._2001.xmlschema.ComplexType ? this.matchesObj((org.w3._2001.xmlschema.ComplexType)parent, im.getElementOrComplexType()) : parent instanceof SchemaObject && this.matchesObj((SchemaObject)parent, im.getElementOrComplexType())))) continue;
                return null;
            }
            return new QName(SCHEMA_NS, "string");
        }
        return null;
    }

    protected boolean matchesObj(SchemaObject so, java.util.List<Object> ruleRefs) {
        if (so.getElement() != null) {
            return this.matchesObj(so.getElement(), ruleRefs);
        }
        if (so.getComplexType() != null) {
            return this.matchesObj(so.getComplexType(), ruleRefs);
        }
        if (so.getAttribute() != null) {
            return this.matchesObj(so.getAttribute(), ruleRefs);
        }
        return false;
    }

    protected boolean matchesObj(org.w3._2001.xmlschema.Element e, java.util.List<Object> ruleRefs) {
        for (Object o : ruleRefs) {
            if (!(o instanceof Element) || !e.getName().equals(((Element)o).getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesObj(org.w3._2001.xmlschema.ComplexType ct, java.util.List<Object> ruleRefs) {
        if (ct.getName() == null || ct.getName().length() == 0) {
            return false;
        }
        for (Object o : ruleRefs) {
            if (!(o instanceof ComplexType) || !ct.getName().equals(((ComplexType)o).getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesObj(org.w3._2001.xmlschema.Attribute a, java.util.List<Object> ruleRefs) {
        for (Object o : ruleRefs) {
            if (!(o instanceof Attribute) || !a.getName().equals(((Attribute)o).getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected QName getSimpleTypeBase(SimpleType simpleType) {
        Restriction restriction = simpleType.getRestriction();
        if (restriction != null) {
            QName base = restriction.getBase();
            return base;
        }
        if (simpleType.getId() != null) {
            throw new RuntimeException(String.valueOf(simpleType.getName()) + " restriction error");
        }
        if (simpleType.getUnion() != null) {
            Union union = simpleType.getUnion();
            if (union.getMemberTypes().size() > 0) {
                void var4_7;
                Object var4_6 = null;
                for (QName type : union.getMemberTypes()) {
                    QName sType = null;
                    TypeEntry entry = this.getTypeEntry(type);
                    if (entry == null) {
                        SchemaObject obj = this.getSimpleType(type);
                        if (obj == null) {
                            throw new RuntimeException(String.valueOf(simpleType.getName()) + " union has unresolved reference " + type.getLocalPart());
                        }
                        sType = this.getSimpleTypeBase(obj.getSimpleType());
                    } else {
                        sType = type;
                    }
                    if (var4_7 == null) {
                        QName qName = sType;
                        continue;
                    }
                    if (var4_7.equals(sType)) continue;
                    QName qName = new QName(SCHEMA_NS, "string");
                }
                return var4_7;
            }
            if (union.getSimpleType().size() == 0) {
                throw new RuntimeException(String.valueOf(simpleType.getName()) + " union error");
            }
            for (SimpleType simpleType2 : union.getSimpleType()) {
                if (restriction == null) {
                    restriction = simpleType2.getRestriction();
                    continue;
                }
                Restriction r = simpleType2.getRestriction();
                if (r.getBase().equals(restriction.getBase())) continue;
                Inheritance rI = new Inheritance("");
                this.getAtomicTypeInheritance(r.getBase(), rI);
                Inheritance restI = new Inheritance("");
                this.getAtomicTypeInheritance(restriction.getBase(), restI);
                if (rI.atomicType.l0Type.equals(restI.atomicType.l0Type)) continue;
                throw new RuntimeException(String.valueOf(simpleType.getName()) + " union has incompatible restriction bases");
            }
            QName qName = restriction.getBase();
            return qName;
        }
        if (simpleType.getList() != null) {
            List list = simpleType.getList();
            return list.getItemType();
        }
        throw new RuntimeException(String.valueOf(simpleType.getName()) + " restriction error");
    }

    protected QName getElementBase(org.w3._2001.xmlschema.Element element) {
        LocalComplexType complexType = element.getComplexType();
        LocalSimpleType simpleType = element.getSimpleType();
        if (complexType != null) {
            return this.getComplexTypeBase(element, complexType);
        }
        if (simpleType != null) {
            return this.getSimpleTypeBase(simpleType);
        }
        return null;
    }

    private void handleAttributes(SchemaObject complexType, java.util.List<Annotated> attributeOrAttributeGroup) {
        Set<Annotated> handled = this.handleAttributeCompositions(complexType, attributeOrAttributeGroup);
        for (Annotated annotated : attributeOrAttributeGroup) {
            if (handled.contains(annotated)) continue;
            if (annotated instanceof org.w3._2001.xmlschema.Attribute) {
                this.handle(complexType, (org.w3._2001.xmlschema.Attribute)annotated);
                continue;
            }
            if (annotated instanceof AttributeGroup) {
                this.handle(complexType, (AttributeGroup)annotated);
                continue;
            }
            throw new RuntimeException();
        }
    }

    protected void handleAttributes(SchemaObject simpleTypeObj) {
        this.component.handleAttributes(simpleTypeObj);
    }

    protected void handleExtensionAttributes(SchemaObject complexType) {
        SimpleExtensionType extensionType;
        SimpleContent simpleContent;
        ExtensionType extensionType2;
        ComplexContent complexContent = complexType.getComplexType().getComplexContent();
        if (complexContent != null && (extensionType2 = complexContent.getExtension()) != null) {
            this.handleAttributes(complexType, extensionType2.getAttributeOrAttributeGroup());
        }
        if ((simpleContent = complexType.getComplexType().getSimpleContent()) != null && (extensionType = simpleContent.getExtension()) != null) {
            this.handleAttributes(complexType, extensionType.getAttributeOrAttributeGroup());
        }
    }

    protected void handleComplexTypeAttributes(SchemaObject complexType) {
        this.handleAttributes(complexType, complexType.getComplexType().getAttributeOrAttributeGroup());
    }

    protected void handleElementComplexTypeAttributes(SchemaObject complexType) {
        if (complexType != null) {
            this.handleComplexTypeAttributes(complexType);
            this.handleExtensionAttributes(complexType);
        }
    }

    protected void handleElementSimpleTypeAttributes(SchemaObject simpleType) {
        if (simpleType != null) {
            this.handleAttributes(simpleType);
        }
    }

    protected Set<Annotated> handleAttributeCompositions(SchemaObject obj, java.util.List<Annotated> attributeOrAttributeGroup) {
        HashSet<Annotated> handled = new HashSet<Annotated>();
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            if (!(e.getValue() instanceof AttributeComposition)) continue;
            AttributeComposition composition = (AttributeComposition)e.getValue();
            if (composition.getAttribute().size() < 2) {
                throw new RuntimeException("Attribute Composition is not valid");
            }
            BijectionMap map = new BijectionMap();
            for (Attribute a : composition.getAttribute()) {
                for (Annotated annotated : attributeOrAttributeGroup) {
                    if (!(annotated instanceof org.w3._2001.xmlschema.Attribute)) continue;
                    org.w3._2001.xmlschema.Attribute attribute = (org.w3._2001.xmlschema.Attribute)annotated;
                    QName type = this.getBaseType(attribute);
                    if (!a.getName().equals(attribute.getName()) || type == null || !a.getType().equals(type.getLocalPart())) continue;
                    map.map((Object)a, (Object)attribute);
                }
            }
            if (composition.getAttribute().size() != map.size()) continue;
            handled.addAll(map.getRightSet());
            this.handleAttributeComposition(obj, composition, (BijectionMap<Attribute, Annotated>)map);
        }
        return handled;
    }

    protected QName getBaseType(org.w3._2001.xmlschema.Attribute attribute) {
        Restriction restriction;
        if (attribute.getType() != null) {
            return attribute.getType();
        }
        if (attribute.getRef() != null) {
            return attribute.getRef();
        }
        LocalSimpleType simpleType = attribute.getSimpleType();
        if (simpleType != null && (restriction = simpleType.getRestriction()) != null && restriction.getBase() != null) {
            return restriction.getBase();
        }
        return null;
    }

    protected QName getPrimitiveType(org.w3._2001.xmlschema.Attribute attribute) {
        QName type = this.getBaseType(attribute);
        String b = this.getBindingFromPrimitiveType(type);
        while (b == null && type != null) {
            Restriction restriction;
            SchemaObject baseType = this.simpleTypeName.get(type.getLocalPart());
            if (baseType == null || (restriction = baseType.getSimpleType().getRestriction()) == null || restriction.getBase() == null) continue;
            type = restriction.getBase();
            b = this.getBindingFromPrimitiveType(type);
        }
        return type;
    }

    private SchemaObject _getAttribute(QName name) {
        return this.attrName.get(name.getLocalPart());
    }

    protected org.w3._2001.xmlschema.Attribute getRefAttribute(QName ref) {
        SchemaObject obj = this._getAttribute(ref);
        if (obj != null) {
            return obj.getAttribute();
        }
        if (ref.getNamespaceURI() != null) {
            for (SchemaConverter sc : this.converter.getConverter(ref.getNamespaceURI())) {
                if (sc.base == null || (obj = sc.base._getAttribute(ref)) == null) continue;
                return obj.getAttribute();
            }
        }
        return null;
    }

    protected void handleAttributeComposition(SchemaObject obj, AttributeComposition composition, BijectionMap<Attribute, Annotated> attributes) {
        this.component.handleAttributeComposition(obj, composition, attributes);
    }

    protected void handleComplexType(SchemaObject complexType) {
        this.component.handleComplexType(complexType);
    }

    protected void handleElement(SchemaObject topLevelElement) {
        this.component.handleElement(topLevelElement);
    }

    protected void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement element, String refName, RefType refType, String baseRelationName) {
        this.component.handleIndicator(parent, indicator, element, refName, refType, baseRelationName);
    }

    protected void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement any) {
        this.component.handleIndicator(parent, indicator, any);
    }

    protected void handle(SchemaObject parent, SchemaElement indicator, java.util.List<SchemaElement> elements) {
        String name;
        String baseRelationName = null;
        if (indicator.getType() == SchemaElement.ElementType.CHOICE && (name = this.getChoiceName(elements)) != null) {
            baseRelationName = this.component.handleChoice(parent, indicator, elements, name);
        }
        if (indicator.getType() == SchemaElement.ElementType.SEQUENCE || indicator.getType() == SchemaElement.ElementType.CHOICE) {
            for (SchemaElement e : elements) {
                this.handle(parent, indicator, e, baseRelationName);
            }
        }
    }

    protected void handle(SchemaObject parent, ExplicitGroup eg, SchemaElement.ElementType indicator) {
        this.handle(parent, new SchemaElement(eg, indicator));
    }

    protected void handle(SchemaObject parent, GroupRef eg, SchemaElement.ElementType indicator) {
        this.handle(parent, new SchemaElement(eg, indicator));
    }

    protected void handle(SchemaObject parent, SchemaElement indicator) {
        ArrayList<SchemaElement> elements = new ArrayList<SchemaElement>();
        ArrayList<SchemaElement> choices = new ArrayList<SchemaElement>();
        ArrayList<SchemaElement> sequences = new ArrayList<SchemaElement>();
        ArrayList<SchemaElement> alls = new ArrayList<SchemaElement>();
        ArrayList<SchemaElement> anys = new ArrayList<SchemaElement>();
        ArrayList<SchemaElement> groups = new ArrayList<SchemaElement>();
        Group group = indicator.getGroup();
        if (group.getParticle().size() == 0 && group.getRef() != null) {
            QName ref = group.getRef();
            SchemaObject obj = this.getModelGroup(ref);
            NamedGroup ngroup = obj.getModelGroup();
            if (ngroup.getParticle().size() != 1) {
                throw new RuntimeException("Unknown NamedGroup reference " + ngroup);
            }
            for (Object o : ngroup.getParticle()) {
                JAXBElement element;
                Object elemValue;
                if (!(o instanceof JAXBElement) || !((elemValue = (element = (JAXBElement)o).getValue()) instanceof ExplicitGroup)) continue;
                QName qname = element.getName();
                if ("choice".equals(qname.getLocalPart())) {
                    indicator = new SchemaElement(indicator, (ExplicitGroup)elemValue, SchemaElement.ElementType.CHOICE);
                    group = indicator.getGroup();
                    continue;
                }
                if (!"sequence".equals(qname.getLocalPart())) continue;
                indicator = new SchemaElement(indicator, (ExplicitGroup)elemValue, SchemaElement.ElementType.SEQUENCE);
                group = indicator.getGroup();
            }
        }
        if (group.getParticle().size() > 0) {
            for (Object o : group.getParticle()) {
                if (o instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)o;
                    Object elemValue = element.getValue();
                    if (elemValue instanceof LocalElement) {
                        LocalElement localElement = (LocalElement)elemValue;
                        elements.add(new SchemaElement(indicator, localElement, SchemaElement.ElementType.ELEMENT));
                        continue;
                    }
                    if (elemValue instanceof All) {
                        alls.add(new SchemaElement(indicator, (All)elemValue, SchemaElement.ElementType.ALL));
                        continue;
                    }
                    if (elemValue instanceof ExplicitGroup) {
                        QName qname = element.getName();
                        if ("choice".equals(qname.getLocalPart())) {
                            choices.add(new SchemaElement(indicator, (ExplicitGroup)elemValue, SchemaElement.ElementType.CHOICE));
                            continue;
                        }
                        if (!"sequence".equals(qname.getLocalPart())) continue;
                        sequences.add(new SchemaElement(indicator, (ExplicitGroup)elemValue, SchemaElement.ElementType.SEQUENCE));
                        continue;
                    }
                    if (elemValue instanceof RealGroup) {
                        if (elemValue instanceof GroupRef) {
                            groups.add(new SchemaElement(indicator, (GroupRef)elemValue, SchemaElement.ElementType.GROUP_REF));
                            continue;
                        }
                        if (elemValue instanceof NamedGroup) {
                            groups.add(new SchemaElement(indicator, (NamedGroup)elemValue, SchemaElement.ElementType.NAMED_GROUP));
                            continue;
                        }
                        throw new RuntimeException("Unknown ExplicitGroup element " + elemValue.getClass().getName());
                    }
                    throw new RuntimeException("Unknown ExplicitGroup element " + elemValue.getClass().getName());
                }
                if (o instanceof Any) {
                    anys.add(new SchemaElement(indicator, (Any)o, SchemaElement.ElementType.ANY));
                    continue;
                }
                throw new RuntimeException("Unknown ExplicitGroup reference " + o.getClass().getName());
            }
            if (elements.size() == 0 && choices.size() == 0 && sequences.size() == 0 && alls.size() == 0 && anys.size() == 0 && groups.size() == 0) {
                return;
            }
        } else {
            throw new RuntimeException("Empty / unrecognized indicator references " + indicator.getClass().getName());
        }
        if (indicator.getType() == SchemaElement.ElementType.SEQUENCE) {
            if (indicator.getRestriction().single()) {
                if (elements.size() > 0) {
                    for (SchemaElement e : sequences) {
                        this.handle(parent, e);
                    }
                    for (SchemaElement c : choices) {
                        this.handle(parent, c);
                    }
                    for (SchemaElement c : alls) {
                        this.handle(parent, c);
                    }
                    for (SchemaElement c : groups) {
                        this.handle(parent, c);
                    }
                    this.handle(parent, indicator, elements);
                    for (SchemaElement a : anys) {
                        this.handleIndicator(parent, indicator, a);
                    }
                } else {
                    if (sequences.size() > 0) {
                        throw new RuntimeException("Cannot handle Sequence with inner Sequences");
                    }
                    for (SchemaElement c : choices) {
                        this.handle(parent, c);
                    }
                    for (SchemaElement a : anys) {
                        this.handleIndicator(parent, indicator, a);
                    }
                    for (SchemaElement c : groups) {
                        this.handle(parent, c);
                    }
                }
            } else {
                if (choices.size() == 1 && sequences.size() == 0 && alls.size() == 0 && groups.size() == 0) {
                    SchemaElement choice = (SchemaElement)choices.get(0);
                    if (indicator.getRestriction().max == -1L || choice.getRestriction().max > 0L && indicator.getRestriction().max > choice.getRestriction().max) {
                        choice.getRestriction().max = indicator.getRestriction().max;
                    }
                    if (indicator.getRestriction().min == 0L || choice.getRestriction().min > indicator.getRestriction().min) {
                        choice.getRestriction().min = indicator.getRestriction().min;
                    }
                    this.handle(parent, choice, elements);
                    return;
                }
                if (sequences.size() > 0 || choices.size() > 0 || alls.size() > 0 || groups.size() > 0) {
                    throw new RuntimeException("Cannot handle Sequence with inner ExplicitGroups");
                }
                this.handle(parent, indicator, elements);
                for (SchemaElement a : anys) {
                    this.handleIndicator(parent, indicator, a);
                }
            }
        } else if (indicator.getType() == SchemaElement.ElementType.CHOICE) {
            if (indicator.getRestriction().single()) {
                if (sequences.size() > 0 || choices.size() > 0 || alls.size() > 0 || groups.size() > 0) {
                    throw new RuntimeException("Cannot handle Choice that contains something else than Elements");
                }
                if (elements.size() > 0) {
                    this.handle(parent, indicator, elements);
                }
                for (SchemaElement a : anys) {
                    this.handleIndicator(parent, indicator, a);
                }
            } else {
                if (sequences.size() > 0 || choices.size() > 0 || alls.size() > 0 || groups.size() > 0) {
                    throw new RuntimeException("Cannot handle Choice with inner ExplicitGroups");
                }
                if (elements.size() > 0) {
                    this.handle(parent, indicator, elements);
                }
                for (SchemaElement a : anys) {
                    this.handleIndicator(parent, indicator, a);
                }
            }
        } else if (indicator.getType() == SchemaElement.ElementType.ALL) {
            if (sequences.size() > 0 || choices.size() > 0 || alls.size() > 0 || anys.size() > 0 || groups.size() > 0) {
                throw new RuntimeException("Cannot handle All that contains something else than Elements");
            }
            if (!indicator.getRestriction().single()) {
                throw new RuntimeException("All indicator must have maxOccurs=1");
            }
            this.handle(parent, indicator, elements);
        }
    }

    protected void handle(SchemaObject parent, SchemaElement indicator, SchemaElement element, String baseRelationName) {
        org.w3._2001.xmlschema.Element localElement = element.getElement();
        if (localElement.getName() != null) {
            QName refType;
            SchemaObject eObj = this.getElement(localElement);
            if (eObj == null) {
                eObj = new SchemaObject(this, localElement);
            }
            if ((refType = localElement.getType()) != null) {
                this.handleIndicator(parent, indicator, element, null, RefType.Type, baseRelationName);
            } else {
                this.handleElement(eObj);
                this.handleIndicator(parent, indicator, element, null, RefType.Element, baseRelationName);
            }
        } else if (localElement.getRef() != null) {
            this.handleIndicator(parent, indicator, element, null, RefType.Reference, baseRelationName);
        }
    }

    protected String getName(org.w3._2001.xmlschema.Element localElement) {
        QName refType;
        if (localElement.getName() != null) {
            String refName = localElement.getName();
            return this.escapeName(refName);
        }
        if (localElement.getRef() != null && (refType = localElement.getRef()) != null) {
            return this.getName(refType);
        }
        return null;
    }

    protected String getName(QName ref) {
        String n = ref.getLocalPart();
        return this.escapeName(n);
    }

    protected String escapeName(String n) {
        return n.replaceAll("[\\.-]", "_");
    }

    protected String getName(org.w3._2001.xmlschema.Attribute ref) {
        String n = ref.getName();
        if (n != null) {
            return this.escapeName(n);
        }
        return null;
    }

    protected String getChoiceName(java.util.List<SchemaElement> elements) {
        if (elements.size() == 1) {
            return null;
        }
        if (elements.size() > 0 && elements.size() <= 3) {
            ArrayList<String> names = new ArrayList<String>();
            for (SchemaElement e : elements) {
                String name = this.getName(e.getElement());
                if (name == null) continue;
                names.add(name);
            }
            String name = "";
            int i = 0;
            while (i < names.size()) {
                name = i == 0 ? (String)names.get(i) : String.valueOf(name) + "Or" + (String)names.get(i);
                ++i;
            }
            return name;
        }
        return "SubElement";
    }

    protected void handle(SchemaObject parent, org.w3._2001.xmlschema.Attribute attribute) {
        this.component.handle(parent, attribute);
    }

    protected void handle(SchemaObject parent, AttributeGroup attribute) {
        this.component.handle(parent, attribute);
    }

    protected void handle(SchemaObject parent, NamedGroup group) {
        this.component.handle(parent, group);
        SchemaObject o = this.getModelGroup(group);
        this.handleGroupContents(o, group);
    }

    protected void handleGroupContents(SchemaObject parent, Group group) {
        for (Object o : group.getParticle()) {
            if (o instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)o;
                Object elemValue = element.getValue();
                if (elemValue instanceof org.w3._2001.xmlschema.Element) {
                    this.handleElement(this.getElement((org.w3._2001.xmlschema.Element)elemValue));
                    continue;
                }
                if (elemValue instanceof ExplicitGroup) {
                    this.handleGroupContents(parent, (ExplicitGroup)elemValue);
                    continue;
                }
                if (elemValue instanceof RealGroup) {
                    this.handleGroupContents(parent, (RealGroup)elemValue);
                    continue;
                }
                throw new RuntimeException("Unknown ExplicitGroup element " + elemValue.getClass().getName());
            }
            if (o instanceof Any) continue;
            throw new RuntimeException("Unknown ExplicitGroup reference " + o.getClass().getName());
        }
    }

    protected void handleSimpleType(SchemaObject parent, SchemaObject simpleType) {
        this.component.handleSimpleType(parent, simpleType);
    }

    protected void handleComplexTypeExtension(SchemaObject complexTypeObj) {
        org.w3._2001.xmlschema.ComplexType complexType = complexTypeObj.getComplexType();
        if (complexType != null) {
            ExtensionType extensionType;
            if (complexType.getChoice() != null) {
                this.handle(complexTypeObj, complexType.getChoice(), SchemaElement.ElementType.CHOICE);
            }
            if (complexType.getSequence() != null) {
                this.handle(complexTypeObj, complexType.getSequence(), SchemaElement.ElementType.SEQUENCE);
            }
            if (complexType.getAll() != null) {
                this.handle(complexTypeObj, complexType.getAll(), SchemaElement.ElementType.ALL);
            }
            if (complexType.getGroup() != null) {
                throw new RuntimeException("Groups not supported");
            }
            ComplexContent complexContent = complexType.getComplexContent();
            if (complexContent != null && (extensionType = complexContent.getExtension()) != null) {
                if (extensionType.getChoice() != null) {
                    this.handle(complexTypeObj, extensionType.getChoice(), SchemaElement.ElementType.CHOICE);
                }
                if (extensionType.getSequence() != null) {
                    this.handle(complexTypeObj, extensionType.getSequence(), SchemaElement.ElementType.SEQUENCE);
                }
                if (extensionType.getAll() != null) {
                    this.handle(complexTypeObj, extensionType.getAll(), SchemaElement.ElementType.ALL);
                }
                if (extensionType.getGroup() != null) {
                    throw new RuntimeException("Groups not supported");
                }
            }
        }
    }

    public boolean isElementRef(String ref) {
        return this.elementName.containsKey(ref);
    }

    public boolean isComplexTypeRef(String ref) {
        return this.complexTypeName.containsKey(ref);
    }

    public boolean isSimpleTypeRef(String ref) {
        return this.simpleTypeName.containsKey(ref);
    }

    public IDProvider getIDProvider(org.w3._2001.xmlschema.Element element) {
        ArrayList<IDProvider> idProviders = new ArrayList<IDProvider>(2);
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            IDProvider ref;
            Element element2;
            if (!(e.getValue() instanceof IDProvider) || (element2 = (ref = (IDProvider)e.getValue()).getElement()) == null || !element.getName().equals(element2.getName())) continue;
            idProviders.add(ref);
        }
        if (idProviders.size() == 0) {
            return null;
        }
        if (idProviders.size() > 1) {
            throw new RuntimeException("Element " + element.getName() + " contains " + idProviders.size() + " id provider rules, only one is allowed.");
        }
        return (IDProvider)idProviders.get(0);
    }

    public IDProvider getIDProvider(org.w3._2001.xmlschema.ComplexType complexType) {
        ArrayList<IDProvider> idProviders = new ArrayList<IDProvider>(2);
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            IDProvider ref;
            ComplexType complexType2;
            if (!(e.getValue() instanceof IDProvider) || (complexType2 = (ref = (IDProvider)e.getValue()).getComplexType()) == null || !complexType.getName().equals(complexType2.getName())) continue;
            idProviders.add(ref);
        }
        if (idProviders.size() == 0) {
            return null;
        }
        if (idProviders.size() > 1) {
            throw new RuntimeException("Element " + complexType.getName() + " contains " + idProviders.size() + " id provider rules, only one is allowed.");
        }
        return (IDProvider)idProviders.get(0);
    }

    public java.util.List<IDReference> getIDReferences(org.w3._2001.xmlschema.Element element) {
        ArrayList<IDReference> idReferences = new ArrayList<IDReference>(2);
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            IDReference ref;
            Element element2;
            if (!(e.getValue() instanceof IDReference) || (element2 = (ref = (IDReference)e.getValue()).getElement()) == null || !element.getName().equals(element2.getName())) continue;
            idReferences.add(ref);
        }
        return idReferences;
    }

    public java.util.List<IDReference> getIDReferences(org.w3._2001.xmlschema.ComplexType complexType) {
        ArrayList<IDReference> idReferences = new ArrayList<IDReference>(2);
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            IDReference ref;
            ComplexType complexType2;
            if (!(e.getValue() instanceof IDReference) || (complexType2 = (ref = (IDReference)e.getValue()).getComplexType()) == null || !complexType.getName().equals(complexType2.getName())) continue;
            idReferences.add(ref);
        }
        return idReferences;
    }

    public UnrecognizedChildElement getUnknown(org.w3._2001.xmlschema.ComplexType complexType) {
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            UnrecognizedChildElement rule;
            ComplexType complexType2;
            if (!(e.getValue() instanceof UnrecognizedChildElement) || (complexType2 = (rule = (UnrecognizedChildElement)e.getValue()).getComplexType()) == null || !complexType.getName().equals(complexType2.getName())) continue;
            return rule;
        }
        return null;
    }

    public UnrecognizedChildElement getUnknown(org.w3._2001.xmlschema.Element element) {
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            UnrecognizedChildElement rule;
            Element element2;
            if (!(e.getValue() instanceof UnrecognizedChildElement) || (element2 = (rule = (UnrecognizedChildElement)e.getValue()).getElement()) == null || !element.getName().equals(element2.getName())) continue;
            return rule;
        }
        return null;
    }

    public Rename getRename(org.w3._2001.xmlschema.Attribute element) {
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            Rename rule;
            if (!(e.getValue() instanceof Rename) || !this.matchesObj(element, (rule = (Rename)e.getValue()).getElementOrComplexTypeOrAttribute())) continue;
            return rule;
        }
        return null;
    }

    public Rename getRename(org.w3._2001.xmlschema.ComplexType element) {
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            Rename rule;
            if (!(e.getValue() instanceof Rename) || !this.matchesObj(element, (rule = (Rename)e.getValue()).getElementOrComplexTypeOrAttribute())) continue;
            return rule;
        }
        return null;
    }

    public Rename getRename(org.w3._2001.xmlschema.Element element) {
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            Element element2;
            Rename rule;
            Object ref;
            if (!(e.getValue() instanceof Rename) || !((ref = (rule = (Rename)e.getValue()).getElementOrComplexTypeOrAttribute().get(0)) instanceof Element) || !(element2 = (Element)ref).getName().equals(element.getName())) continue;
            return rule;
        }
        return null;
    }

    public boolean useOriginalList(SchemaObject parent, SchemaElement indicator, SchemaElement element, boolean reference, String ref, QName refType) {
        if (parent.getName() == null) {
            parent = parent.getParent();
        }
        if (parent.getName().contains("PipingNetworkSegment")) {
            System.out.println();
        }
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            if (!(e.getValue() instanceof OrderedChild)) continue;
            OrderedChild oc = (OrderedChild)e.getValue();
            Element element2 = oc.getElement();
            ComplexType complexType = oc.getComplexType();
            Element child = oc.getChild();
            if (!oc.getType().equals("original")) continue;
            boolean match = false;
            if (element2 != null) {
                if (parent.getType() == SchemaObject.ObjectType.ELEMENT && parent.getName().equals(element2.getName())) {
                    match = true;
                }
            } else if (complexType != null && parent.getType() == SchemaObject.ObjectType.COMPLEX_TYPE && parent.getName() != null && parent.getName().equals(complexType.getName())) {
                match = true;
            }
            if (!match) continue;
            if (child != null) {
                if (!this.matchChild(child, ref, refType)) continue;
                return this.strToBoolean(oc.getValue());
            }
            return this.strToBoolean(oc.getValue());
        }
        return indicator.order();
    }

    public boolean useElementList(SchemaObject parent, SchemaElement indicator, SchemaElement element, boolean reference, String refName, QName refType) {
        if (parent.getName() == null) {
            parent = parent.getParent();
        }
        for (JAXBElement<? extends ConversionRule> e : this.configuration.getConversionRule()) {
            if (!(e.getValue() instanceof OrderedChild)) continue;
            OrderedChild oc = (OrderedChild)e.getValue();
            Element element2 = oc.getElement();
            ComplexType complexType = oc.getComplexType();
            Element child = oc.getChild();
            if (!oc.getType().equals("child")) continue;
            boolean match = false;
            if (element2 != null) {
                if (parent.getType() == SchemaObject.ObjectType.ELEMENT && parent.getName().equals(element2.getName())) {
                    match = true;
                }
            } else if (complexType != null && parent.getType() == SchemaObject.ObjectType.COMPLEX_TYPE && parent.getName() != null && parent.getName().equals(complexType.getName())) {
                match = true;
            }
            if (!match) continue;
            if (child != null) {
                if (!this.matchChild(child, refName, refType)) continue;
                return this.strToBoolean(oc.getValue());
            }
            return this.strToBoolean(oc.getValue());
        }
        return element.many() && element.order();
    }

    protected boolean strToBoolean(String s) {
        return !s.toLowerCase().equals("disable");
    }

    private boolean matchChild(Element child, String refName, QName refType) {
        if (refType != null && refType.getLocalPart().equals(child.getName())) {
            return true;
        }
        return refName != null && refName.equals(child.getName());
    }

    public String getComplexTypePrefix() {
        return this.component.getComplexTypePrefix();
    }

    public String getAttributeGroupPrefix() {
        return this.component.getAttributeGroupPrefix();
    }

    public String getName(SchemaObject obj) {
        return this.component.getName(obj);
    }

    public String getBaseClass(SchemaObject.ObjectType type) {
        return this.component.getBaseClass(type);
    }

    public Inheritance getInheritance(SchemaObject topLevelObj) {
        Inheritance inheritance = null;
        if (topLevelObj.getType() == SchemaObject.ObjectType.ELEMENT) {
            TypeEntry entry;
            SchemaObject obj;
            QName type;
            org.w3._2001.xmlschema.Element topLevelElement = topLevelObj.getElement();
            inheritance = new Inheritance(this.getBaseClass(SchemaObject.ObjectType.ELEMENT));
            if (topLevelElement.getType() != null) {
                type = topLevelElement.getType();
                if (!type.getNamespaceURI().equals(SCHEMA_NS)) {
                    obj = this.complexTypeName.get(type.getLocalPart());
                    if (obj != null) {
                        inheritance.baseClass = this.getName(obj);
                        inheritance.type = InheritanceType.ComplexType;
                    } else {
                        obj = this.simpleTypeName.get(type.getLocalPart());
                        if (obj != null) {
                            this.getAtomicTypeInheritance(type, inheritance);
                        }
                    }
                } else {
                    entry = this.getTypeEntry(type);
                    if (entry != null) {
                        inheritance.type = InheritanceType.AtomicType;
                        inheritance.atomicType = entry;
                    }
                }
            }
            if (inheritance.type == InheritanceType.None && (type = this.getElementBase(topLevelElement)) != null) {
                if (!type.getNamespaceURI().equals(SCHEMA_NS)) {
                    obj = this.getWithName(type);
                    inheritance.baseClass = this.getName(obj);
                    inheritance.type = InheritanceType.ComplexType;
                } else {
                    entry = this.getTypeEntry(type);
                    if (entry != null) {
                        inheritance.type = InheritanceType.AtomicType;
                        inheritance.atomicType = entry;
                    }
                }
            }
            if (inheritance.type == InheritanceType.None && (type = topLevelElement.getSubstitutionGroup()) != null) {
                if (!type.getNamespaceURI().equals(SCHEMA_NS)) {
                    obj = this.getWithName(type);
                    inheritance.baseClass = this.getName(obj);
                    inheritance.type = InheritanceType.ComplexType;
                } else {
                    entry = this.getTypeEntry(type);
                    if (entry != null) {
                        inheritance.type = InheritanceType.AtomicType;
                        inheritance.atomicType = entry;
                    }
                }
            }
        } else if (topLevelObj.getType() == SchemaObject.ObjectType.COMPLEX_TYPE) {
            SimpleExtensionType extensionType;
            SimpleContent simpleContent;
            SchemaObject obj;
            org.w3._2001.xmlschema.ComplexType complexType = topLevelObj.getComplexType();
            QName type = this.getComplexTypeBase(topLevelObj, complexType);
            inheritance = new Inheritance(this.getBaseClass(SchemaObject.ObjectType.COMPLEX_TYPE));
            if (type != null && !type.getNamespaceURI().equals(SCHEMA_NS) && (obj = this.complexTypeName.get(type.getLocalPart())) != null) {
                inheritance.baseClass = this.getName(obj);
                inheritance.type = InheritanceType.ComplexType;
            }
            if ((simpleContent = complexType.getSimpleContent()) != null && (extensionType = simpleContent.getExtension()) != null) {
                type = extensionType.getBase();
                SchemaObject simpleType = this.getSimpleType(type);
                if (simpleType != null) {
                    inheritance.additionalClass = this.getName(simpleType);
                }
                this.getAtomicTypeInheritance(type, inheritance);
            }
        }
        return inheritance;
    }

    public void getAtomicTypeInheritance(QName type, Inheritance inheritance) {
        if (!type.getNamespaceURI().equals(SCHEMA_NS)) {
            SchemaObject obj = this.getSimpleType(type);
            if (obj == null) {
                throw new RuntimeException("Cannot locate SimpleType " + type.getLocalPart());
            }
            SimpleType simpleType = obj.getSimpleType();
            type = this.getSimpleTypeBase(simpleType);
            this.getAtomicTypeInheritance(type, inheritance);
        } else {
            TypeEntry entry = this.getTypeEntry(type);
            if (entry != null) {
                inheritance.type = InheritanceType.AtomicType;
                inheritance.atomicType = entry;
            }
        }
    }

    public String getDefaultValue(QName atype) {
        Map<String, TypeEntry> types = this.typeMap.get(atype.getNamespaceURI());
        if (types == null) {
            return null;
        }
        TypeEntry entry = types.get(atype.getLocalPart());
        if (entry == null) {
            return null;
        }
        return entry.defaultValue;
    }

    public static class Inheritance {
        public String baseClass;
        public String additionalClass;
        public InheritanceType type;
        public TypeEntry atomicType;

        public Inheritance(String baseClass) {
            this.baseClass = baseClass;
            this.type = InheritanceType.None;
        }
    }

    public static enum InheritanceType {
        ComplexType,
        AtomicType,
        None;

    }

    protected static enum RefType {
        Element,
        Reference,
        Type;

    }

    public static class TypeEntry {
        String l0Type;
        String binding;
        String javaType;
        String defaultValue;
        boolean id;
        String getterPrefix;
        String getterPostfix;
        String stringPrefix;
        String stringPostfix;

        public TypeEntry(String l0Type, String binding, String javaType, String defaultValue, String getterPrefix, String getterPostfix, String stringPrefix, String stringPostfix) {
            this.l0Type = l0Type;
            this.binding = binding;
            this.javaType = javaType;
            this.defaultValue = defaultValue;
            this.id = false;
            this.getterPrefix = getterPrefix;
            this.getterPostfix = getterPostfix;
            this.stringPrefix = stringPrefix;
            this.stringPostfix = stringPostfix;
        }

        public TypeEntry(String l0Type, String binding, String javaType, String defaultValue, String getterPrefix, String getterPostfix, String stringPrefix, String stringPostfix, boolean id) {
            this.l0Type = l0Type;
            this.binding = binding;
            this.javaType = javaType;
            this.defaultValue = defaultValue;
            this.id = id;
            this.getterPrefix = getterPrefix;
            this.getterPostfix = getterPostfix;
            this.stringPrefix = stringPrefix;
            this.stringPostfix = stringPostfix;
        }

        public String getValueGetterMethod(String name) {
            return String.valueOf(this.getterPrefix) + name + ".getValue()" + this.getterPostfix;
        }

        public String getValueGetter(String name) {
            return String.valueOf(this.getterPrefix) + name + this.getterPostfix;
        }

        public String getValueGetter() {
            return this.getValueGetter("value");
        }

        public String getToString(String name) {
            return String.valueOf(this.stringPrefix) + "(" + this.javaType + ")" + name + this.stringPostfix;
        }

        public String getElementToString(String name) {
            return String.valueOf(this.stringPrefix) + name + this.stringPostfix;
        }
    }
}

