/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.xml.sax.JavaGenerator;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.simantics.xml.sax.configuration.Attribute;
import org.simantics.xml.sax.configuration.AttributeComposition;
import org.simantics.xml.sax.configuration.IDProvider;
import org.simantics.xml.sax.configuration.IDReference;
import org.simantics.xml.sax.configuration.UnrecognizedChildElement;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.ComplexType;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.List;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.Restriction;
import org.w3._2001.xmlschema.SimpleType;

public class ExporterGenerator
extends JavaGenerator {
    IDProvider provider;

    public ExporterGenerator(SchemaConverter converter, SchemaConversionBase base) {
        super(converter, base);
    }

    public void createParser() throws IOException {
        String importerClassPostfix = "Exporter";
        String parserClassPostfix = "Writer";
        this.importParserDir = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.elementPackageName);
        if (!this.importParserDir.exists()) {
            this.importParserDir.mkdirs();
        }
        this.base.handle(this);
        File importerFile = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.name + importerClassPostfix + ".java");
        PrintWriter mainWriter = this.createFile(importerFile);
        mainWriter.println("package " + this.converter.getPluginName() + ";");
        mainWriter.println();
        mainWriter.println("import java.io.File;");
        mainWriter.println("import org.simantics.db.Resource;");
        mainWriter.println("import org.simantics.db.Session;");
        mainWriter.println("import org.simantics.db.exception.DatabaseException;");
        mainWriter.println("import org.simantics.xml.sax.base.AbstractExporter;");
        mainWriter.println();
        mainWriter.println("public class " + this.name + importerClassPostfix + " extends AbstractExporter {");
        mainWriter.println();
        mainWriter.println("   public " + this.name + importerClassPostfix + "(Session session, File file, Resource root) throws DatabaseException {");
        mainWriter.println("   \t  super(session, file, root);");
        mainWriter.println("   \t  setXmlWriter(new " + this.name + parserClassPostfix + "(session).resolveDependencies(session));");
        mainWriter.println("   }");
        mainWriter.println();
        mainWriter.println("}");
        mainWriter.println();
        mainWriter.flush();
        mainWriter.close();
        File parserFile = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.name + parserClassPostfix + ".java");
        mainWriter = this.createFile(parserFile);
        mainWriter.println("package " + this.converter.getPluginName() + ";");
        mainWriter.println();
        mainWriter.println("import org.simantics.xml.sax.base.XMLWriter;");
        mainWriter.println("import org.simantics.db.ReadGraph;");
        mainWriter.println("import org.simantics.db.Session;");
        mainWriter.println("import org.simantics.db.exception.DatabaseException;");
        mainWriter.println("import org.simantics.db.common.request.ReadRequest;");
        mainWriter.println();
        mainWriter.println("public class " + this.name + parserClassPostfix + " extends XMLWriter {");
        mainWriter.println();
        mainWriter.println("   public " + this.name + parserClassPostfix + "(Session session) throws DatabaseException {");
        if (this.schema.getTargetNamespace() != null) {
            mainWriter.println("      setSchemaURI(\"" + this.schema.getTargetNamespace() + "\");");
        }
        mainWriter.println("      setOntologyURI(\"" + this.ontologyUri + "\");");
        mainWriter.println("      session.syncRequest(new ReadRequest() {");
        mainWriter.println("        @Override");
        mainWriter.println("        public void run(ReadGraph graph) throws DatabaseException {");
        mainWriter.println("          setGraph(graph);");
        for (String s : this.ruleClassNames) {
            mainWriter.println("          add(new " + s + "(graph));");
        }
        mainWriter.println("        }");
        mainWriter.println("      });");
        mainWriter.println("   }");
        mainWriter.println();
        if (this.converter.getSubConverters().size() > 0) {
            String s;
            mainWriter.println("   public void addDependencies(org.simantics.db.Session session, java.util.Map<String,XMLWriter> map) throws DatabaseException {");
            for (SchemaConverter sc : this.converter.getSubConverters()) {
                s = sc.className;
                if (s.endsWith("Ontology")) {
                    s = s.substring(0, s.length() - "Ontology".length());
                }
                s = String.valueOf(s) + "Writer";
                mainWriter.println("      {");
                mainWriter.println("         XMLWriter parser = new " + s + "(session);");
                mainWriter.println("         if (!map.containsKey(parser.getSchemaURI())) {");
                mainWriter.println("            map.put(parser.getSchemaURI(), parser);");
                mainWriter.println("            parser.addDependencies(session,map);");
                mainWriter.println("         } else {");
                mainWriter.println("            parser = map.get(parser.getSchemaURI());");
                mainWriter.println("         }");
                mainWriter.println("         add(parser);");
                mainWriter.println("      }");
            }
            mainWriter.println("   }");
            mainWriter.println("   public XMLWriter resolveDependencies(org.simantics.db.Session session) throws DatabaseException {");
            mainWriter.println("      super.resolveDependencies(session);");
            for (SchemaConverter sc : this.converter.getSubConverters()) {
                s = sc.schemaNs;
                mainWriter.println("      if (!nsPrefixes.containsKey(\"" + s + "\")) {");
                mainWriter.println("         nsPrefixes.put(\"" + s + "\", \"ns\"+nsPrefixes.size());");
                mainWriter.println("      }");
            }
            mainWriter.println("      return this;");
            mainWriter.println("   }");
        }
        mainWriter.println("}");
        mainWriter.println();
        mainWriter.flush();
        mainWriter.close();
    }

    @Override
    protected String getPackagePostFix() {
        return "_exp";
    }

    @Override
    public String getBaseClass(SchemaObject.ObjectType type) {
        return "org.simantics.xml.sax.base.XMLElementNamedChildWriterBase";
    }

    @Override
    public void handleSimpleType(SchemaObject parent, SchemaObject simpleTypeObj) {
    }

    @Override
    public void handle(SchemaObject parent, NamedGroup attribute) {
    }

    @Override
    public void handleComplexType(SchemaObject complexTypeObj) {
        String name;
        ComplexType topLevelComplexType = complexTypeObj.getComplexType();
        String className = name = this.getName(complexTypeObj);
        JavaGenerator.FileWriter fw = new JavaGenerator.FileWriter();
        try {
            fw.writer = this.createFile(new File(String.valueOf(this.importParserDir.getAbsolutePath()) + "/" + className + ".java"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writers.put(complexTypeObj, fw);
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(complexTypeObj);
        this.provider = this.base.getIDProvider(topLevelComplexType);
        this.createClassHeader(fw.writer);
        this.writeClass(fw.writer, false, topLevelComplexType.getName(), className, inheritance.baseClass, Collections.emptyList());
        fw.writer.println("   @Override");
        fw.writer.println("   public Resource getType(ReadGraph graph) throws DatabaseException {");
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      return " + this.ontShort + name + ";");
        fw.writer.println("   }");
        fw.writer.println();
        StringWriter stringWriter = new StringWriter();
        fw.delayedWriter = new PrintWriter(stringWriter);
        StringWriter stringWriter2 = new StringWriter();
        fw.delayedWriter2 = new PrintWriter(stringWriter2);
        fw.writer.println("   public " + className + "(ReadGraph graph) {");
        fw.writer.println("      super(graph);");
        this.writeOntologyImports(fw);
        this.base.handleComplexTypeExtension(complexTypeObj);
        fw.writer.println("   }");
        fw.writer.println("   @Override");
        fw.writer.println("   public void children(ReadGraph graph, WriterElement instance, java.util.Set<org.simantics.db.Resource> result) throws XMLStreamException, DatabaseException {");
        fw.writer.println("      " + this.getOntologyImport());
        if (stringWriter.getBuffer().length() > 0) {
            fw.writer.write(stringWriter.toString());
        }
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      super.children(graph,instance,result);");
        }
        fw.writer.println("   }");
        fw.writer.println();
        if (stringWriter2.getBuffer().length() > 0) {
            fw.writer.write(stringWriter2.toString());
        }
        stringWriter = null;
        fw.delayedWriter.close();
        fw.delayedWriter = null;
        stringWriter2 = null;
        fw.delayedWriter2.close();
        fw.delayedWriter2 = null;
        fw.writer.println("   @Override");
        fw.writer.println("   public void attributes(ReadGraph graph, WriterElement instance, Collection<Statement> attributes, XMLStreamWriter writer) throws XMLStreamException, DatabaseException{");
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("   \t\tsuper.attributes(graph,instance,attributes,writer);");
        }
        this.writeOntologyImports(fw);
        fw.writer.println("        for (Statement attribute : attributes) {");
        this.base.handleComplexTypeAttributes(complexTypeObj);
        this.base.handleExtensionAttributes(complexTypeObj);
        fw.writer.println("        }");
        fw.writer.println("   }");
        if (inheritance.type == SchemaConversionBase.InheritanceType.AtomicType) {
            fw.writer.println();
            fw.writer.println("   @Override");
            fw.writer.println("   public void characters(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException, DatabaseException {");
            fw.writer.println("            writer.writeCharacters(" + inheritance.atomicType.getToString("graph.getValue(instance.getResource()," + inheritance.atomicType.binding + ")") + ");");
            fw.writer.println("   }");
        }
        fw.writer.println("}");
        fw.writer.println();
        fw.writer.flush();
        fw.writer.close();
        fw.writer = null;
        this.writers.remove(complexTypeObj);
        this.provider = null;
    }

    @Override
    protected void createReferenceIndicator(SchemaObject parent, SchemaConversionBase.RefType referenceType, String refName, String objectName, String primaryClassName, String secondaryClassName, boolean useElementList, boolean useOriginalList) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        if (referenceType == SchemaConversionBase.RefType.Type) {
            secondaryClassName = String.valueOf(this.getName(parent)) + "_" + objectName;
            if (objectName.equals(refName)) {
                fw.writer.println("      addRelationWriter(" + this.getFullName(parent) + "_has" + refName + ", " + secondaryClassName + ".class);");
            } else {
                fw.writer.println("      addRelationTypeWriter(" + this.getFullName(parent) + "_has" + refName + ", " + this.ontShort + primaryClassName + ", " + secondaryClassName + ".class);");
            }
            fw.delayedWriter2.println("   public static class " + secondaryClassName + " extends " + primaryClassName + "{");
            fw.delayedWriter2.println("      public " + secondaryClassName + "(ReadGraph graph){");
            fw.delayedWriter2.println("         super(graph);");
            fw.delayedWriter2.println("      }");
            fw.delayedWriter2.println("      ");
            fw.delayedWriter2.println("      @Override");
            fw.delayedWriter2.println("      public java.lang.String getElementId() {");
            fw.delayedWriter2.println("         return \"" + refName + "\";");
            fw.delayedWriter2.println("      }");
            fw.delayedWriter2.println("   }");
        } else {
            fw.writer.println("        addWriter(" + primaryClassName + ".class);");
            if (!primaryClassName.equals(secondaryClassName)) {
                fw.writer.println("        addWriter(" + secondaryClassName + ".class);");
            }
        }
        if (useElementList) {
            fw.delayedWriter.println("      {");
            fw.delayedWriter.println("         org.simantics.db.Resource list = graph.getPossibleObject(instance.getResource()," + this.ontShort + this.getName(parent) + "_has" + refName + "_List);");
            fw.delayedWriter.println("         if (list != null) {");
            fw.delayedWriter.println("            java.util.List<org.simantics.db.Resource> l = org.simantics.db.common.utils.ListUtils.toList(graph, list);");
            fw.delayedWriter.println("            result.addAll(l);");
            fw.delayedWriter.println("         } else {");
            fw.delayedWriter.println("            result.addAll(graph.getObjects(instance.getResource(), " + this.getFullName(parent) + "_has" + refName + "));");
            fw.delayedWriter.println("         }");
            fw.delayedWriter.println("      }");
        } else {
            fw.delayedWriter.println("      result.addAll(graph.getObjects(instance.getResource(), " + this.getFullName(parent) + "_has" + refName + "));");
        }
    }

    @Override
    protected void createPrimitiveIndicator(SchemaObject parent, String refName, SchemaConversionBase.TypeEntry typeEntry, QName typeName) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        String ontologyClassName = this.converter.getOntologyClassName(typeName.getNamespaceURI());
        String typeURI = ontologyClassName != null ? String.valueOf(ontologyClassName) + ".URIs." + this.getName(this.base.getSimpleType(typeName)) : "null";
        fw.writer.println("      addRelationWriter(" + this.ontShort + this.getName(parent) + "_has" + refName + ", " + this.getName(parent) + "_" + refName + ".class);");
        fw.delayedWriter2.println("   public static class " + this.getName(parent) + "_" + refName + " extends org.simantics.xml.sax.base.ValueElementWriter {");
        fw.delayedWriter2.println("      public " + this.getName(parent) + "_" + refName + "(){");
        fw.delayedWriter2.println("         super(\"" + refName + "\", " + typeURI + ", " + typeEntry.binding + ");");
        fw.delayedWriter2.println("      }\n");
        fw.delayedWriter2.println("      @Override");
        fw.delayedWriter2.println("      public java.lang.String decode(java.lang.Object value) {");
        fw.delayedWriter2.println("         return " + typeEntry.stringPrefix + "(" + typeEntry.javaType + ")value" + typeEntry.stringPostfix + ";");
        fw.delayedWriter2.println("      }");
        fw.delayedWriter2.println("   }");
    }

    @Override
    protected void createElementIndicator(SchemaObject parent, boolean useElementList, String refName, String objName, String className, boolean useOriginalList) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        fw.writer.println("        addTypeWriter(" + objName + ", " + className + ".class);");
        if (useElementList) {
            fw.delayedWriter.println("            {");
            fw.delayedWriter.println("               org.simantics.db.Resource list = graph.getPossibleObject(instance.getResource()," + this.getFullName(parent) + "_has" + refName + "_List);");
            fw.delayedWriter.println("               if (list != null) {");
            fw.delayedWriter.println("                  java.util.List<org.simantics.db.Resource> l = org.simantics.db.common.utils.ListUtils.toList(graph, list);");
            fw.delayedWriter.println("                  result.addAll(l);");
            fw.delayedWriter.println("               } else {");
            fw.delayedWriter.println("                  result.addAll(graph.getObjects(instance.getResource(), " + this.getFullName(parent) + "_has" + refName + "));");
            fw.delayedWriter.println("               }");
            fw.delayedWriter.println("            }");
        } else {
            fw.delayedWriter.println("         result.addAll(graph.getObjects(instance.getResource(), " + this.getFullName(parent) + "_has" + refName + "));");
        }
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement any) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        fw.delayedWriter2.println("   @Override");
        fw.delayedWriter2.println("   public Class<? extends org.simantics.xml.sax.base.XMLElementWriter> getWriter(ReadGraph graph, java.util.Map<Resource, org.simantics.xml.sax.base.XMLElementWriter> writers, WriterElement child) throws DatabaseException{");
        fw.delayedWriter2.println("      Class<? extends org.simantics.xml.sax.base.XMLElementWriter> writerClass = super.getWriter(graph, writers, child);");
        fw.delayedWriter2.println("      if (writerClass != null) return writerClass;");
        fw.delayedWriter2.println("      Resource type = graph.getSingleType(child.getResource());");
        fw.delayedWriter2.println("      org.simantics.xml.sax.base.XMLElementWriter writer = writers.get(type);");
        fw.delayedWriter2.println("      if (writer != null) return writer.getClass();");
        fw.delayedWriter2.println("      org.simantics.xml.sax.base.XMLElementWriter anyWriter = child.getBaseWriter().getWriter(child);");
        fw.delayedWriter2.println("      if (anyWriter != null) return anyWriter.getClass();");
        fw.delayedWriter2.println("      return null;");
        fw.delayedWriter2.println("   }");
    }

    @Override
    public void handle(SchemaObject parent, org.w3._2001.xmlschema.Attribute attribute) {
        String relationName;
        String attrName;
        if (parent == null) {
            return;
        }
        String name = attribute.getName();
        QName primitiveType = attribute.getType();
        SimpleType simpleType = attribute.getSimpleType();
        QName ref = attribute.getRef();
        String ns = null;
        String prefix = this.getRefPrefix(parent);
        if (name != null) {
            attrName = name;
            relationName = String.valueOf(prefix) + "has" + this.base.getName(attribute);
            if (parent != null) {
                relationName = String.valueOf(prefix) + this.getName(parent) + "_has" + this.base.getName(attribute);
            }
        } else if (ref != null && parent != null) {
            attrName = ref.getLocalPart();
            relationName = String.valueOf(prefix) + this.getName(parent) + "_has" + this.base.getName(ref);
            org.w3._2001.xmlschema.Attribute referred = this.base.getRefAttribute(ref);
            if (referred != null) {
                primitiveType = referred.getType();
                simpleType = referred.getSimpleType();
                if (ref.getNamespaceURI() != null && !ref.getNamespaceURI().equals(this.converter.schemaNs)) {
                    ns = ref.getNamespaceURI();
                }
            }
        } else {
            throw new RuntimeException();
        }
        boolean isReference = false;
        if (this.provider != null && this.provider.getAttribute().getName().equals(attrName)) {
            isReference = true;
        }
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        if (primitiveType != null) {
            SchemaObject simpleTypeObj;
            SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(primitiveType);
            if (binding != null) {
                if (ns != null) {
                    this.writeAttribute(fw, ns, attrName, relationName, binding, isReference);
                } else {
                    this.writeAttribute(fw, attrName, relationName, binding, isReference);
                }
                return;
            }
            if (simpleType == null && (simpleTypeObj = this.base.getSimpleType(primitiveType)) != null) {
                simpleType = simpleTypeObj.getSimpleType();
            }
        }
        if (simpleType != null) {
            List list = simpleType.getList();
            if (list != null) {
                SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(new QName("http://www.w3.org/2001/XMLSchema", "string"));
                this.writeAttribute(fw, attrName, relationName, binding, isReference);
            } else {
                Restriction restriction = simpleType.getRestriction();
                if (restriction == null) {
                    throw new RuntimeException("Cannot resolve type for Attribute " + attrName + " -> " + primitiveType.getLocalPart() + ", SimpleType restriction is unset");
                }
                QName base = restriction.getBase();
                SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(base);
                if (base.getNamespaceURI() != null) {
                    this.writeAttribute(fw, base.getNamespaceURI(), attrName, relationName, binding, isReference);
                } else {
                    this.writeAttribute(fw, attrName, relationName, binding, isReference);
                }
            }
        } else {
            fw.writer.println("    //FIXME: Cannot resolve type for Attribute " + attrName + " Using default type String");
            this.writeAttribute(fw, attrName, relationName, this.base.getTypeEntry("string"), isReference);
        }
    }

    private void writeAttribute(JavaGenerator.FileWriter fw, String attrName, String relationName, SchemaConversionBase.TypeEntry binding, boolean isReference) {
        fw.writer.println("      {");
        fw.writer.println("         if (attribute.getPredicate().equals(" + relationName + ")) {");
        fw.writer.println("            writer.writeAttribute(\"" + attrName + "\", " + binding.getToString("graph.getValue(attribute.getObject()," + binding.binding + ")") + ");");
        fw.writer.println("         }");
        fw.writer.println("      }");
    }

    private void writeAttribute(JavaGenerator.FileWriter fw, String ns, String attrName, String relationName, SchemaConversionBase.TypeEntry binding, boolean isReference) {
        fw.writer.println("      {");
        fw.writer.println("         if (attribute.getPredicate().equals(" + relationName + ")) {");
        fw.writer.println("            writer.writeAttribute(\"" + ns + "\",\"" + attrName + "\", " + binding.getToString("graph.getValue(attribute.getObject()," + binding.binding + ")") + ");");
        fw.writer.println("         }");
        fw.writer.println("      }");
    }

    @Override
    public void handleAttributes(SchemaObject simpleTypeObj) {
        SchemaObject parent = simpleTypeObj.getParent();
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        SimpleType simpleType = simpleTypeObj.getSimpleType();
        Restriction restriction = simpleType.getRestriction();
        if (restriction == null) {
            throw new RuntimeException("Cannot resolve type for Element " + this.getName(parent));
        }
        QName base = restriction.getBase();
        SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(base);
        fw.writer.println("   @Override");
        fw.writer.println("   public void characters(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException, DatabaseException {");
        fw.writer.println("            writer.writeCharacters(" + binding.getToString("graph.getValue(attribute.getObject()," + binding.binding + ")") + ");");
        fw.writer.println("   }");
    }

    @Override
    public void handle(SchemaObject parent, AttributeGroup attribute) {
        if (parent != null) {
            JavaGenerator.FileWriter fw = this.getWriter(parent);
            NamedAttributeGroup group = this.base.getAttributeGroup(attribute.getRef());
            fw.writer.println(String.valueOf(this.commentTag) + "    AttributeGroup " + group.getName());
            SchemaConversionBase b = this.getSchemaConversionBase(attribute);
            SchemaObject obj = new SchemaObject(b, parent, attribute);
            for (Annotated annotated : group.getAttributeOrAttributeGroup()) {
                if (annotated instanceof org.w3._2001.xmlschema.Attribute) {
                    this.handle(obj, (org.w3._2001.xmlschema.Attribute)annotated);
                    continue;
                }
                if (!(annotated instanceof AttributeGroup)) continue;
                this.handle(obj, (AttributeGroup)annotated);
            }
            fw.writer.println(String.valueOf(this.commentTag) + "    End of AttributeGroup " + group.getName());
        }
    }

    @Override
    public void handleAttributeComposition(SchemaObject parent, AttributeComposition composition, BijectionMap<Attribute, Annotated> attributes) {
        String relationName;
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        QName type = new QName("http://www.simantics.org/Layer0", composition.getType());
        SchemaConversionBase.TypeEntry typeEntry = this.base.getTypeEntry(type);
        String arrayBinding = typeEntry.binding;
        String javaType = typeEntry.javaType;
        String name = composition.getName();
        String prefix = this.getRefPrefix(parent);
        if (name != null) {
            relationName = String.valueOf(prefix) + "has" + name;
            if (parent != null) {
                relationName = String.valueOf(prefix) + this.getName(parent) + "_has" + name;
            }
        } else {
            throw new RuntimeException();
        }
        fw.writer.println("      if (attribute.getPredicate().equals(" + relationName + ")) {");
        fw.writer.println("            " + javaType + " value = (" + javaType + ")graph.getValue(attribute.getObject()," + arrayBinding + ");");
        int i = 0;
        for (Attribute a : composition.getAttribute()) {
            fw.writer.println("            writer.writeAttribute(\"" + a.getName() + "\"," + typeEntry.getElementToString("value[" + i++ + "]") + ");");
        }
        i = 0;
        fw.writer.println("      }");
    }

    protected String getDefaultValue(QName atype) {
        Map<String, SchemaConversionBase.TypeEntry> types = this.base.typeMap.get(atype.getNamespaceURI());
        if (types == null) {
            return null;
        }
        SchemaConversionBase.TypeEntry entry = types.get(atype.getLocalPart());
        if (entry == null) {
            return null;
        }
        return entry.defaultValue;
    }

    @Override
    public void handleElement(SchemaObject elementObj) {
        String name;
        Element element = elementObj.getElement();
        if (elementObj.getSc() != this.base) {
            return;
        }
        String className = name = this.getName(elementObj);
        JavaGenerator.FileWriter fw = new JavaGenerator.FileWriter();
        try {
            fw.writer = this.createFile(new File(String.valueOf(this.importParserDir.getAbsolutePath()) + "/" + className + ".java"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writers.put(elementObj, fw);
        boolean isList = false;
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(elementObj);
        this.provider = this.base.getIDProvider(element);
        java.util.List<IDReference> references = this.base.getIDReferences(element);
        UnrecognizedChildElement unknownChildElement = this.base.getUnknown(element);
        this.createClassHeader(fw.writer);
        this.writeClass(fw.writer, false, element.getName(), className, inheritance.baseClass, Collections.EMPTY_LIST);
        fw.writer.println("   @Override");
        fw.writer.println("   public Resource getType(ReadGraph graph) throws DatabaseException {");
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      return " + this.ontShort + name + ";");
        fw.writer.println("   }");
        fw.writer.println();
        LocalComplexType complexType = element.getComplexType();
        LocalSimpleType simpleType = element.getSimpleType();
        fw.writer.println("   @Override");
        fw.writer.println("   public void attributes(ReadGraph graph, WriterElement instance, Collection<Statement> attributes, XMLStreamWriter writer) throws XMLStreamException, DatabaseException{");
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("   \t   super.attributes(graph,instance,attributes,writer);");
        }
        this.writeOntologyImports(fw);
        fw.writer.println("        for (Statement attribute : attributes) {");
        if (complexType != null) {
            SchemaObject obj = this.base.getComplexType(complexType);
            this.base.handleElementComplexTypeAttributes(obj);
        }
        fw.writer.println("        }");
        fw.writer.println("   }");
        if (inheritance.type == SchemaConversionBase.InheritanceType.AtomicType) {
            fw.writer.println();
            fw.writer.println("   @Override");
            fw.writer.println("   public void characters(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException, DatabaseException {");
            fw.writer.println("            writer.writeCharacters(" + inheritance.atomicType.getToString("graph.getValue(instance.getResource()," + inheritance.atomicType.binding + ")") + ");");
            fw.writer.println("   }");
        }
        StringWriter stringWriter = new StringWriter();
        fw.delayedWriter = new PrintWriter(stringWriter);
        StringWriter stringWriter2 = new StringWriter();
        fw.delayedWriter2 = new PrintWriter(stringWriter2);
        fw.writer.println("   public " + className + "(ReadGraph graph) {");
        fw.writer.println("      super(graph);");
        this.writeOntologyImports(fw);
        if (complexType != null) {
            SchemaObject obj = this.base.getComplexType(complexType);
            this.base.handleComplexTypeExtension(obj);
        }
        fw.writer.println("   }");
        fw.writer.println("   @Override");
        fw.writer.println("   public void children(ReadGraph graph, WriterElement instance, java.util.Set<org.simantics.db.Resource> result) throws XMLStreamException, DatabaseException {");
        fw.writer.println("      " + this.getOntologyImport());
        if (stringWriter.getBuffer().length() > 0) {
            fw.writer.write(stringWriter.toString());
        }
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      super.children(graph,instance,result);");
        }
        fw.writer.println("   }");
        fw.writer.println();
        if (stringWriter2.getBuffer().length() > 0) {
            fw.writer.write(stringWriter2.toString());
        }
        stringWriter = null;
        fw.delayedWriter.close();
        fw.delayedWriter = null;
        stringWriter2 = null;
        fw.delayedWriter2.close();
        fw.delayedWriter2 = null;
        fw.writer.println("}");
        fw.writer.println();
        fw.writer.flush();
        fw.writer.close();
        fw.writer = null;
        this.writers.remove(elementObj);
        this.provider = null;
        this.ruleClassNames.add(String.valueOf(this.converter.getPluginName()) + "." + this.elementPackageName + "." + name);
    }

    protected void createClassHeader(PrintWriter writer) {
        writer.println("package " + this.converter.getPluginName() + "." + this.elementPackageName + ";");
        writer.println();
        writer.println("import org.simantics.databoard.Bindings;");
        writer.println("import org.simantics.db.Resource;");
        writer.println("import org.simantics.db.ReadGraph;");
        writer.println("import org.simantics.db.Statement;");
        writer.println("import org.simantics.db.exception.DatabaseException;");
        writer.println("import org.simantics.xml.sax.base.WriterElement;");
        writer.println("import org.simantics.xml.sax.ontology.XMLResource;");
        writer.println("import java.util.Collection;");
        writer.println("import javax.xml.stream.XMLStreamException;");
        writer.println("import javax.xml.stream.XMLStreamWriter;");
        writer.println();
    }
}

