/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.simantics.xml.data.DataSchemaConverter;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.Attribute;
import org.w3._2001.xmlschema.ComplexType;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.ExplicitGroup;
import org.w3._2001.xmlschema.Import;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalElement;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.Restriction;
import org.w3._2001.xmlschema.Schema;
import org.w3._2001.xmlschema.SimpleType;
import org.w3._2001.xmlschema.TopLevelAttribute;
import org.w3._2001.xmlschema.TopLevelElement;

public class XmlDataConverter {
    File outputPlugin;
    File conversionFile;
    List<File> inputFiles;
    String pluginName;
    private boolean useElementNSforAttributes = true;
    private boolean ignoreAttributeNS = false;
    private String ignorePattern = "(\\w)*";
    private boolean nonStandardBooleans = false;
    private String[] header;
    Map<String, Schema> schemaMap = new LinkedHashMap<String, Schema>();
    Map<Schema, Map<String, Element>> elementMap = new HashMap<Schema, Map<String, Element>>();
    Map<Element, String> elementNsMap = new HashMap<Element, String>();
    Map<Schema, Map<String, Attribute>> attributeMap = new HashMap<Schema, Map<String, Attribute>>();
    String defaultNS;

    public XmlDataConverter(List<File> inputFiles, File conversionFile, File outputPlugin) {
        if (inputFiles.size() == 0) {
            throw new IllegalArgumentException("At least one input file must be given.");
        }
        this.outputPlugin = outputPlugin;
        this.conversionFile = conversionFile;
        this.inputFiles = inputFiles;
        this.pluginName = outputPlugin.getName();
    }

    public void convert() throws IOException, XMLStreamException, JAXBException {
        this.init();
        this.doConvert();
        HashMap<Schema, File> fileMap = new HashMap<Schema, File>();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(XmlDataConverter.class.getClassLoader());
            JAXBContext jc = JAXBContext.newInstance((String)"org.w3._2001.xmlschema");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            HashSet<String> filenames = new HashSet<String>();
            for (Schema s : this.schemaMap.values()) {
                int i;
                String name = s.getTargetNamespace();
                if (name.startsWith("clr-namespace:") && (i = (name = name.substring("clr-namespace:".length())).indexOf(";assembly")) > 0) {
                    name = name.substring(0, i);
                }
                name = name.replaceAll("\\.", "_");
                name = name.replaceAll("/", "_");
                name = name.replaceAll(":", "_");
                if (filenames.contains(name = name.replaceAll(";", "_"))) {
                    i = 2;
                    while (filenames.contains(String.valueOf(name) + i)) {
                        ++i;
                    }
                    name = String.valueOf(name) + i;
                }
                filenames.add(name);
                File file = new File(String.valueOf(this.outputPlugin.getAbsolutePath()) + File.separator + name + ".xsd");
                fileMap.put(s, file);
            }
            for (Schema s : this.schemaMap.values()) {
                for (OpenAttrs openAttrs : s.getIncludeOrImportOrRedefine()) {
                    if (!(openAttrs instanceof Import)) continue;
                    Import import1 = (Import)openAttrs;
                    Schema dep = this.schemaMap.get(import1.getNamespace());
                    import1.setSchemaLocation(((File)fileMap.get(dep)).getName());
                }
            }
            for (Schema s : this.schemaMap.values()) {
                File file = (File)fileMap.get(s);
                m.marshal((Object)s, file);
            }
            Schema rootSchema = this.schemaMap.values().iterator().next();
            DataSchemaConverter schemaConverter = new DataSchemaConverter(rootSchema, (File)fileMap.get(rootSchema), this.conversionFile, this.outputPlugin);
            schemaConverter.setFileMap(fileMap);
            schemaConverter.setSchemaMap(this.schemaMap);
            schemaConverter.convert();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        this.header = null;
        this.schemaMap = null;
        this.elementMap = null;
    }

    protected void init() throws IOException {
        this.header = new String[4];
        this.header[0] = "Generated with org.simantics.xml.sax XML data file converter";
        this.header[1] = "";
        this.header[2] = "File " + this.inputFiles.get(0).getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), "/") + " , total file count: " + this.inputFiles.size();
        this.header[3] = "Date " + new Date().toString();
        this.schemaMap = new HashMap<String, Schema>();
        this.elementMap = new HashMap<Schema, Map<String, Element>>();
        this.attributeMap = new HashMap<Schema, Map<String, Attribute>>();
        this.elementNsMap = new HashMap<Element, String>();
    }

    protected void doConvert() throws IOException, XMLStreamException, JAXBException {
        XMLInputFactory input = XMLInputFactory.newInstance();
        for (File inputFile : this.inputFiles) {
            XMLEventReader reader = input.createXMLEventReader(new FileInputStream(inputFile));
            this.convertFile(reader);
        }
    }

    private void convertFile(XMLEventReader reader) throws XMLStreamException {
        ArrayDeque<Element> elementStack = new ArrayDeque<Element>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                Attribute localAttribute;
                ComplexType complexType;
                StartElement parseElement = event.asStartElement();
                Element schemaElement = null;
                String currentNS = parseElement.getName().getNamespaceURI();
                Schema s = this.schemaMap.get(currentNS);
                String elementName = parseElement.getName().getLocalPart();
                if (s == null) {
                    s = this.getOrCreateSchema(parseElement);
                } else {
                    schemaElement = this.elementMap.get(s).get(elementName);
                }
                Element parentElement = (Element)elementStack.peek();
                boolean newElement = false;
                boolean sameNameSpace = true;
                if (parentElement != null) {
                    String parentNs = this.elementNsMap.get(parentElement);
                    sameNameSpace = currentNS.equals(parentNs);
                    if (!sameNameSpace) {
                        Schema ps = this.getOrCreateSchema(parentNs);
                        this.addSchemaDependency(ps, s);
                    }
                } else {
                    this.defaultNS = currentNS;
                }
                if (schemaElement == null) {
                    if (elementStack.isEmpty()) {
                        schemaElement = new TopLevelElement();
                        s.getSimpleTypeOrComplexTypeOrGroup().add(schemaElement);
                    } else {
                        schemaElement = new TopLevelElement();
                        s.getSimpleTypeOrComplexTypeOrGroup().add(schemaElement);
                    }
                    schemaElement.setName(elementName);
                    this.elementNsMap.put(schemaElement, currentNS);
                    this.elementMap.get(s).put(elementName, schemaElement);
                    newElement = true;
                }
                if (parentElement != null) {
                    ComplexType complexType2 = this.getOrCreateComplexType(parentElement);
                    ExplicitGroup choice = complexType2.getChoice();
                    if (choice == null) {
                        choice = new ExplicitGroup();
                        complexType2.setChoice(choice);
                        choice.setMaxOccurs("unbounded");
                    }
                    LocalElement localElement = new LocalElement();
                    localElement.setRef(new QName(parseElement.getName().getNamespaceURI(), elementName));
                    this.addElement(choice, new QName("http://www.w3.org/2001/XMLSchema", "element"), localElement);
                }
                elementStack.push(schemaElement);
                Iterator<javax.xml.stream.events.Attribute> attributeIterator = parseElement.getAttributes();
                if (newElement) {
                    attributeIterator = parseElement.getAttributes();
                    if (!attributeIterator.hasNext()) continue;
                    complexType = this.getOrCreateComplexType(schemaElement);
                    while (attributeIterator.hasNext()) {
                        javax.xml.stream.events.Attribute attribute = attributeIterator.next();
                        if ("http://www.w3.org/XML/1998/namespace".equals(attribute.getName().getNamespaceURI())) continue;
                        this.addAttribute(attribute, complexType, currentNS);
                    }
                    continue;
                }
                complexType = schemaElement.getComplexType();
                attributeIterator = parseElement.getAttributes();
                if (complexType == null && !attributeIterator.hasNext()) continue;
                complexType = this.getOrCreateComplexType(schemaElement);
                HashMap<String, Attribute> currentAttributes = new HashMap<String, Attribute>();
                for (Annotated annotated : complexType.getAttributeOrAttributeGroup()) {
                    if (!(annotated instanceof Attribute)) continue;
                    localAttribute = (Attribute)annotated;
                    String n = localAttribute.getName();
                    if (n != null) {
                        currentAttributes.put(n, localAttribute);
                        continue;
                    }
                    if (localAttribute.getRef() == null) continue;
                    currentAttributes.put(localAttribute.getRef().getLocalPart(), localAttribute);
                }
                while (attributeIterator.hasNext()) {
                    javax.xml.stream.events.Attribute attribute = attributeIterator.next();
                    if ("http://www.w3.org/XML/1998/namespace".equals(attribute.getName().getNamespaceURI())) continue;
                    localAttribute = (Attribute)currentAttributes.get(attribute.getName().getLocalPart());
                    if (localAttribute == null) {
                        this.addAttribute(attribute, complexType, currentNS);
                        continue;
                    }
                    QName newType = this.getType(attribute.getValue());
                    Attribute schemaAttribute = this.updateAttributeType(localAttribute, newType);
                    String attrNs = this.getNS(attribute, currentNS);
                    if (this.ignoreAttributeNs(attribute) || attribute.getName().getNamespaceURI().length() <= 0) continue;
                    if (localAttribute.getRef() != null) {
                        if (localAttribute.getRef().getNamespaceURI().equals(attrNs)) continue;
                        throw new RuntimeException("Conflicting namespaces for attribute " + attribute.getName().getLocalPart() + " " + attrNs + " " + localAttribute.getRef().getNamespaceURI());
                    }
                    if (attrNs.equals(currentNS)) continue;
                    complexType.getAttributeOrAttributeGroup().remove(localAttribute);
                    Attribute scAttribute = this.addAttribute(attribute, complexType, currentNS);
                    scAttribute.setType(schemaAttribute.getType());
                }
                continue;
            }
            if (event.isEndElement()) {
                EndElement element = event.asEndElement();
                elementStack.pop();
                continue;
            }
            if (event.isAttribute() || event.isStartDocument() || event.isEndDocument() || event.isEntityReference()) continue;
            if (event.isCharacters()) {
                String text;
                Characters characters = event.asCharacters();
                Element element = (Element)elementStack.peek();
                if (element == null || (text = characters.getData().trim()).length() <= 0) continue;
                this.setElementCharactersData(element, text, characters);
                continue;
            }
            event.isNamespace();
        }
    }

    private void setElementCharactersData(Element element, String text, Characters characters) {
        if (element.getComplexType() != null) {
            element.getComplexType().setMixed(true);
        } else {
            SimpleType simpleType = this.getOrCreateSimpleType(element);
            QName type = this.getType(text);
            Restriction restriction = simpleType.getRestriction();
            if (restriction == null) {
                restriction = new Restriction();
                restriction.setBase(type);
                simpleType.setRestriction(restriction);
            } else {
                restriction.setBase(this.mergePrimitiveType(restriction.getBase(), type));
            }
        }
    }

    private ComplexType getOrCreateComplexType(Element element) {
        LocalComplexType complexType = element.getComplexType();
        if (complexType == null) {
            complexType = new LocalComplexType();
            element.setComplexType(complexType);
            if (element.getSimpleType() != null) {
                element.setSimpleType(null);
                complexType.setMixed(true);
            }
        }
        return complexType;
    }

    private SimpleType getOrCreateSimpleType(Element element) {
        LocalSimpleType simpleType = element.getSimpleType();
        if (simpleType == null) {
            simpleType = new LocalSimpleType();
            element.setSimpleType(simpleType);
        }
        return simpleType;
    }

    private void addElement(ExplicitGroup choice, QName type, LocalElement localElement) {
        for (Object o : choice.getParticle()) {
            JAXBElement el = (JAXBElement)o;
            if (!el.getName().equals(type)) continue;
            QName ref = ((LocalElement)el.getValue()).getRef();
            QName ref2 = localElement.getRef();
            if (!(ref != null ? ref.equals(ref2) : ((LocalElement)el.getValue()).getType().equals(localElement.getType()))) continue;
            return;
        }
        choice.getParticle().add(new JAXBElement(type, LocalElement.class, null, (Object)localElement));
    }

    private void addSchemaDependency(Schema parentSchema, Schema schema) {
        for (OpenAttrs openAttrs : parentSchema.getIncludeOrImportOrRedefine()) {
            Import import1;
            if (!(openAttrs instanceof Import) || !(import1 = (Import)openAttrs).getNamespace().equals(schema.getTargetNamespace())) continue;
            return;
        }
        Import import1 = new Import();
        import1.setNamespace(schema.getTargetNamespace());
        parentSchema.getIncludeOrImportOrRedefine().add(import1);
    }

    private String getNS(javax.xml.stream.events.Attribute attribute, String currentNS) {
        if (this.ignoreAttributeNs(attribute)) {
            return currentNS;
        }
        String attrNs = attribute.getName().getNamespaceURI();
        if (attrNs.length() == 0) {
            attrNs = this.useElementNSforAttributes ? currentNS : this.defaultNS;
        }
        return attrNs;
    }

    private boolean ignoreAttributeNs(javax.xml.stream.events.Attribute attribute) {
        if (this.ignoreAttributeNS) {
            return true;
        }
        if (this.ignorePattern != null) {
            return attribute.getName().getLocalPart().matches(this.ignorePattern);
        }
        return false;
    }

    private Attribute addAttribute(javax.xml.stream.events.Attribute attribute, ComplexType complexType, String currentNS) {
        String attrNs = this.getNS(attribute, currentNS);
        String attrName = attribute.getName().getLocalPart();
        if (attrNs.equals(currentNS)) {
            Attribute schemaAttribute = new Attribute();
            schemaAttribute.setName(attrName);
            schemaAttribute.setType(this.getType(attribute.getValue()));
            this.addAttribute(complexType, schemaAttribute);
            return schemaAttribute;
        }
        Schema schema = this.getOrCreateSchema(currentNS);
        Schema attrSchema = this.getOrCreateSchema(attrNs);
        Attribute schemaAttribute = this.attributeMap.get(attrSchema).get(attrName);
        if (schemaAttribute == null) {
            schemaAttribute = new TopLevelAttribute();
            schemaAttribute.setName(attrName);
            schemaAttribute.setType(this.getType(attribute.getValue()));
            attrSchema.getSimpleTypeOrComplexTypeOrGroup().add(schemaAttribute);
            this.attributeMap.get(attrSchema).put(attribute.getName().getLocalPart(), schemaAttribute);
        }
        this.addSchemaDependency(schema, attrSchema);
        Attribute localAttribute = new Attribute();
        localAttribute.setRef(new QName(attrNs, attrName));
        this.addAttribute(complexType, localAttribute);
        return schemaAttribute;
    }

    private void addAttribute(ComplexType complexType, Attribute schemaAttribute) {
        if (schemaAttribute.getName() != null) {
            for (Annotated annotated : complexType.getAttributeOrAttributeGroup()) {
                if (!(annotated instanceof Attribute)) continue;
                Attribute attr = (Attribute)annotated;
                if (!schemaAttribute.getName().equals(attr.getName())) continue;
                this.updateAttributeType(attr, schemaAttribute.getType());
                return;
            }
        } else {
            for (Annotated annotated : complexType.getAttributeOrAttributeGroup()) {
                Attribute attr;
                if (!(annotated instanceof Attribute) || (attr = (Attribute)annotated).getName() != null || !schemaAttribute.getRef().equals(attr.getRef())) continue;
                return;
            }
        }
        complexType.getAttributeOrAttributeGroup().add(schemaAttribute);
    }

    private QName getType(String value) {
        if (!this.nonStandardBooleans ? "true".equals(value) || "false".equals(value) : "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return new QName("http://www.w3.org/2001/XMLSchema", "boolean");
        }
        try {
            Integer.parseInt(value);
            return new QName("http://www.w3.org/2001/XMLSchema", "integer");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(value);
                return new QName("http://www.w3.org/2001/XMLSchema", "double");
            }
            catch (NumberFormatException numberFormatException2) {
                return new QName("http://www.w3.org/2001/XMLSchema", "string");
            }
        }
    }

    private String findLocalPartHelper(Attribute schemaAttribute) {
        return schemaAttribute.getRef().getLocalPart();
    }

    private String findURIHelper(Attribute schemaAttribute) {
        return schemaAttribute.getRef().getNamespaceURI();
    }

    private Attribute updateAttributeType(Attribute schemaAttribute, QName newType) {
        QName currentType = schemaAttribute.getType();
        if (currentType == null && schemaAttribute.getRef() != null) {
            Schema schema = this.schemaMap.get(this.findURIHelper(schemaAttribute));
            schemaAttribute = this.attributeMap.get(schema).get(this.findLocalPartHelper(schemaAttribute));
            currentType = schemaAttribute.getType();
        }
        if (currentType == null) {
            throw new RuntimeException("Could not resolve attribute");
        }
        schemaAttribute.setType(this.mergePrimitiveType(currentType, newType));
        return schemaAttribute;
    }

    private QName mergePrimitiveType(QName currentType, QName newType) {
        if (!newType.getLocalPart().equals(currentType.getLocalPart())) {
            if (currentType.getLocalPart().equals("integer") && newType.getLocalPart().equals("double")) {
                return newType;
            }
            if (currentType.getLocalPart().equals("double") && newType.getLocalPart().equals("integer")) {
                return currentType;
            }
            if (currentType.getLocalPart().equals("boolean") && newType.getLocalPart().equals("integer")) {
                return newType;
            }
            if (currentType.getLocalPart().equals("integer") && newType.getLocalPart().equals("boolean")) {
                return currentType;
            }
            if (!currentType.getLocalPart().equals("string")) {
                return new QName("http://www.w3.org/2001/XMLSchema", "string");
            }
        }
        return currentType;
    }

    private Schema getOrCreateSchema(StartElement parseElement) {
        return this.getOrCreateSchema(parseElement.getName().getNamespaceURI());
    }

    private Schema getOrCreateSchema(String ns) {
        if (ns == null) {
            throw new IllegalArgumentException("Schema NS cannot be null.");
        }
        Schema s = this.schemaMap.get(ns);
        if (s == null) {
            s = new Schema();
            s.setTargetNamespace(ns);
            this.schemaMap.put(ns, s);
            this.elementMap.put(s, new HashMap());
            this.attributeMap.put(s, new HashMap());
        }
        return s;
    }
}

