/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.xmlio;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.DelayedWrite;
import org.simantics.interop.xmlio.DefaultLoadRule;
import org.simantics.interop.xmlio.LoadRule;
import org.simantics.layer0.Layer0;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LoadXML {
    private Session session;
    private Resource resultRoot;
    private File file;
    Int2ObjectOpenHashMap<Resource> idMap = new Int2ObjectOpenHashMap();
    private WriteGraph graph;
    private Layer0 l0;
    private LoadRule rule;
    private int resources;
    private int statements;
    private static final boolean USE_DELAYED = true;

    public LoadXML(Session session, File file) {
        this.session = session;
        this.file = file;
        this.rule = new DefaultLoadRule();
    }

    public void setRule(LoadRule rule) {
        this.rule = rule;
    }

    public void load(Resource subj, Resource pred) throws Exception {
        this.resources = 0;
        this.statements = 0;
        this.session.syncRequest((DelayedWrite)new ImportDelayedRequest(subj, pred));
        System.out.println("Import done.");
    }

    private void doImport(WriteGraph graph, Resource subj, Resource pred) throws DatabaseException {
        this.graph = graph;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        try {
            try {
                XMLParser parser = new XMLParser();
                parser.parse(this.file.getAbsolutePath());
                System.out.println("Imported " + this.statements + " Statements, " + this.resources + " Resources.");
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        finally {
            this.resultRoot = (Resource)this.idMap.get(0);
            graph.claim(subj, pred, this.resultRoot);
            this.idMap.clear();
        }
    }

    protected Resource getResource(ReadGraph graph, String uri) throws DatabaseException {
        return this.rule.getResource(graph, uri);
    }

    protected Object createValue(ReadGraph graph, List<String> value, List<String> types) throws DatabaseException {
        return this.rule.createValue(graph, value, types);
    }

    protected void initializeWithBundles(ReadGraph graph, List<Bundle> bundles) throws DatabaseException {
        this.rule.initializeWithBundles(graph, bundles);
    }

    public class Attribute {
        public String localName;
        public String qName;
        public String uri;
        public String value;

        public Attribute(String localName, String qName, String uri, String value) {
            this.localName = localName;
            this.qName = qName;
            this.uri = uri;
            this.value = value;
        }
    }

    public static class Bundle {
        String name;
        String versionId;

        public Bundle(String name, String versionId) {
            this.name = name;
            this.versionId = versionId;
        }

        public String getName() {
            return this.name;
        }

        public String getVersionId() {
            return this.versionId;
        }
    }

    public class Element
    implements Serializable {
        private static final long serialVersionUID = -5207502156942818875L;
        String uri;
        String localName;
        String qName;
        List<Attribute> attributes = new ArrayList<Attribute>();
        private Object data;

        public Element(String uri, String localName, String qName, Attributes attributes) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            int i = 0;
            while (i < attributes.getLength()) {
                this.attributes.add(new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i)));
                ++i;
            }
        }

        public String getUri() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getQName() {
            return this.qName;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }
    }

    private class ImportDelayedRequest
    extends DelayedWriteRequest {
        Resource subj;
        Resource pred;

        public ImportDelayedRequest(Resource subj, Resource pred) {
            this.subj = subj;
            this.pred = pred;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            LoadXML.this.doImport(graph, this.subj, this.pred);
        }
    }

    private class ImportRequest
    extends WriteRequest {
        Resource subj;
        Resource pred;

        public ImportRequest(Resource subj, Resource pred) {
            this.subj = subj;
            this.pred = pred;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            LoadXML.this.doImport(graph, this.subj, this.pred);
        }
    }

    class Res {
        List<String> types = new ArrayList<String>();
        List<String> values = new ArrayList<String>();

        Res() {
        }
    }

    public class XMLParser
    extends DefaultHandler
    implements Serializable {
        private static final long serialVersionUID = -4995836637014958966L;
        private Stack<Element> current = new Stack();

        private void loadElement(Element element) throws SAXException {
            String name = element.qName;
            if ("graphexport".equals(name)) {
                return;
            }
            if ("graphbundles".equals(name)) {
                element.setData(new ArrayList());
                return;
            }
            if ("bundle".equals(name)) {
                return;
            }
            if ("resource".equals(name)) {
                element.setData(new Res());
                return;
            }
            if ("type".equals(name)) {
                return;
            }
            if ("statement".equals(name)) {
                return;
            }
        }

        private void handleElement(Stack<Element> parents, Element element) throws SAXException {
            try {
                String elementName = element.qName;
                if ("graphexport".equals(elementName)) {
                    return;
                }
                if ("graphbundles".equals(elementName)) {
                    List list = (List)element.getData();
                    LoadXML.this.initializeWithBundles((ReadGraph)LoadXML.this.graph, list);
                    element.setData(null);
                    return;
                }
                if ("bundle".equals(elementName)) {
                    List list = (List)parents.peek().getData();
                    String name = null;
                    String versionId = null;
                    for (Attribute a : element.getAttributes()) {
                        if ("name".equals(a.qName)) {
                            name = a.value;
                        }
                        if (!"versionid".equals(a.qName)) continue;
                        versionId = a.value;
                    }
                    list.add(new Bundle(name, versionId));
                    return;
                }
                if ("resource".equals(elementName)) {
                    Res res = (Res)element.getData();
                    boolean rel = false;
                    String uri = null;
                    int id = -1;
                    Resource r = null;
                    for (Attribute a : element.getAttributes()) {
                        if ("id".equals(a.qName)) {
                            id = Integer.parseInt(a.value);
                        }
                        if ("rel".equals(a.qName)) {
                            rel = "true".equals(a.value);
                        }
                        if (!"uri".equals(a.qName)) continue;
                        uri = a.value;
                    }
                    if (rel) {
                        r = LoadXML.this.getResource((ReadGraph)LoadXML.this.graph, uri);
                    } else {
                        r = LoadXML.this.graph.newResource();
                        for (String typeUri : res.types) {
                            Resource type = LoadXML.this.getResource((ReadGraph)LoadXML.this.graph, typeUri);
                            LoadXML.this.graph.claim(r, LoadXML.this.l0.InstanceOf, type);
                        }
                        if (res.values.size() > 0) {
                            Object valObj = LoadXML.this.createValue((ReadGraph)LoadXML.this.graph, res.values, res.types);
                            LoadXML.this.graph.claimValue(r, valObj);
                        }
                    }
                    if (id == -1) {
                        throw new SAXException("Resource id missing");
                    }
                    LoadXML.this.idMap.put(id, (Object)r);
                    res.types.clear();
                    res.values.clear();
                    element.setData(null);
                    ++LoadXML.this.resources;
                    return;
                }
                if ("type".equals(elementName)) {
                    Element parent = parents.peek();
                    Res res = (Res)parent.getData();
                    String uri = null;
                    for (Attribute a : element.getAttributes()) {
                        if (!"uri".equals(a.qName)) continue;
                        uri = a.value;
                    }
                    if (uri != null) {
                        res.types.add(uri);
                    }
                    return;
                }
                if ("value".equals(elementName)) {
                    Element parent = parents.peek();
                    Res res = (Res)parent.getData();
                    String value = null;
                    for (Attribute a : element.getAttributes()) {
                        if (!"value".equals(a.qName)) continue;
                        value = a.value;
                    }
                    if (value != null) {
                        res.values.add(value);
                    }
                    return;
                }
                if ("statement".equals(elementName)) {
                    int subjId = -1;
                    int predId = -1;
                    int objId = -1;
                    for (Attribute a : element.getAttributes()) {
                        if ("subject".equals(a.qName)) {
                            subjId = Integer.parseInt(a.value);
                        }
                        if ("predicate".equals(a.qName)) {
                            predId = Integer.parseInt(a.value);
                        }
                        if (!"object".equals(a.qName)) continue;
                        objId = Integer.parseInt(a.value);
                    }
                    LoadXML.this.graph.claim((Resource)LoadXML.this.idMap.get(subjId), (Resource)LoadXML.this.idMap.get(predId), (Resource)LoadXML.this.idMap.get(objId));
                    ++LoadXML.this.statements;
                    if (LoadXML.this.statements % 10000 == 0) {
                        System.out.println("Imported " + LoadXML.this.statements + " Statements, " + LoadXML.this.resources + " Resources..");
                    }
                    return;
                }
            }
            catch (DatabaseException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        public void done() {
        }

        public void parse(String filename) throws Exception {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            BufferedReader file = new BufferedReader(new FileReader(filename));
            reader.setContentHandler(this);
            reader.parse(new InputSource(file));
            this.done();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            Element e = new Element(uri, localName, name, attributes);
            this.current.push(e);
            this.loadElement(e);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            Element e = null;
            if (!this.current.empty()) {
                e = this.current.pop();
            }
            if (e != null) {
                this.handleElement(this.current, e);
            }
        }
    }
}

