/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.UpdateNode;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.interop.update.model.UpdateOperations;
import org.simantics.interop.update.model.UpdateStatus;

public class UpdateTree {
    private UpdateNode rootNode;
    private Map<Resource, UpdateNode> nodes;
    private GraphChanges changes;
    private UpdateOperations updateOps;

    public UpdateTree(ReadGraph g, GraphChanges changes, UpdateOperations updateOps) throws DatabaseException {
        this.changes = changes;
        this.nodes = new HashMap<Resource, UpdateNode>();
        this.rootNode = this.createNode(g, UpdateStatus.EXIST, changes.getResource1());
        this.nodes.put(changes.getResource1(), this.rootNode);
        this.nodes.put(changes.getResource2(), this.rootNode);
        this.updateOps = updateOps;
        this.updateOps.populate(g);
        this.populate(g);
        this.rootNode.sort();
    }

    public UpdateTree(Session session, GraphChanges changes, UpdateOperations updateOps) throws DatabaseException {
        this(session, changes, updateOps, (IProgressMonitor)new NullProgressMonitor());
    }

    public UpdateTree(Session session, GraphChanges changes, UpdateOperations updateOps, IProgressMonitor monitor) throws DatabaseException {
        this.changes = changes;
        this.nodes = new HashMap<Resource, UpdateNode>();
        this.rootNode = (UpdateNode)session.syncRequest((Read)new NodeRequest(UpdateStatus.EXIST, changes.getResource1()));
        this.nodes.put(changes.getResource1(), this.rootNode);
        this.nodes.put(changes.getResource2(), this.rootNode);
        this.updateOps = updateOps;
        this.updateOps.populate(session, monitor);
        this.populate(session, monitor);
        if (monitor.isCanceled()) {
            this.changes = null;
            this.nodes.clear();
            this.updateOps = null;
            this.rootNode = null;
        } else {
            this.rootNode.sort();
        }
    }

    public UpdateOperations getUpdateOps() {
        return this.updateOps;
    }

    public UpdateNode getRootNode() {
        return this.rootNode;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    protected UpdateNode createNode(ReadGraph g, UpdateStatus status, Resource r) throws DatabaseException {
        return new UpdateNode(g, status, r);
    }

    protected UpdateNode createNode(ReadGraph g, UpdateStatus status, UpdateOp op) throws DatabaseException {
        return new UpdateNode(g, status, op);
    }

    private UpdateNode createNode(ReadGraph g, Resource r1, Resource r2) throws DatabaseException {
        UpdateNode node = null;
        if (r1 != null && r2 != null) {
            UpdateOp op = this.updateOps.getUpdateOp(r1);
            if (op == null) {
                op = this.updateOps.getUpdateOp(r2);
            }
            node = op == null ? this.createNode(g, UpdateStatus.EXIST, r1) : this.createNode(g, UpdateStatus.EXIST, op);
            this.nodes.put(r1, node);
            this.nodes.put(r2, node);
        } else if (r1 != null) {
            node = this.createNode(g, UpdateStatus.DELETED, this.updateOps.getUpdateOp(r1));
            this.nodes.put(r1, node);
        } else if (r2 != null) {
            node = this.createNode(g, UpdateStatus.NEW, this.updateOps.getUpdateOp(r2));
            this.nodes.put(r2, node);
        }
        return node;
    }

    public UpdateNode addNode(ReadGraph g, Resource r1, Resource r2) throws DatabaseException {
        if (this.nodes.containsKey(r1)) {
            return this.nodes.get(r1);
        }
        if (this.nodes.containsKey(r2)) {
            return this.nodes.get(r2);
        }
        UpdateNode node = this.createNode(g, r1, r2);
        this.connectParent(g, node);
        return node;
    }

    public UpdateNode getNode(Resource r) {
        return this.nodes.get(r);
    }

    protected boolean connectParent(ReadGraph g, UpdateNode node) throws DatabaseException {
        Resource parentResource;
        UpdateNode parent = null;
        while ((parent = this.nodes.get(parentResource = node.getParentResource(g))) == null) {
            parent = this.getOrCreate(g, parentResource);
            if (parent == null) {
                return false;
            }
            parent.addChild(node);
            node = parent;
            parent = null;
        }
        parent.addChild(node);
        return true;
    }

    protected UpdateNode getOrCreate(ReadGraph g, Resource parentResource) throws DatabaseException {
        UpdateNode parent = this.nodes.get(parentResource);
        if (parent == null) {
            if (this.changes.getComparable().containsLeft((Object)parentResource)) {
                parent = this.createNode(g, parentResource, (Resource)this.changes.getComparable().getRight((Object)parentResource));
            } else if (this.changes.getComparable().containsRight((Object)parentResource)) {
                parent = this.createNode(g, (Resource)this.changes.getComparable().getLeft((Object)parentResource), parentResource);
            } else {
                return null;
            }
        }
        return parent;
    }

    protected boolean handleCustom(ReadGraph g, UpdateOp op) throws DatabaseException {
        return false;
    }

    protected void populate(ReadGraph g) throws DatabaseException {
        for (UpdateOp op : this.updateOps.getOperations()) {
            this.populate(g, op);
        }
    }

    protected void populate(ReadGraph g, UpdateOp op) throws DatabaseException {
        if (!this.handleCustom(g, op)) {
            if (op.isAdd()) {
                this.addNode(g, null, op.getResource());
            } else if (op.isDelete()) {
                this.addNode(g, op.getResource(), null);
            } else if (op.isChange()) {
                Resource o = op.getResource();
                Resource l = this.getChanges().getComparable().containsLeft((Object)o) ? o : (Resource)this.getChanges().getComparable().getLeft((Object)o);
                Resource r = this.getChanges().getComparable().containsRight((Object)o) ? o : (Resource)this.getChanges().getComparable().getRight((Object)o);
                this.addNode(g, l, r);
            }
        }
    }

    protected void populate(Session session, IProgressMonitor monitor) throws DatabaseException {
        int i = 0;
        while (i < this.updateOps.getOperations().size()) {
            if (monitor.isCanceled()) {
                return;
            }
            i = (Integer)session.syncRequest((Read)new PopulateRead(i));
        }
    }

    private class NodeRequest
    extends ResourceRead<UpdateNode> {
        UpdateStatus status;

        public NodeRequest(UpdateStatus status, Resource r) {
            super(r);
            this.status = status;
        }

        public UpdateNode perform(ReadGraph graph) throws DatabaseException {
            return UpdateTree.this.createNode(graph, this.status, this.resource);
        }
    }

    protected class PopulateRead
    implements Read<Integer> {
        int s;

        public PopulateRead(int s) {
            this.s = s;
        }

        public Integer perform(ReadGraph graph) throws DatabaseException {
            int l = this.s + 100;
            if (l > UpdateTree.this.updateOps.getOperations().size()) {
                l = UpdateTree.this.updateOps.getOperations().size();
            }
            int i = this.s;
            while (i < l) {
                UpdateOp op = UpdateTree.this.updateOps.getOperations().get(i);
                UpdateTree.this.populate(graph, op);
                ++i;
            }
            return l;
        }
    }
}

