/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.UpdateOp;

public abstract class UpdateOperations {
    private List<UpdateOp> operations = new ArrayList<UpdateOp>();
    private Map<Resource, UpdateOp> resourceMap = new HashMap<Resource, UpdateOp>();
    private Map<Statement, UpdateOp> statementMap = new HashMap<Statement, UpdateOp>();
    private GraphChanges changes;
    private int chunkSize = -1;

    public UpdateOperations(GraphChanges changes) {
        this.changes = changes;
    }

    public UpdateOp getUpdateOp(Resource r) {
        return this.resourceMap.get(r);
    }

    public UpdateOp getUpdateOp(Statement s) {
        return this.statementMap.get(s);
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void applyAll(WriteGraph graph) throws DatabaseException {
        List<UpdateOp> list = this.operations;
        this.apply(graph, list);
    }

    public void applySelected(WriteGraph graph) throws DatabaseException {
        ArrayList<UpdateOp> list = new ArrayList<UpdateOp>();
        for (UpdateOp op : this.operations) {
            if (!op.selected()) continue;
            list.add(op);
        }
        this.apply(graph, list);
    }

    public void applyAll(Session session, VirtualGraph vg) throws DatabaseException {
        List<UpdateOp> list = this.operations;
        this.apply(session, list, vg);
    }

    public void applySelected(Session session, VirtualGraph vg) throws DatabaseException {
        ArrayList<UpdateOp> list = new ArrayList<UpdateOp>();
        for (UpdateOp op : this.operations) {
            if (!op.selected()) continue;
            list.add(op);
        }
        this.apply(session, list, vg);
    }

    protected void apply(WriteGraph graph, List<UpdateOp> list) throws DatabaseException {
        for (UpdateOp op : list) {
            this.apply(graph, op);
        }
    }

    protected void apply(Session session, final List<UpdateOp> list, VirtualGraph vg) throws DatabaseException {
        if (this.getChunkSize() > 0) {
            int s = 0;
            while (s < list.size()) {
                int e = s + this.getChunkSize();
                if (e > list.size()) {
                    e = list.size();
                }
                final List<UpdateOp> subList = list.subList(s, e);
                session.syncRequest((Write)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        for (UpdateOp op : subList) {
                            UpdateOperations.this.apply(graph, op);
                        }
                    }
                });
                s = e;
            }
        } else {
            session.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    for (UpdateOp op : list) {
                        UpdateOperations.this.apply(graph, op);
                    }
                }
            });
        }
    }

    public List<UpdateOp> getOperations() {
        return this.operations;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public Map<Resource, UpdateOp> getResourceMap() {
        return this.resourceMap;
    }

    public Map<Statement, UpdateOp> getStatementMap() {
        return this.statementMap;
    }

    private void apply(WriteGraph g, UpdateOp op) throws DatabaseException {
        Stack<UpdateOp> stack = new Stack<UpdateOp>();
        this._apply(g, stack, op);
    }

    private void _apply(WriteGraph g, Stack<UpdateOp> stack, UpdateOp op) throws DatabaseException {
        if (op.applied()) {
            return;
        }
        if (stack.contains(op)) {
            op.apply(g);
            return;
        }
        stack.push(op);
        for (UpdateOp pop : op.getParentOps()) {
            if (!op.requiresOp(pop) || pop.applied()) continue;
            this._apply(g, stack, pop);
        }
        for (UpdateOp sop : op.getSubOps()) {
            if (!op.requiresOp(sop) || sop.applied()) continue;
            this._apply(g, stack, sop);
        }
        stack.pop();
        op.apply(g);
    }

    protected List<UpdateOp> getOps() {
        ArrayList<UpdateOp> list = new ArrayList<UpdateOp>(this.operations.size());
        list.addAll(this.operations);
        return list;
    }

    protected void addOp(Resource r, UpdateOp op) {
        this.resourceMap.put(r, op);
        this.operations.add(op);
    }

    protected void addOp(Statement s, UpdateOp op) {
        this.statementMap.put(s, op);
        this.operations.add(op);
    }

    protected void replaceOp(Resource r, UpdateOp op) {
        UpdateOp oldOp = this.resourceMap.remove(r);
        if (oldOp != null) {
            this.operations.remove(oldOp);
        }
        this.resourceMap.put(r, op);
        this.operations.add(op);
    }

    protected UpdateOp getOP(Resource r) {
        return this.resourceMap.get(r);
    }

    protected UpdateOp getOP(Statement r) {
        return this.statementMap.get(r);
    }

    public abstract void populate(ReadGraph var1) throws DatabaseException;

    public void populate(Session session, IProgressMonitor monitor) throws DatabaseException {
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                UpdateOperations.this.populate(graph);
            }
        });
    }

    protected boolean compares(Resource r1, Resource r2) {
        if (r1.equals(r2)) {
            return true;
        }
        return this.changes.getComparable().contains((Object)r1, (Object)r2);
    }
}

