/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.ModelUpdate;
import org.simantics.interop.update.model.UpdateNode;
import org.simantics.interop.update.model.UpdateTree;

public class UpdateNode3 {
    UpdateNode un1;
    UpdateNode un2;
    UpdateNode un3;
    private Collection<UpdateNode3> children = new ArrayList<UpdateNode3>();

    public Collection<UpdateNode3> getChildren() {
        return this.children;
    }

    public UpdateNode getUn1() {
        return this.un1;
    }

    public UpdateNode getUn2() {
        return this.un2;
    }

    public UpdateNode getUn3() {
        return this.un3;
    }

    public UpdateNode3(UpdateNode un1, UpdateNode un2, UpdateNode un3) {
        this.un1 = un1;
        this.un2 = un2;
        this.un3 = un3;
    }

    public boolean isVisible() {
        if (this.un1 != null) {
            return this.un1.isVisible();
        }
        if (this.un2 != null) {
            return this.un2.isVisible();
        }
        if (this.un3 != null) {
            return this.un3.isVisible();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (this.un1 != null) {
            this.un1.setVisible(visible);
        }
        if (this.un2 != null) {
            this.un2.setVisible(visible);
        }
        if (this.un3 != null) {
            this.un3.setVisible(visible);
        }
    }

    public static UpdateNode3 getCombinedTree(ModelUpdate update) throws DatabaseException {
        UpdateTree updateTree1 = update.getUpdateTree();
        UpdateTree updateTree2 = update.getUpdateTree2();
        UpdateTree updateTree3 = update.getUpdateTree3();
        UpdateNode3 n3 = new UpdateNode3(updateTree1.getRootNode(), updateTree2.getRootNode(), updateTree3.getRootNode());
        UpdateNode3.populate(n3, update.getChanges(), update.getChanges2(), update.getChanges3());
        return n3;
    }

    private static void getComparable(UpdateNode n, GraphChanges gc1, GraphChanges gc2, GraphChanges gc3, Set<Resource> nodeR) {
        nodeR.clear();
        Resource r = n.getResource();
        nodeR.add(r);
        UpdateNode3.addNotNull(nodeR, (Resource)gc1.getComparable().getLeft((Object)r));
        UpdateNode3.addNotNull(nodeR, (Resource)gc1.getComparable().getRight((Object)r));
        UpdateNode3.addNotNull(nodeR, (Resource)gc2.getComparable().getLeft((Object)r));
        UpdateNode3.addNotNull(nodeR, (Resource)gc2.getComparable().getRight((Object)r));
        UpdateNode3.addNotNull(nodeR, (Resource)gc3.getComparable().getLeft((Object)r));
        UpdateNode3.addNotNull(nodeR, (Resource)gc3.getComparable().getRight((Object)r));
    }

    public static <T> void addNotNull(Set<T> set, T t) {
        if (t != null) {
            set.add(t);
        }
    }

    private static void populate(UpdateNode3 un, GraphChanges gc1, GraphChanges gc2, GraphChanges gc3) {
        HashSet<UpdateNode> p1 = new HashSet<UpdateNode>();
        HashSet<UpdateNode> p2 = new HashSet<UpdateNode>();
        HashSet<UpdateNode> p3 = new HashSet<UpdateNode>();
        HashSet<Resource> nodeR = new HashSet<Resource>();
        if (un.getUn1() != null) {
            for (UpdateNode n1 : un.getUn1().getChildren()) {
                UpdateNode3.getComparable(n1, gc1, gc2, gc3, nodeR);
                p1.add(n1);
                UpdateNode n2 = null;
                if (un.getUn2() != null) {
                    n2 = UpdateNode3.getMatching(n1, un.getUn2().getChildren(), nodeR);
                }
                UpdateNode n3 = null;
                if (un.getUn3() != null) {
                    n3 = UpdateNode3.getMatching(n1, un.getUn3().getChildren(), nodeR);
                }
                UpdateNode3 cn = new UpdateNode3(n1, n2, n3);
                un.children.add(cn);
                UpdateNode3.populate(cn, gc1, gc2, gc3);
                if (n2 != null) {
                    p2.add(n2);
                }
                if (n3 == null) continue;
                p3.add(n3);
            }
        }
        if (un.getUn2() != null) {
            for (UpdateNode n2 : un.getUn2().getChildren()) {
                if (p2.contains(n2)) continue;
                p2.add(n2);
                UpdateNode3.getComparable(n2, gc1, gc2, gc3, nodeR);
                UpdateNode n3 = null;
                if (un.getUn3() != null) {
                    n3 = UpdateNode3.getMatching(n2, un.getUn3().getChildren(), nodeR);
                }
                UpdateNode3 cn = new UpdateNode3(null, n2, n3);
                un.children.add(cn);
                UpdateNode3.populate(cn, gc1, gc2, gc3);
                if (n3 == null) continue;
                p3.add(n3);
            }
        }
        if (un.getUn3() != null) {
            for (UpdateNode n3 : un.getUn3().getChildren()) {
                if (p3.contains(n3)) continue;
                p3.add(n3);
                UpdateNode3 cn = new UpdateNode3(null, null, n3);
                un.children.add(cn);
                UpdateNode3.populate(cn, gc1, gc2, gc3);
            }
        }
    }

    private static UpdateNode getMatching(UpdateNode n, Collection<UpdateNode> coll, Set<Resource> set) {
        if (n.getResource() == null) {
            if (coll.size() != 1) {
                return null;
            }
            UpdateNode n2 = coll.iterator().next();
            if (n2.getClass() != n.getClass()) {
                return null;
            }
            return n2;
        }
        for (UpdateNode c : coll) {
            if (!set.contains(c.getResource())) continue;
            return c;
        }
        return null;
    }
}

