/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.AddDeleteUpdateOp;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.layer0.Layer0;

public class SimpleObjectUpdateOp
extends AddDeleteUpdateOp {
    private Statement r;
    protected Resource copyObj;

    public SimpleObjectUpdateOp(Statement r, boolean add, GraphChanges changes) {
        super(changes);
        this.r = r;
        this.add = add;
    }

    @Override
    protected void _apply(WriteGraph g) throws DatabaseException {
        if (this.add) {
            Resource parent = null;
            if (this.getChanges().getComparable().containsRight((Object)this.r.getSubject())) {
                parent = (Resource)this.getChanges().getComparable().getLeft((Object)this.r.getSubject());
            } else {
                Collection<UpdateOp> parentOps = this.getParentOps();
                if (parentOps.size() != 1) {
                    throw new RuntimeException("Parent not found.");
                }
                parent = parentOps.iterator().next().getCreatedResource();
            }
            if (parent == null) {
                throw new RuntimeException("Parent not found.");
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            Resource sourceObj = this.r.getObject();
            this.copyObj = g.newResource();
            SimpleObjectUpdateOp.copyTypes(g, sourceObj, this.copyObj);
            SimpleObjectUpdateOp.copyProperties(g, sourceObj, this.copyObj);
            g.claim(parent, this.r.getPredicate(), this.copyObj);
        } else {
            Resource sourceObj = this.r.getObject();
            g.deny(sourceObj);
        }
    }

    @Override
    public Statement getStatement() {
        return this.r;
    }

    @Override
    public Resource getResource() {
        return this.r.getObject();
    }

    @Override
    public Resource getCreatedResource() {
        return this.copyObj;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.r.getSubject() + " " + this.r.getPredicate() + " " + this.r.getObject();
    }
}

