/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public abstract class AddDeleteUpdateOp
extends UpdateOp {
    protected boolean add;

    public AddDeleteUpdateOp(GraphChanges changes) {
        super(changes);
    }

    public AddDeleteUpdateOp(boolean add, GraphChanges changes) {
        super(changes);
        this.add = add;
    }

    @Override
    public boolean isAdd() {
        return this.add;
    }

    @Override
    public boolean isDelete() {
        return !this.add;
    }

    @Override
    public boolean requiresOp(UpdateOp op) {
        return this.add ? this.getParentOps().contains(op) && op.isAdd() : this.getSubOps().contains(op) && op.isDelete();
    }

    @Override
    public boolean selectOp(UpdateOp op, boolean select) {
        if (select) {
            return this.requiresOp(op);
        }
        return op.requiresOp(this);
    }

    public static void copyProperties(WriteGraph g, Resource source, Resource destination) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        for (Statement s : g.getStatements(source, l0.HasProperty)) {
            if (s.isAsserted(source)) continue;
            if (g.isInstanceOf(s.getObject(), l0.Literal)) {
                Object value = g.getPossibleValue(s.getObject());
                if (value == null) continue;
                Statement valueStm = g.getPossibleStatement(destination, s.getPredicate());
                Resource valueResource = null;
                if (valueStm != null && !valueStm.isAsserted(destination)) {
                    valueResource = valueStm.getObject();
                }
                if (valueResource == null) {
                    valueResource = g.newResource();
                    g.claim(valueResource, l0.InstanceOf, g.getSingleObject(s.getObject(), l0.InstanceOf));
                    g.claim(destination, s.getPredicate(), valueResource);
                }
                g.claimValue(valueResource, value);
                continue;
            }
            if (g.isInstanceOf(s.getObject(), l0.SCLValue)) {
                Resource valueResource = g.newResource();
                g.claim(valueResource, l0.InstanceOf, g.getSingleObject(s.getObject(), l0.InstanceOf));
                g.claim(destination, s.getPredicate(), valueResource);
                AddDeleteUpdateOp.copyProperties(g, s.getObject(), valueResource);
                continue;
            }
            Resource type = g.getPossibleType(s.getObject(), l0.Value);
            if (type != null && g.hasStatement(type, l0.Enumeration, type)) {
                g.deny(destination, s.getPredicate());
                g.claim(destination, s.getPredicate(), s.getObject());
                continue;
            }
            throw new DatabaseException("Expected to copy property resource " + s.getObject());
        }
    }

    public static void copyTags(WriteGraph g, Resource source, Resource destination) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Statement s : g.getStatements(source, L0.IsWeaklyRelatedTo)) {
            if (!s.getObject().equals(source)) continue;
            g.claim(destination, s.getPredicate(), destination);
        }
    }

    public static void copyTypes(WriteGraph g, Resource source, Resource destination) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource r : g.getObjects(source, L0.InstanceOf)) {
            g.claim(destination, L0.InstanceOf, r);
        }
        for (Resource r : g.getObjects(source, L0.Inherits)) {
            g.claim(destination, L0.Inherits, r);
        }
        for (Resource r : g.getObjects(source, L0.SubrelationOf)) {
            g.claim(destination, L0.SubrelationOf, r);
        }
    }

    protected void copyIssues(WriteGraph g, Resource source, Resource destination) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        IssueResource ir = IssueResource.getInstance((ReadGraph)g);
        Collection issues = g.getObjects(source, ir.Issue_HasContext_Inverse);
        for (Resource issue : issues) {
            String label = (String)g.getRelatedValue(issue, l0.HasLabel);
            Resource severity = g.getSingleObject(issue, ir.Issue_HasSeverity);
            List sourceContexts = ListUtils.toList((ReadGraph)g, (Resource)g.getSingleObject(issue, ir.Issue_HasContexts));
            ArrayList<Resource> destinationContext = new ArrayList<Resource>(sourceContexts.size());
            for (Resource r : sourceContexts) {
                if (r.equals(source)) {
                    destinationContext.add(destination);
                    continue;
                }
                if (this.getChanges().getComparable().containsLeft((Object)r)) {
                    destinationContext.add((Resource)this.getChanges().getComparable().getRight((Object)r));
                    continue;
                }
                destinationContext.add(r);
            }
            IssueUtils.newUserIssue((WriteGraph)g, (String)label, (Resource)severity, destinationContext);
        }
    }
}

