/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser.streaming;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.simantics.excel.poi.parser.streaming.SheetImpl;
import org.simantics.excel.poi.parser.streaming.XSSSheetHandler;
import org.simantics.excel.poi.parser.streaming.XSSWorkbookHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SelectiveStreamingParser {
    public boolean process(SheetImpl sheet) {
        return true;
    }

    public void process(Row row) {
    }

    public void processAllSheets(File file) throws Exception {
        OPCPackage pkg = OPCPackage.open((File)file);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XSSWorkbookHandler workbookHandler = new XSSWorkbookHandler();
        XMLReader parser = this.fetchParser(workbookHandler);
        InputStream wb = r.getWorkbookData();
        InputSource wbSource = new InputSource(wb);
        parser.parse(wbSource);
        wb.close();
        Iterator sheets = r.getSheetsData();
        XSSSheetHandler sheetHandler = new XSSSheetHandler(sst){

            @Override
            public void writeRow(Row row) {
                SelectiveStreamingParser.this.process(row);
            }
        };
        parser = this.fetchParser(sheetHandler);
        int sheetIndex = 0;
        while (sheets.hasNext()) {
            SheetImpl sheetImpl = workbookHandler.getSheets().get(sheetIndex);
            ++sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            if (!this.process(sheetImpl)) {
                sheet.close();
                continue;
            }
            sheetHandler.setSheet(sheetImpl);
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public XMLReader fetchParser(ContentHandler handler) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(handler);
        return parser;
    }
}

