/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.simantics.excel.poi.parser.CellDataResolverBase;

public class CellStringArrayDataResolver
extends CellDataResolverBase<String[]> {
    int[] index;
    boolean all = false;

    public CellStringArrayDataResolver(int ... index) {
        this.index = index;
    }

    public CellStringArrayDataResolver(List<Integer> index) {
        this.index = new int[index.size()];
        int i = 0;
        while (i < index.size()) {
            this.index[i] = index.get(i);
            ++i;
        }
    }

    public CellStringArrayDataResolver setAll(boolean all) {
        this.all = all;
        return this;
    }

    @Override
    public String[] getValue(Row row) {
        String value;
        if (row == null) {
            return null;
        }
        if (this.index.length > 1 || !this.all) {
            String[] data = new String[this.index.length];
            int i = 0;
            while (i < data.length) {
                data[i] = this.getCellStringValue(this.getCell(row, this.index[i]));
                ++i;
            }
            return data;
        }
        ArrayList<String> data = new ArrayList<String>();
        int i = this.index[0];
        while ((value = this.getCellStringValue(this.getCell(row, i))) != null && value.length() > 0) {
            data.add(value);
            ++i;
        }
        return data.toArray(new String[data.size()]);
    }
}

