/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.shape;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Mesh;

public class Sphere {
    public static Mesh create(double radius, int s, int p) {
        if (s < 3 || p < 3 || radius < MathTools.NEAR_ZERO) {
            throw new IllegalArgumentException();
        }
        ArrayList<Vector3d> vertices = new ArrayList<Vector3d>((s - 2) * p + 2);
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>(vertices.size());
        ArrayList<Integer> indices = new ArrayList<Integer>(((s - 3) * p * 2 + p * 2) * 3);
        Vector3d v = new Vector3d(0.0, -radius, 0.0);
        Vector3d vp = new Vector3d();
        int ip = 0;
        while (ip < p) {
            int is;
            if (ip == 0) {
                vertices.add(new Vector3d(0.0, -radius, 0.0));
            } else if (ip == p - 1) {
                vertices.add(new Vector3d(0.0, radius, 0.0));
                int off = 1 + (ip - 2) * s;
                is = 0;
                while (is < s) {
                    indices.add(vertices.size() - 1);
                    indices.add(is + off);
                    if (is < s - 1) {
                        indices.add(is + off + 1);
                    } else {
                        indices.add(off);
                    }
                    ++is;
                }
            } else {
                AxisAngle4d aa = new AxisAngle4d(1.0, 0.0, 0.0, (double)ip / (double)(p - 1) * Math.PI);
                MathTools.rotate(MathTools.getQuat(aa), (Tuple3d)v, (Tuple3d)vp);
                is = 0;
                while (is < s) {
                    aa = new AxisAngle4d(0.0, 1.0, 0.0, (double)is / (double)s * Math.PI * 2.0);
                    Vector3d vs = new Vector3d();
                    MathTools.rotate(MathTools.getQuat(aa), (Tuple3d)vp, (Tuple3d)vs);
                    vertices.add(vs);
                    ++is;
                }
                if (ip == 1) {
                    is = 0;
                    while (is < s) {
                        indices.add(0);
                        if (is < s - 1) {
                            indices.add(is + 2);
                        } else {
                            indices.add(1);
                        }
                        indices.add(is + 1);
                        ++is;
                    }
                } else {
                    int off = 1 + (ip - 1) * s;
                    int is2 = 0;
                    while (is2 < s - 1) {
                        indices.add(off + is2 - s);
                        indices.add(off + is2 + 1);
                        indices.add(off + is2);
                        indices.add(off + is2 - s);
                        indices.add(off + is2 + 1 - s);
                        indices.add(off + is2 + 1);
                        ++is2;
                    }
                    indices.add(off - 1);
                    indices.add(off);
                    indices.add(off + s - 1);
                    indices.add(off - 1);
                    indices.add(off - s);
                    indices.add(off);
                }
            }
            ++ip;
        }
        int i = 0;
        while (i < vertices.size()) {
            Vector3d n = new Vector3d((Vector3d)vertices.get(i));
            n.normalize();
            normals.add(n);
            ++i;
        }
        return Mesh.create(vertices, normals, indices);
    }

    public static void main(String[] arg) {
        Mesh s1 = Sphere.create(1.0, 3, 3);
        Mesh s2 = Sphere.create(1.0, 4, 4);
        System.out.println("debug " + s1 + " " + s2);
    }
}

