/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.G3DNode;
import org.simantics.g3d.scenegraph.structural.Connection;
import org.simantics.g3d.scenegraph.structural.IComponentNode;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.utils.datastructures.MapList;

public abstract class G3DComponentNode<T extends Connection<T, T2>, T2 extends IComponentNode<T, T2>>
extends G3DNode
implements IComponentNode<T, T2> {
    private String name;
    private List<IStructuralObject> ctx = new ArrayList<IStructuralObject>(1);
    private List<IStructuralNode> publisher = new ArrayList<IStructuralNode>(1);
    private MapList<String, T> connections = new MapList();

    @Override
    @RelatedGetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @GetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName", tabId="Default", name="Name")
    public String getName() {
        return this.name;
    }

    @RelatedSetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @SetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    public void setName(String name) {
        if (name == null || name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.firePropertyChanged("http://www.simantics.org/Layer0-1.1/HasName");
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isPartOfInstantiatedModel() {
        return this.ctx.size() > 0;
    }

    @Override
    public boolean isExposed() {
        if (this.ctx.size() == 0) {
            return true;
        }
        return this.getPublishedBy().contains(this.ctx.get(0));
    }

    @Override
    public boolean isInstantiatedModelRoot() {
        return this.ctx.size() == 1 && this.equals(this.ctx.get(0));
    }

    @Override
    public boolean isPublishable() {
        return !this.isPartOfInstantiatedModel();
    }

    public List<IStructuralObject> getContext() {
        return this.ctx;
    }

    public void setContext(List<IStructuralObject> object) {
        this.ctx = object;
    }

    protected abstract boolean isValidConnectionId(String var1);

    @Override
    public void connectionChanged(T c, T2 node, boolean add) {
    }

    @Override
    public void addPublishedBy(IStructuralNode node) {
        if (this.publisher.add(node)) {
            this.firePropertyChanged("http://www.simantics.org/G3D-0.1/publishes");
        }
    }

    @Override
    public Collection<IStructuralNode> getPublishedBy() {
        return this.publisher;
    }

    @Override
    public void removePublishedBy(IStructuralNode node) {
        if (this.publisher.remove(node)) {
            this.firePropertyChanged("http://www.simantics.org/G3D-0.1/publishes");
        }
    }

    @Override
    public List<T> getConnections(String id) {
        ArrayList list = new ArrayList();
        list.addAll(this.connections.getValues((Object)id));
        list.addAll(this.connections.getValues((Object)(String.valueOf(id) + "/str")));
        return list;
    }

    @Override
    public List<T2> getAllConnectedNodes() {
        ArrayList list = new ArrayList();
        for (Connection c : this.getAllConnections()) {
            Object node = c.getOther(this);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    @Override
    public void addConnection(String id, T c) {
        assert (this.isValidConnectionId(id));
        if (!this.isPartOfInstantiatedModel()) {
            this._addConnection(id, c);
        } else {
            this._addConnection(String.valueOf(id) + "/str", c);
        }
    }

    @Override
    public void removeConnection(String id, T c) {
        assert (this.isValidConnectionId(id));
        if (!this.isPartOfInstantiatedModel()) {
            this._removeConnection(id, c);
        } else {
            this._removeConnection(String.valueOf(id) + "/str", c);
        }
    }

    @Override
    public void removeConnection(String id) {
        assert (this.isValidConnectionId(id));
        if (!this.isPartOfInstantiatedModel()) {
            this._removeConnection(id);
        } else {
            this._removeConnection(String.valueOf(id) + "/str");
        }
    }

    protected void _addConnection(String id, T c) {
        this.connections.add((Object)id, c);
        ((Connection)c).addConnect((G3DComponentNode)this);
        this.firePropertyChanged(id);
    }

    protected void _addStrConnection(String id, T c) {
        this._addConnection(String.valueOf(id) + "/str", c);
    }

    protected MapList<String, T> _getConnections() {
        return this.connections;
    }

    protected List<T> _getConnections(String id) {
        return this.connections.getValues((Object)id);
    }

    protected List<T> _getStrConnections(String id) {
        return this._getConnections(String.valueOf(id) + "/str");
    }

    protected void _removeConnection(String id, T c) {
        if (this.connections.remove((Object)id, c)) {
            ((Connection)c).remove();
            this.firePropertyChanged(id);
        }
    }

    protected void _removeConnection(String id) {
        ArrayList<T> conns = new ArrayList<T>();
        conns.addAll(this._getConnections(id));
        for (Connection c : conns) {
            this._removeConnection(id, c);
        }
    }

    protected void _removeStrConnection(String id, T c) {
        this._removeConnection(String.valueOf(id) + "/str", c);
    }

    @Override
    public List<T> getAllConnections() {
        ArrayList list = new ArrayList();
        ArrayList keys = new ArrayList();
        keys.addAll(this.connections.getKeys());
        Collections.sort(keys);
        for (String s : keys) {
            list.addAll(this.connections.getValues((Object)s));
        }
        return list;
    }

    @Override
    public void removeConnection(T c) {
        String[] keys;
        String[] stringArray = keys = (String[])this.connections.getKeys((Object[])new String[this.connections.getKeySize()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (this.connections.contains((Object)s, c)) {
                this._removeConnection(s, c);
            }
            ++n2;
        }
    }

    @Override
    public List<T2> getConnectedNodes(String id) {
        ArrayList list = new ArrayList();
        for (Connection c : this.getConnections(id)) {
            Object node = c.getOther(this);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    @Override
    public String getConnectionId(T c) {
        for (String s : this.connections.getKeys()) {
            if (!this.connections.contains((Object)s, c)) continue;
            if (!s.endsWith("/str")) {
                return s;
            }
            return s.substring(0, s.length() - 4);
        }
        return null;
    }

    @Override
    public Collection<String> getConnectionIds(T2 node) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String s : this.connections.getKeys()) {
            for (Connection c : this.connections.getValues((Object)s)) {
                if (!node.equals(c.getOther(this))) continue;
                if (!s.endsWith("/str")) {
                    ids.add(s);
                    continue;
                }
                ids.add(s.substring(0, s.length() - 4));
            }
        }
        return ids;
    }

    @Override
    public void remove() {
        List<T> connections = this.getAllConnections();
        for (Connection c : connections) {
            this.removeConnection(c);
        }
        super.remove();
    }
}

