/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.fileimport;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.fileimport.SimanticsResourceFileImport;
import org.simantics.fmi.studio.core.FMIStudioSCL;
import org.simantics.fmil.core.FMILException;

public class FMIFileImport
extends SimanticsResourceFileImport {
    private static final Map<String, String> EXTENSIONS_FILTERS = Collections.singletonMap("*.fmu", "Functional Mock-up Unit (*.fmu)");

    public Optional<Resource> perform(Resource parent, Path file) {
        try {
            Resource model = FMIStudioSCL.createFMIModel((Resource)parent, (Path)file);
            return Optional.of(model);
        }
        catch (IOException | DatabaseException | FMILException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public Map<String, String> allowedExtensionsWithFilters() {
        return EXTENSIONS_FILTERS;
    }

    public Resource defaultParentResource() {
        return Simantics.getProjectResource();
    }
}

