package org.simantics.databoard.example.old;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.Arrays;

import org.simantics.databoard.Methods;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.method.Client;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.Server;
import org.simantics.databoard.method.TcpConnection;
import org.simantics.databoard.method.TcpConnection.ConnectionListener;
import org.simantics.databoard.serialization.SerializationException;

/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

/**
 * In this example we create CommandProcessor
 * 
 */
public class RPCExample1 {

	public interface CommandProcessor {
		int helloWorld();
//		void elProblem(int i);
//		void elProblem();
		String execute(String command, String...args) throws Error1;
	}

	public static class Error1 extends Exception {
		
		private static final long serialVersionUID = 1L;
		
		public String msg;
		public Error1(String msg) {
			this.msg = msg;
		}
		@Override
		public String toString() {
			return msg;
		}
	}
	
	public static void main(String[] args) throws IOException, BindingConstructionException, SerializationException, BindingException {

		////// Server //////
		// Create service handler
		CommandProcessor myProcessor = new CommandProcessor() {
			public int helloWorld() {
				TcpConnection connection = TcpConnection.getCurrentConnection();
				MethodInterface interfaceToClient = connection;
				
				Socket socket = connection.getSocket();
				System.out.println("Hello "+socket.getRemoteSocketAddress());
				
				connection.addConnectionListener( new ConnectionListener() {
					@Override
					public void onError(Exception error) {
						System.out.println("Error: "+error.getMessage());
					}

					@Override
					public void onClosed() {
						TcpConnection connection = TcpConnection.getCurrentConnection();
						Socket socket = connection.getSocket();
						System.out.println("Bye bye "+socket.getRemoteSocketAddress());
					}} );
					
				return 0;
			}
			
			public String execute(String command, String...args) throws Error1 
			{
				if (!command.equals("start")) throw new Error1("Unknown command "+command);
				return "Program started "+command+" with args "+Arrays.toString(args);
			}

//			public void elProblem() {
//			}
//
//			public void elProblem(int i) {
//			}					
		};
		
		// Adapt the server to a MethodInterface
		MethodInterface myProcessorBinding = Methods.bindInterface(CommandProcessor.class, myProcessor);
		
		// Put the server on a socket
		Server myServerSocket = new Server(8192, myProcessorBinding);

		////// Client //////
		// Connect to the server socket 
		Client myClientSocket = new Client(Inet4Address.getByName("localhost"), 8192);
		
		try {
			CommandProcessor myClient = Methods.createProxy(CommandProcessor.class, myClientSocket);
		
//			myClient.elProblem();
			
			// Hello World
			myClient.helloWorld();
			
			// Execute command "start"
			try {
				String result = myClient.execute("start");
				System.out.println(result);
			} catch (Error1 e) {
				System.err.println(e);
			}

			// Execute command "fault"
			try {
				String result = myClient.execute("fault");
				System.out.println(result);
			} catch (Error1 e) {
				System.err.println(e);
			}
		} finally {
			myClientSocket.close();
			myServerSocket.close();
		}		
		
	}
	
}

