/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TIntShortHashMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.procore.cluster.ForeignTableSmall;
import org.simantics.db.procore.cluster.OutOfSpaceException;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

public class ClusterMapSmall {
    private TableSizeListener sizeListener;
    private ForeignTableSmall foreignTable;
    private TIntShortHashMap hashMap;

    public ClusterMapSmall(TableSizeListener sizeListener, ForeignTableSmall foreignTable) {
        this.sizeListener = sizeListener;
        this.foreignTable = foreignTable;
        this.hashMap = null;
    }

    public ResourceUID getForeignResourceUID(short reference) {
        assert (reference >>> 15 > 0);
        short foreignIndex = (short)(reference ^ 0x8000);
        return this.foreignTable.getResourceUID(foreignIndex);
    }

    public void compact() {
        if (this.hashMap == null) {
            return;
        }
        this.hashMap.compact();
        this.sizeListener.resized();
    }

    public int getUsedSpace() {
        if (this.hashMap == null) {
            return 0;
        }
        int size = this.hashMap.size();
        int cap = this.hashMap.capacity();
        return cap * 8 + size * 24;
    }

    public short getForeignReferenceOrCreateByResourceKey(int resourceKey, ClusterUID uid) throws DatabaseException {
        short foreignIndex;
        if (this.hashMap == null) {
            this.hashMap = this.foreignTable.getResourceHashMap();
        }
        if ((foreignIndex = this.hashMap.get(resourceKey)) == 0) {
            if (this.hashMap.size() >= Short.MAX_VALUE) {
                throw new OutOfSpaceException("Out of space for foreign resources=" + this.hashMap.size());
            }
            foreignIndex = this.foreignTable.createForeign(resourceKey, uid);
            this.hashMap.put(resourceKey, foreignIndex);
        }
        return foreignIndex;
    }

    public short getForeignReferenceOrZero(int resourceKey) throws DatabaseException {
        if (this.hashMap == null) {
            this.hashMap = this.foreignTable.getResourceHashMap();
        }
        return this.hashMap.get(resourceKey);
    }
}

