/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.model;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.ui.wizards.model.SysdynImportModel;
import org.simantics.utils.ui.ErrorLogger;

public class SysdynModelImportPage
extends WizardPage {
    private SysdynImportModel importModel;
    private Text importTarget;
    private CCombo importLocation;
    private Label creation;
    private Text description;
    private Text status;

    protected SysdynModelImportPage(SysdynImportModel importModel) {
        super("Import Sysdyn Model", "Define import location", null);
        this.importModel = importModel;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(20, 10).numColumns(3).applyTo(container);
        new Label(container, 0).setText("Import target:");
        this.importTarget = new Text(container, 2048);
        this.importTarget.setEditable(false);
        this.importTarget.setText("");
        this.importTarget.setToolTipText("Shows the target of the import.");
        this.importTarget.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.importTarget);
        new Label(container, 0).setText("&Model file:");
        this.importLocation = new CCombo(container, 2048);
        this.importLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.importLocation);
        this.importLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SysdynModelImportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Br&owse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SysdynModelImportPage.this.getShell(), 4096);
                dialog.setText("Choose Model to Import");
                File lastFile = new File(SysdynModelImportPage.this.importLocation.getText());
                dialog.setFilterPath(lastFile.getParent());
                dialog.setFilterExtensions(new String[]{"*.sysdyn"});
                dialog.setFilterNames(new String[]{"Sysdyn Model (*.sysdyn)"});
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                SysdynModelImportPage.this.importLocation.setText(file);
                SysdynModelImportPage.this.validatePage();
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.creation = new Label(container, 0);
        this.creation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.creation);
        Label notes = new Label(container, 0);
        notes.setText("Notes:");
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).applyTo((Control)notes);
        this.description = new Text(container, 0x800A0A);
        GridDataFactory.fillDefaults().hint(-1, 150).grab(true, true).span(3, 1).applyTo((Control)this.description);
        this.status = new Text(container, 10);
        this.status.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.status);
        Label horizRule2 = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule2);
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        final AtomicReference projectName = new AtomicReference();
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                projectName.set(NameUtils.getSafeName((ReadGraph)graph, (Resource)Simantics.getProjectResource()));
            }
        });
        this.importTarget.setText((String)projectName.get());
        for (String path : this.importModel.getRecentLocations()) {
            this.importLocation.add(path);
        }
        if (this.importLocation.getItemCount() > 0) {
            this.importLocation.select(0);
        }
    }

    protected void validatePage() {
        String importLoc = this.importLocation.getText();
        if (importLoc.isEmpty()) {
            this.setMessage("Select file to import.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(importLoc);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("Selected file is invalid.");
            this.setPageComplete(false);
            return;
        }
        try {
            this.importModel.setImportLocation(file);
            DataContainer container = DataContainers.readHeader((File)file);
            Variant dateVariant = (Variant)container.metadata.get("date");
            String dateText = dateVariant != null ? dateVariant.getValue().toString() : "Unknown date";
            Variant authorVariant = (Variant)container.metadata.get("author");
            String authorText = authorVariant != null ? authorVariant.getValue().toString() : "Unknown author";
            Variant descriptionVariant = (Variant)container.metadata.get("description");
            String descriptionText = descriptionVariant != null ? descriptionVariant.getValue().toString() : "";
            String creationText = "Created by " + authorText + " on " + dateText;
            this.creation.setText(creationText);
            this.description.setText(descriptionText);
            String statusText = "This model can be imported.";
            if (container.version != 1) {
                this.status.setText("This model cannot be imported.");
                this.setErrorMessage("This model cannot be imported");
                this.setPageComplete(false);
                return;
            }
            this.status.setText(statusText);
            this.creation.getParent().layout();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.creation.setText("");
            this.description.setText("");
            this.status.setText("This model cannot be imported.");
            this.setErrorMessage("Could not read header information from " + file.getAbsolutePath());
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage("Import " + file.getName());
        this.setPageComplete(true);
    }
}

