/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.ui.properties.widgets.modules.ReferenceRow;
import org.simantics.sysdyn.ui.properties.widgets.modules.RowProvider;
import org.simantics.utils.ui.ISelectionUtils;

public class ReferenceTable
implements Widget {
    private TableViewer tableViewer;
    private RowProvider rowProvider;
    public static final String FIRSTCOLUMN = "Inputs";
    public static final String SECONDCOLUMN = "Outputs";

    public ReferenceTable(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        Composite base = new Composite(parent, style);
        GridLayoutFactory.fillDefaults().applyTo(base);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)base);
        Table table = new Table(base, 67588);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getVerticalBar().setVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setComparator((ViewerComparator)new ReferenceRowComparator());
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setRowProvider(RowProvider rowProvider) {
        this.rowProvider = rowProvider;
    }

    public void setContentProvider(IContentProvider provider) {
        this.tableViewer.setContentProvider(provider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider(labelProvider);
    }

    public void setInput(ISessionContext context, Object input) {
        final Resource module = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
        if (this.rowProvider != null) {
            try {
                Simantics.getSession().syncRequest((Read)new Read<ArrayList<ReferenceRow>>(){

                    public ArrayList<ReferenceRow> perform(ReadGraph graph) throws DatabaseException {
                        return ReferenceTable.this.rowProvider.getRows(graph, module);
                    }
                }, (Listener)new Listener<ArrayList<ReferenceRow>>(){

                    public boolean isDisposed() {
                        if (ReferenceTable.this.tableViewer != null && ReferenceTable.this.tableViewer.getTable() != null) {
                            return ReferenceTable.this.getTableViewer().getTable().isDisposed();
                        }
                        return true;
                    }

                    public void execute(final ArrayList<ReferenceRow> result) {
                        if (!this.isDisposed()) {
                            ReferenceTable.this.getTableViewer().getTable().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!this.isDisposed()) {
                                        ReferenceTable.this.getTableViewer().setInput((Object)result);
                                    }
                                }
                            });
                        }
                    }

                    public void exception(Throwable t) {
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    private class ReferenceRowComparator
    extends ViewerComparator {
        private ReferenceRowComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ReferenceRow rr1 = (ReferenceRow)e1;
            ReferenceRow rr2 = (ReferenceRow)e2;
            return rr1.getName().compareTo(rr2.getName());
        }
    }
}

