/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.platform.PropertyPageView;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRepresents;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.properties.SysdynPropertyPage;
import org.simantics.sysdyn.ui.properties.widgets.ArrayExpressionCombo;
import org.simantics.sysdyn.ui.properties.widgets.ExpressionTypes;
import org.simantics.sysdyn.ui.properties.widgets.ExpressionWidget;
import org.simantics.sysdyn.ui.properties.widgets.IsOutputWidget;
import org.simantics.sysdyn.ui.properties.widgets.ShortcutTabWidget;
import org.simantics.sysdyn.ui.properties.widgets.arrays.NameAndArrayRangeModifyListener;
import org.simantics.sysdyn.ui.properties.widgets.expressions.DelayExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionComposite;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.factories.VariableNameInputValidator;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.AdaptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquationTab
extends AdjustableTab
implements Widget {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquationTab.class);
    private TrackedCombo expressionTypeCombo;
    private TrackedCombo unitCombo;
    private TrackedCombo arrayEquationCombo;
    private ShortcutTabWidget shortcutTabWidget;
    private ExpressionWidget expressionWidget;
    private IPartListener2 focusLostListener;
    private IWorkbenchSite site;
    private Button deleteExpression;
    private Button newExpression;
    private WidgetSupportImpl support;
    private ExpressionComposite expressionComposite;
    private final WidgetSupportImpl expressionSupport = new WidgetSupportImpl();
    private Composite nameComposite;
    private Composite TypeAndUnit;
    private Label typeLabel;
    private Label unitLabel;
    private IsOutputWidget isOutput;
    private DataContainer<Boolean> lastActiveInput;

    public EquationTab(Object input) {
        super(input);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport _support) {
        _support.register((Widget)this);
        this.setSupport();
        this.site = site;
        super.createControls(body, site, context, _support);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.composite);
        GridLayoutFactory.fillDefaults().numColumns(wideScreen ? 4 : 3).applyTo(this.nameComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.nameComposite);
        GridDataFactory.fillDefaults().grab(true, false).hint(280, -1).applyTo((Control)this.arrayEquationCombo.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteExpression.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.newExpression.getWidget());
        GridDataFactory.fillDefaults().span(1, wideScreen ? 2 : 3).grab(false, true).hint(250, -1).applyTo((Control)this.shortcutTabWidget.getWidget());
        GridDataFactory.fillDefaults().span(wideScreen ? 1 : 3, 1).grab(true, false).applyTo((Control)this.TypeAndUnit);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(this.TypeAndUnit);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.typeLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.expressionTypeCombo.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.unitLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(160, -1).applyTo((Control)this.unitCombo.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.isOutput.getWidget());
        GridDataFactory.fillDefaults().span(wideScreen ? 4 : 3, 1).grab(true, true).applyTo((Control)this.expressionComposite);
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.nameComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.nameComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.arrayEquationCombo.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteExpression.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.newExpression.getWidget());
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.TypeAndUnit);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.TypeAndUnit);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.typeLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.expressionTypeCombo.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.unitLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(160, -1).applyTo((Control)this.unitCombo.getWidget());
        GridDataFactory.fillDefaults().span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)this.isOutput.getWidget());
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).hint(-1, 250).applyTo((Control)this.expressionComposite);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).hint(-1, 300).applyTo((Control)this.shortcutTabWidget.getWidget());
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport _support) {
        Composite composite;
        this.composite = composite = new Composite(body, 0);
        this.nameComposite = new Composite(composite, 0);
        this.arrayEquationCombo = new ArrayExpressionCombo(this.nameComposite, (WidgetSupport)this.support, 2052);
        this.arrayEquationCombo.setInputValidator((IInputValidator)new VariableNameInputValidator((WidgetSupport)this.support));
        this.arrayEquationCombo.addModifyListener((TextModifyListener)new NameAndArrayRangeModifyListener((WidgetSupport)this.support, this.expressionWidget, (ArrayExpressionCombo)this.arrayEquationCombo));
        this.deleteExpression = new Button(this.nameComposite, (WidgetSupport)this.support, 0);
        this.deleteExpression.setText("Delete");
        this.newExpression = new Button(this.nameComposite, (WidgetSupport)this.support, 0);
        this.newExpression.setText("New");
        this.shortcutTabWidget = new ShortcutTabWidget(composite, (WidgetSupport)this.support, 0);
        this.TypeAndUnit = new Composite(this.nameComposite, 0);
        this.typeLabel = new Label(this.TypeAndUnit, 4);
        this.typeLabel.setText("Type:");
        this.expressionTypeCombo = new TrackedCombo(this.TypeAndUnit, (WidgetSupport)this.support, 2060);
        this.unitLabel = new Label(this.TypeAndUnit, 4);
        this.unitLabel.setText("Unit:");
        this.unitCombo = new TrackedCombo(this.TypeAndUnit, (WidgetSupport)this.support, 2052);
        this.isOutput = new IsOutputWidget(this.TypeAndUnit, (WidgetSupport)this.support, 0);
        this.expressionComposite = new ExpressionComposite(this.nameComposite, 0);
        this.expressionWidget = new ExpressionWidget(this.expressionComposite, (WidgetSupport)this.expressionSupport, 0);
        this.expressionWidget.setVariableTable(this.shortcutTabWidget.getVariableTable());
        this.addListeners(context);
    }

    private void setSupport() {
        this.support = new WidgetSupportImpl(){

            public void fireInput(ISessionContext context, Object input) {
                Variable var = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
                if (var != null) {
                    try {
                        Resource r = (Resource)context.getSession().syncRequest((Read)new VariableRepresents(var));
                        input = new StructuredSelection((Object)r);
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("VariableRepresents failed", (Throwable)e);
                    }
                }
                super.fireInput(context, input);
            }
        };
    }

    public void setInput(final ISessionContext context, Object input) {
        Resource variable;
        this.support.fireInput(context, input);
        if (this.lastActiveInput != null) {
            this.lastActiveInput.set((Object)false);
        }
        this.lastActiveInput = new DataContainer((Object)true);
        final Variable var = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
        if (var != null) {
            try {
                variable = (Resource)Simantics.getSession().syncRequest((Read)new VariableRepresents(var));
            }
            catch (DatabaseException e) {
                LOGGER.error("VariableRepresents failed", (Throwable)e);
                return;
            }
        } else {
            variable = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        }
        if (var == null && variable == null) {
            return;
        }
        final DataContainer<Boolean> isListenerActive = this.lastActiveInput;
        try {
            Simantics.getSession().syncRequest((Read)new ResourceRead<Resource>(variable){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return EquationTab.this.getActiveExpression(graph, this.resource);
                }
            }, (Listener)new ListenerAdapter<Resource>(){

                public void execute(Resource result) {
                    EquationTab.this.composite.getDisplay().asyncExec(() -> {
                        if (Display.getCurrent().isDisposed()) {
                            return;
                        }
                        EquationTab.this.updateExpression(result, variable, context, var);
                    });
                }

                public void exception(Throwable t) {
                    LOGGER.error("Error while reading active expression", t);
                }

                public boolean isDisposed() {
                    return (Boolean)isListenerActive.get() == false || EquationTab.this.composite.isDisposed();
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("getActiveExpression failed", (Throwable)e);
        }
        Simantics.getSession().asyncRequest((Read)new Read<Pair<Boolean, Boolean>>(){

            public Pair<Boolean, Boolean> perform(ReadGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource expressions = graph.getPossibleObject(variable, sr.Variable_expressionList);
                if (expressions == null) {
                    return new Pair((Object)false, (Object)false);
                }
                List expressionList = ListUtils.toList((ReadGraph)graph, (Resource)expressions);
                if (expressionList.isEmpty()) {
                    return new Pair((Object)false, (Object)false);
                }
                boolean canAdd = true;
                boolean canDelete = false;
                if (expressionList.size() > 1) {
                    canDelete = true;
                }
                String defaultRange = ArrayExpressionCombo.getDefaultRange(graph, variable);
                for (Resource expression : expressionList) {
                    String range = (String)graph.getPossibleRelatedValue(expression, sr.Expression_arrayRange);
                    if (range != null && !range.equals("") && !range.equals(defaultRange)) continue;
                    canAdd = false;
                    break;
                }
                return new Pair((Object)canAdd, (Object)canDelete);
            }
        }, (AsyncListener)new AsyncListener<Pair<Boolean, Boolean>>(){

            public void execute(AsyncReadGraph graph, final Pair<Boolean, Boolean> result) {
                EquationTab.this.site.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).EquationTab.this.newExpression.getWidget().isDisposed()) {
                            (this).EquationTab.this.newExpression.getWidget().setEnabled(((Boolean)result.first).booleanValue());
                        }
                        if (!(this).EquationTab.this.deleteExpression.getWidget().isDisposed()) {
                            (this).EquationTab.this.deleteExpression.getWidget().setEnabled(((Boolean)result.second).booleanValue());
                        }
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                LOGGER.error("Error while reading sysdyn variable", throwable);
            }

            public boolean isDisposed() {
                return (Boolean)isListenerActive.get() == false || EquationTab.this.newExpression.getWidget().isDisposed() || EquationTab.this.deleteExpression.getWidget().isDisposed();
            }
        });
    }

    private Resource ensureExpression(final Resource variable) {
        try {
            return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(variable)) {
                        return null;
                    }
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource expressions = ListUtils.create((WriteGraph)graph, Collections.emptyList());
                    graph.claim(variable, sr.Variable_expressionList, expressions);
                    final Resource expression = graph.newResource();
                    if (graph.isInstanceOf(variable, sr.Auxiliary) || graph.isInstanceOf(variable, sr.Valve)) {
                        graph.claim(expression, l0.InstanceOf, null, sr.NormalExpression);
                        graph.claimLiteral(expression, sr.Expression_equation, (Object)"");
                    } else if (graph.isInstanceOf(variable, sr.Stock)) {
                        graph.claim(expression, l0.InstanceOf, null, sr.StockExpression);
                        graph.claimLiteral(expression, sr.StockExpression_initialEquation, (Object)"");
                    }
                    ArrayList<Resource> addition = new ArrayList<Resource>(1);
                    addition.add(expression);
                    ListUtils.insertBack((WriteGraph)graph, (Resource)expressions, addition);
                    graph.claim(variable, l0.ConsistsOf, expression);
                    VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                    final Session session = graph.getSession();
                    session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("expressions")){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                            session.asyncRequest((Write)new WriteRequest(runtime){

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                    if (graph.hasStatement(variable, sr.IndependentVariable_activeExpression)) {
                                        graph.deny(variable, sr.IndependentVariable_activeExpression);
                                    }
                                    graph.claim(variable, sr.IndependentVariable_activeExpression, expression);
                                }
                            });
                        }
                    });
                    return expression;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addListeners(ISessionContext context) {
        this.shortcutTabWidget.addDependencyListener(new Runnable(){

            @Override
            public void run() {
                EquationTab.this.expressionWidget.validateFields();
            }
        });
        this.deleteExpression.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, final Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                Resource activeExpression = graph.getPossibleObject(input, sr.IndependentVariable_activeExpression);
                if (activeExpression == null) {
                    return;
                }
                Resource expressionList = graph.getPossibleObject(input, sr.Variable_expressionList);
                List list = ListUtils.toList((ReadGraph)graph, (Resource)expressionList);
                if (list.size() <= 1) {
                    return;
                }
                int index = list.indexOf(activeExpression);
                ListUtils.removeElement((WriteGraph)graph, (Resource)expressionList, (Resource)activeExpression);
                graph.deny(input, l0.ConsistsOf, activeExpression);
                final Resource newActive = index == 0 ? (Resource)list.get(1) : (Resource)list.get(index - 1);
                VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                final Session session = graph.getSession();
                session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("expressions")){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                        session.asyncRequest((Write)new WriteRequest(runtime){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                if (graph.hasStatement(input, sr.IndependentVariable_activeExpression)) {
                                    graph.deny(input, sr.IndependentVariable_activeExpression);
                                }
                                graph.claim(input, sr.IndependentVariable_activeExpression, newActive);
                            }
                        });
                    }
                });
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Deleted Expression " + activeExpression + " from " + graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
        this.newExpression.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                Resource expressions = graph.getPossibleObject(input, sr.Variable_expressionList);
                if (expressions == null) {
                    return;
                }
                Resource activeExpression = graph.getPossibleObject(input, sr.IndependentVariable_activeExpression);
                Resource newExpression = graph.newResource();
                if (activeExpression != null) {
                    graph.claim(newExpression, l0.InstanceOf, graph.getSingleObject(activeExpression, l0.InstanceOf));
                    if (graph.isInstanceOf(newExpression, sr.StockExpression)) {
                        graph.claimLiteral(newExpression, sr.StockExpression_initialEquation, (Object)"");
                        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new Stock Expression " + newExpression + " for " + graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
                    }
                } else {
                    graph.claim(newExpression, l0.InstanceOf, sr.NormalExpression);
                    graph.claimLiteral(newExpression, sr.Expression_equation, (Object)"");
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new Normal Expression " + newExpression + " for " + graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
                }
                ArrayList<Resource> addition = new ArrayList<Resource>(1);
                addition.add(newExpression);
                ListUtils.insertBack((WriteGraph)graph, (Resource)expressions, addition);
                graph.claim(input, l0.ConsistsOf, newExpression);
            }
        });
        this.expressionTypeCombo.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                ExpressionTypes.ExpressionType[] expressionTypes = graph.isInstanceOf(input, sr.Auxiliary) ? ExpressionTypes.auxiliaryExpressions : (graph.isInstanceOf(input, sr.Stock) ? ExpressionTypes.stockExpressions : (graph.isInstanceOf(input, sr.Valve) ? ExpressionTypes.valveExpressions : new ExpressionTypes.ExpressionType[]{}));
                ExpressionTypes.ExpressionType[] expressionTypeArray = expressionTypes;
                int n = expressionTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpressionTypes.ExpressionType et = expressionTypeArray[n2];
                    map.put(et.toString(), (Object)et);
                    ++n2;
                }
                return map;
            }
        });
        this.expressionTypeCombo.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                Resource activeExpression = EquationTab.this.getActiveExpression(graph, input);
                if (activeExpression == null) {
                    return null;
                }
                return ExpressionTypes.getExpressionType(graph, activeExpression).toString();
            }
        });
        this.expressionTypeCombo.addModifyListener(new TextModifyListener(){

            public void modifyText(TrackedModifyEvent e) {
                EquationTab.this.expressionWidget.displayExpression(e.getText(), false);
                EquationTab.this.expressionWidget.save();
            }
        });
        this.unitCombo.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                Resource model = graph.getPossibleObject(input, l0.PartOf);
                if (model != null) {
                    Collection variables = graph.getObjects(model, l0.ConsistsOf);
                    for (Resource v : variables) {
                        Object unit = graph.getPossibleRelatedValue(v, sr.Variable_unit);
                        if (unit == null || map.keySet().contains(unit)) continue;
                        map.put((String)unit, (String)unit);
                    }
                }
                return map;
            }
        });
        this.unitCombo.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                String unit = (String)graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
                if (unit == null) {
                    return "";
                }
                return unit;
            }
        });
        this.unitCombo.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                graph.denyValue(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit, (Object)text);
                Resource conf = graph.getPossibleObject(input, Layer0.getInstance((ReadGraph)graph).PartOf);
                SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
                SysdynModel sm = smm.getModel((ReadGraph)graph, conf);
                sm.getMapping().domainModified(input);
                sm.update((ReadGraph)graph);
            }
        });
        this.shortcutTabWidget.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Table table = (Table)e.widget;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null) {
                    final String var = (String)item.getData();
                    table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).EquationTab.this.expressionWidget != null) {
                                (this).EquationTab.this.expressionWidget.getExpression().focus();
                                (this).EquationTab.this.expressionWidget.getExpression().replaceSelection(var);
                                (this).EquationTab.this.expressionWidget.validateFieldsTimed();
                            }
                        }
                    });
                }
            }

            public void mouseDown(MouseEvent e) {
                EquationTab.this.expressionWidget.getExpression().focus();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.expressionWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EquationTab.this.expressionWidget.validateFieldsTimed();
            }
        });
        this.expressionWidget.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                boolean isAnyAssistSessionActive = false;
                int i = 0;
                while (i < EquationTab.this.expressionWidget.getExpression().getExpressionFields().size()) {
                    if (EquationTab.this.expressionWidget.getExpression().getExpressionFields().get(i).isAssistSessionActive()) {
                        isAnyAssistSessionActive = true;
                        break;
                    }
                    ++i;
                }
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    if (!isAnyAssistSessionActive) {
                        if ((event.stateMask & 0x20000) == 0) {
                            event.doit = false;
                            ((StyledText)event.widget).getParent().forceFocus();
                            EquationTab.this.expressionWidget.save();
                        }
                    } else {
                        EquationTab.this.expressionWidget.validateFieldsTimed();
                    }
                }
            }
        });
        if (this.focusLostListener == null) {
            this.focusLostListener = new IPartListener2(){

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                    PropertyPageView ppv;
                    if (partRef.getPart(false) instanceof PropertyPageView && (ppv = (PropertyPageView)partRef.getPart(false)).getCurrentPage() instanceof SysdynPropertyPage && EquationTab.this.expressionWidget != null) {
                        EquationTab.this.expressionWidget.save();
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partActivated(IWorkbenchPartReference partRef) {
                }
            };
            this.site.getPage().addPartListener(this.focusLostListener);
        }
    }

    private void updateExpression(Resource currentExpression, Resource variable, ISessionContext context, Variable var) {
        Resource expression = currentExpression;
        if (expression == null && variable != null) {
            expression = this.ensureExpression(variable);
        }
        if (expression == null) {
            return;
        }
        StructuredSelection ss = new StructuredSelection((Object)new ExpressionWidgetInput(var, expression));
        this.expressionSupport.fireInput(context, (Object)ss);
    }

    public void dispose() {
        if (this.lastActiveInput != null) {
            this.lastActiveInput.set((Object)false);
        }
        if (this.expressionWidget != null && !(this.expressionWidget.getExpression() instanceof DelayExpression)) {
            this.expressionWidget.save();
        }
        if (this.focusLostListener != null && this.site != null) {
            this.site.getPage().removePartListener(this.focusLostListener);
        }
        super.dispose();
        if (this.expressionComposite != null && !this.expressionComposite.isDisposed()) {
            this.expressionComposite.dispose();
        }
    }

    private Resource getActiveExpression(ReadGraph graph, Resource variable) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource expression = graph.getPossibleObject(variable, sr.IndependentVariable_activeExpression);
        if (expression == null) {
            Resource expressions = graph.getPossibleObject(variable, sr.Variable_expressionList);
            if (expressions == null) {
                return null;
            }
            List expressionList = ListUtils.toList((ReadGraph)graph, (Resource)expressions);
            if (expressionList.isEmpty()) {
                return null;
            }
            expression = (Resource)expressionList.get(0);
        }
        return expression;
    }
}

