/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.connection.rendering.BasicConnectionStyle;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.LoopNode;
import org.simantics.sysdyn.ui.elements.connections.Flows;

public class FlowConnectionStyle
extends BasicConnectionStyle {
    private static final long serialVersionUID = 2777194644079591357L;
    Color lineColor;
    Stroke lineStroke;
    private Resource resource;
    private boolean loopColorOverride = false;
    public static final float DEFAULT_LINE_WIDTH = 1.0f;

    public FlowConnectionStyle(Color lineColor, Stroke lineStroke, Resource resource) {
        super(lineColor, Color.BLACK, 0.5, lineStroke, lineStroke, 0.8);
        this.lineColor = lineColor;
        this.lineStroke = lineStroke;
        this.resource = resource;
    }

    public void drawBranchPoint(Graphics2D g, double x, double y) {
    }

    public void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, boolean isTransient) {
    }

    public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
        if (this.lineColor != null) {
            g.setColor(this.loopColorOverride ? LoopNode.HIGHLIGHT_COLOR : this.lineColor);
        }
        if (this.lineStroke != null) {
            g.setStroke(this.lineStroke);
        }
        Float width = Float.valueOf(1.0f);
        try {
            Float connectionWidth = (Float)Simantics.getSession().syncRequest((Read)new Read<Float>(){

                public Float perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    if (FlowConnectionStyle.this.resource == null) {
                        return null;
                    }
                    return (Float)graph.getPossibleRelatedValue(FlowConnectionStyle.this.resource, sr.FlowConnection_width, (Binding)Bindings.FLOAT);
                }
            });
            if (connectionWidth != null) {
                width = connectionWidth;
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        Path2D p1 = Flows.createOffsetPath(path, width.floatValue() / 2.0f);
        Path2D p2 = Flows.createOffsetPath(path, -width.floatValue() / 2.0f);
        p1.append(p2, false);
        g.draw(p1);
    }

    public void drawDegeneratedLine(Graphics2D g, double x, double y, boolean isHorizontal, boolean isTransient) {
    }

    public double getDegeneratedLineLength() {
        return 0.0;
    }

    public void setLoopColorOverride(boolean loopColorOverride) {
        this.loopColorOverride = loopColorOverride;
    }
}

