/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.ExternalRead;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.elements.ElementPropertySetter;
import org.simantics.diagram.elements.ResizeRectangularSceneGraph;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.ComponentNameSynchronizer;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPropertyExternalRead;
import org.simantics.utils.datastructures.Pair;

public abstract class SysdynElementFactory
extends SyncElementFactory {
    public static final IHintSynchronizer SYNCHRONIZER = new CompositeHintSynchronizer(new IHintSynchronizer[]{ComponentNameSynchronizer.INSTANCE, TransformSynchronizer.INSTANCE});
    public static final ElementPropertySetter RESIZE_PROPERTY_SETTER = new ElementPropertySetter(ResizeRectangularSceneGraph.KEY_SG_NODE);

    protected String getText(ReadGraph graph, Resource element) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
        String text = null;
        if (component != null) {
            text = (String)graph.getPossibleRelatedValue(component, l0.HasName);
        }
        if (text == null) {
            text = "[empty]";
        }
        return text;
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        e.setHint(ElementHints.KEY_RESIZABLE, (Object)true);
        ElementUtils.setText((IElement)e, (String)this.getText(graph, element));
        this.getVisualProperties(graph, element, e);
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)SYNCHRONIZER);
        e.setHint(ElementHints.KEY_HOVER, (Object)false);
    }

    protected void getVisualProperties(ReadGraph graph, Resource element, IElement e) throws DatabaseException {
        double[] bounds;
        Resource component;
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, dr.FontProvider)) {
            Statement fontStatement = graph.getPossibleStatement(element, g2d.HasFont);
            if (fontStatement != null && !fontStatement.isAsserted(element)) {
                ElementUtils.setTextFont((IElement)e, (Font)G2DUtils.getFont((ReadGraph)graph, (Resource)fontStatement.getObject()));
            } else {
                FontData fd;
                FontData[] fdArray;
                String fontdata = (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)new Pair((Object)element, (Object)SysdynDiagramPreferences.getFontPreferenceName(graph, element))));
                if (fontdata != null && (fdArray = PreferenceConverter.basicGetFontData((String)fontdata)) != null && fdArray.length == 1 && (fd = fdArray[0]) != null) {
                    Font font = new Font(fd.getName(), fd.getStyle(), fd.getHeight());
                    e.setHint(ElementHints.KEY_FONT, (Object)font);
                }
            }
        }
        if (graph.isInstanceOf(element, dr.ColorProvider)) {
            Statement colorStatement = graph.getPossibleStatement(element, g2d.HasColor);
            if (colorStatement != null && !colorStatement.isAsserted(element)) {
                ElementUtils.setTextColor((IElement)e, (Color)G2DUtils.getColor((ReadGraph)graph, (Resource)colorStatement.getObject()));
            } else {
                RGB rgb;
                String color = (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)new Pair((Object)element, (Object)SysdynDiagramPreferences.getColorPreferenceName(graph, element))));
                if (color != null && (rgb = StringConverter.asRGB((String)color, null)) != null) {
                    Color c = new Color(rgb.red, rgb.green, rgb.blue);
                    ElementUtils.setTextColor((IElement)e, (Color)c);
                    e.setHint(ElementHints.KEY_BORDER_COLOR, (Object)c);
                }
            }
        }
        if ((component = graph.getPossibleObject(element, mr.ElementToComponent)) != null && graph.hasStatement(component, SysdynResource.getInstance((ReadGraph)graph).IsOutput)) {
            Font font;
            font = font.deriveFont((font = ElementUtils.getTextFont((IElement)e)).isItalic() ? 3 : 1);
            ElementUtils.setTextFont((IElement)e, (Font)font);
        }
        if ((bounds = DiagramGraphUtil.getPossibleRelatedDoubleArray((ReadGraph)graph, (Resource)element, (Resource)G2DResource.getInstance((ReadGraph)graph).HasBounds)) != null) {
            e.setHint(ElementHints.KEY_BOUNDS, (Object)new Rectangle2D.Double(bounds[0], bounds[1], bounds[2], bounds[3]));
        }
    }

    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        return this.compileElementClass(elementType, SysdynElementFactory.createTerminals(graph, elementType));
    }

    public static Collection<ObjectTerminal> createTerminals(ReadGraph graph, Resource elementType) {
        try {
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
            Resource definedByList = graph.getPossibleObject(elementType, sr.IsDefinedBy);
            List definedBy = Collections.emptyList();
            if (definedByList != null) {
                definedBy = OrderedSetUtils.toList((ReadGraph)graph, (Resource)definedByList);
            }
            ArrayList<ObjectTerminal> terminals = new ArrayList<ObjectTerminal>(definedBy.size());
            for (Resource r : definedBy) {
                if (!graph.isInstanceOf(r, dr.Terminal)) continue;
                terminals.add((ObjectTerminal)new ResourceTerminal(r));
            }
            return terminals;
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected abstract ElementClass compileElementClass(Resource var1, Collection<ObjectTerminal> var2);
}

