/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import java.util.Collections;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.diagram.handler.DeleteHandler;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.tooltip.TerminalTooltipParticipant;
import org.simantics.jfreechart.chart.element.PopulateChartDropParticipant;
import org.simantics.modeling.mapping.ElementCopyAdvisor;
import org.simantics.modeling.mapping.MappedElementCopyAdvisor;
import org.simantics.modeling.ui.diagramEditor.handlers.LinkBrowsingHandler;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.editor.SysdynConnectionAdvisor;
import org.simantics.sysdyn.ui.editor.participant.CreateVariablesShortcutParticipant;
import org.simantics.sysdyn.ui.editor.participant.SelectionUpdaterParticipant;
import org.simantics.sysdyn.ui.editor.participant.SysdynComponentCopyAdvisor;
import org.simantics.sysdyn.ui.editor.participant.SysdynElementClassProviders;
import org.simantics.sysdyn.ui.editor.participant.SysdynPointerInteractor;
import org.simantics.sysdyn.ui.editor.participant.SysdynPopulateElementDropParticipant;
import org.simantics.sysdyn.ui.elements.CloudFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementClasses;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.connections.ConnectionClasses;
import org.simantics.sysdyn.ui.elements.connections.RouteFlowEdgeClass;
import org.simantics.sysdyn.ui.elements.connections.SysdynConnectionClass;
import org.simantics.sysdyn.ui.handlers.ExtendedCopyPasteHandler;
import org.simantics.sysdyn.ui.properties.SysdynPropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class DiagramViewer
extends org.simantics.modeling.ui.diagramEditor.DiagramViewer {
    protected String getPopupId() {
        return "#SysdynDiagramPopup";
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected Set<String> getPropertyPageContexts() {
        return Collections.singleton("http://www.simantics.org/Sysdyn-1.1/Browser");
    }

    protected IPropertyPage createPropertyPage(IWorkbenchPartSite site, Set<String> contexts) {
        return new SysdynPropertyPage(site, contexts);
    }

    protected IElementClassProvider createElementClassProvider(ReadGraph graph) {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ElementClass dependencyClass = SysdynConnectionClass.CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)sr.DependencyConnection)});
        ElementClass flowClass = RouteFlowEdgeClass.FLOW_CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)sr.FlowConnection)});
        return SysdynElementClassProviders.mappedProvider(ElementClasses.CONNECTION, dependencyClass, ElementClasses.FLAG, CloudFactory.createElementClass(sr.CloudSymbol, SysdynElementFactory.createTerminals(graph, sr.CloudSymbol)), ConnectionClasses.FLOW, flowClass, ConnectionClasses.DEPENDENCY, dependencyClass, SysdynElementClasses.VALVE, CloudFactory.createElementClass(sr.ValveSymbol, SysdynElementFactory.createTerminals(graph, sr.ValveSymbol)));
    }

    public void initializeCanvasContext(CanvasContext ctx) {
        super.initializeCanvasContext(ctx);
        IHintContext h = ctx.getDefaultHintContext();
        h.setHint(GridPainter.KEY_GRID_ENABLED, (Object)Boolean.FALSE);
        h.setHint(RulerPainter.KEY_RULER_ENABLED, (Object)Boolean.FALSE);
        h.setHint(Hints.KEY_DISPLAY_MARGINS, (Object)Boolean.FALSE);
        h.setHint(Hints.KEY_DISPLAY_PAGE, (Object)Boolean.FALSE);
    }

    protected void onCreated() {
        this.sourceDiagram.setHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS, (Object)Boolean.FALSE);
        this.sourceDiagram.setHint(SynchronizationHints.COPY_ADVISOR, (Object)new MappedElementCopyAdvisor((CopyAdvisor)new ElementCopyAdvisor(), (CopyAdvisor)new SysdynComponentCopyAdvisor()));
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (DiagramViewer.this.isDisposed()) {
                    return;
                }
                if (DiagramViewer.this.canvasContext != null && DiagramViewer.this.sourceDiagram != null) {
                    ElementPainter ep = (ElementPainter)DiagramViewer.this.canvasContext.getSingleItem(ElementPainter.class);
                    for (IElement e : DiagramViewer.this.sourceDiagram.getElements()) {
                        if (!e.getElementClass().getId().contains("Connection")) continue;
                        ep.update(e);
                    }
                }
            }
        });
    }

    protected void addKeyBindingParticipants(CanvasContext ctx) {
        ctx.add((Object)new DeleteHandler(this.getEditorSite().getActionBars().getStatusLineManager()));
        ctx.add((Object)new CreateVariablesShortcutParticipant(this.synchronizer));
        ctx.add((Object)new ExtendedCopyPasteHandler(this.getEditorSite().getActionBars().getStatusLineManager()).setWorkbenchSite((IWorkbenchPartSite)this.getEditorSite()));
    }

    protected void initializeSynchronizationContext(ReadGraph graph, IModifiableSynchronizationContext context) {
        super.initializeSynchronizationContext(graph, context);
        SysdynResource.getInstance((ReadGraph)graph);
    }

    protected void addStructureParticipants(ICanvasContext ctx) {
        this.addWorkbenchSelectionProvider(ctx);
        ctx.add((Object)new LinkBrowsingHandler(this.getSite(), (org.simantics.modeling.ui.diagramEditor.DiagramViewer)this, this.sessionContext));
    }

    protected void addDropParticipants(ICanvasContext ctx) {
        ctx.getDefaultHintContext().setHint(Hints.KEY_ALLOWED_DRAG_ACTIONS, (Object)1);
        ctx.add((Object)new SysdynPopulateElementDropParticipant(this.synchronizer));
        ctx.add((Object)new PopulateChartDropParticipant(this.synchronizer));
    }

    protected void addOtherParticipants(CanvasContext ctx) {
        ctx.add((Object)new SelectionUpdaterParticipant());
    }

    protected PointerInteractor getPointerInteractor() {
        return new SysdynPointerInteractor(true, true, true, false, true, false, this.synchronizer.getElementClassProvider(), PickRequest.PickSorter.CONNECTIONS_FIRST);
    }

    protected IConnectionAdvisor getConnectionAdvisor(IModelingRules modelingRules, Session session) {
        return new SysdynConnectionAdvisor(modelingRules, (RequestProcessor)this.sessionContext.getSession());
    }

    protected void addDiagramParticipants(ICanvasContext ctx) {
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)this.getPointerInteractor());
        ctx.add((Object)new ElementInteractor(PickRequest.PickSorter.CONNECTIONS_FIRST));
        ctx.add((Object)new Selection());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new TerminalTooltipParticipant());
    }
}

