/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.contribution;

import java.awt.Color;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.event.Activator;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.Constants;
import org.simantics.event.view.contribution.EventTypeImageDescriptorRequest;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor;
import org.simantics.utils.ui.gfx.CompositionImageDescriptor;
import org.simantics.utils.ui.gfx.TextImageDescriptor;

public enum EventImageRule implements ImageRule
{
    INSTANCE;


    public static EventImageRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource event = (Resource)content;
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        ImageDescriptor eventIcon = null;
        ImageDescriptor milestoneIcon = null;
        ImageDescriptor returnIcon = null;
        Resource eventType = graph.getPossibleObject(event, EVENT.Event_type);
        if (eventType != null) {
            eventIcon = (ImageDescriptor)graph.syncRequest((Read)new EventTypeImageDescriptorRequest(eventType));
        }
        if (graph.hasStatement(event, EVENT.Milestone)) {
            boolean isBasetime;
            String label = (String)graph.getPossibleRelatedValue(event, EVENT.Event_milestoneLabel);
            if (label == null) {
                label = "?";
            }
            ImageDescriptor diamond = (isBasetime = graph.hasStatement(event, EVENT.EventLog_HasBaselineEvent_Inverse)) ? Activator.DIAMOND2_ICON : Activator.DIAMOND_ICON;
            int color = isBasetime ? 0 : Color.ORANGE.getRGB();
            TextImageDescriptor number = new TextImageDescriptor(label, 16, 16, "Tahoma", 8, 0, color);
            milestoneIcon = CompositionImageDescriptor.compose((ImageDescriptor[])new ImageDescriptor[]{diamond, number});
        }
        if (!graph.hasStatement(event, EVENT.NoReturn)) {
            returnIcon = graph.hasStatement(event, EVENT.ReturnedBy) ? BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/tick.png") : (graph.hasStatement(event, EVENT.ReturnEvent) ? BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_undo.png") : BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/cross.png"));
        }
        boolean hidden = graph.hasStatement(event, EVENT.Hidden);
        eventIcon = EventImageRule.fade(eventIcon, hidden);
        milestoneIcon = EventImageRule.fade(milestoneIcon, hidden);
        returnIcon = EventImageRule.fade(returnIcon, hidden);
        Object[] objectArray = new ImageDescriptor[11];
        objectArray[3] = milestoneIcon;
        objectArray[4] = eventIcon;
        objectArray[5] = returnIcon;
        return ArrayMap.make((Object[])Constants.COLUMN_KEYS, (Object[])objectArray);
    }

    private static ImageDescriptor fade(ImageDescriptor desc, boolean doIt) {
        return desc != null && doIt ? AlphaAdjustmentImageDescriptor.adjustAlpha((ImageDescriptor)desc, (int)128) : desc;
    }
}

