/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.simantics.browsing.ui.swt.widgets.DefaultColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;

public class TrackedText
implements Widget {
    public static final String ID = "TRACKED_TEXT";
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int state = 0;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private final Display display;
    private final Text text;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private ITrackedColorProvider colorProvider;
    private final ResourceManager resourceManager;
    private ReadFactory<?, String> textFactory;
    private boolean moveCaretAfterEdit = true;
    private boolean selectAllOnStartEdit = true;
    private final CopyOnWriteArrayList<Consumer<String>> validationListeners = new CopyOnWriteArrayList();
    private static final int MAX_STACK_SIZE = 25;
    private List<String> undoStack = new LinkedList<String>();
    private List<String> redoStack = new LinkedList<String>();

    public void setTextFactory(ReadFactory<?, String> textFactory) {
        this.textFactory = textFactory;
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public void setMoveCaretAfterEdit(boolean value) {
        this.moveCaretAfterEdit = value;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.modifyListeners != null) {
            Object[] objectArray = this.modifyListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Widget) {
                    ((Widget)o).setInput(context, input);
                }
                ++n2;
            }
        }
        if (this.textFactory != null) {
            this.textFactory.listen(context, input, new Listener<String>(){

                public void exception(final Throwable t) {
                    TrackedText.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            (this).TrackedText.this.text.setText(t.toString());
                        }
                    });
                }

                public void execute(final String string) {
                    if (TrackedText.this.text.isDisposed()) {
                        return;
                    }
                    TrackedText.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            (this).TrackedText.this.text.setText(string == null ? "" : string);
                        }
                    });
                }

                public boolean isDisposed() {
                    return TrackedText.this.text.isDisposed();
                }
            });
        }
    }

    public TrackedText(Composite parent, WidgetSupport support, int style) {
        this.text = new Text(parent, style);
        this.text.setData(ID, (Object)this);
        this.display = this.text.getDisplay();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.text);
        this.colorProvider = new DefaultColorProvider(this.resourceManager);
        if (support != null) {
            support.register(this);
        }
        this.initialize();
        this.createUndoRedoHandler();
    }

    private void createUndoRedoHandler() {
        this.text.addModifyListener(new ModifyListener(){
            private int eventTimeOut = 1000;
            private long lastEventTimeStamp = 0L;

            public void modifyText(ModifyEvent event) {
                String newText = TrackedText.this.text.getText().trim();
                if (((long)event.time - this.lastEventTimeStamp > (long)this.eventTimeOut || newText.endsWith(" ")) && newText != null && newText.length() > 0) {
                    if (TrackedText.this.undoStack.size() == 25) {
                        TrackedText.this.undoStack.remove(TrackedText.this.undoStack.size() - 1);
                    }
                    TrackedText.this.addToUndoStack(newText);
                }
                this.lastEventTimeStamp = (long)event.time & 0xFFFFFFFFL;
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.simantics.ui.states.trackedText");
                State state = command.getState("org.simantics.ui.states.trackedText.state");
                state.setValue((Object)true);
            }

            public void focusGained(FocusEvent e) {
                TrackedText.this.addToUndoStack(TrackedText.this.text.getText());
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.simantics.ui.states.trackedText");
                State state = command.getState("org.simantics.ui.states.trackedText.state");
                state.setValue((Object)false);
            }
        });
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private void initialize() {
        Assert.isNotNull((Object)this.text);
        this.text.setBackground(this.colorProvider.getInactiveBackground());
        this.text.setDoubleClickEnabled(false);
        this.listener = new CompositeListener();
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addDisposeListener((DisposeListener)this.listener);
        this.text.addKeyListener((KeyListener)this.listener);
        this.text.addMouseTrackListener((MouseTrackListener)this.listener);
        this.text.addMouseListener((MouseListener)this.listener);
        this.text.addFocusListener((FocusListener)this.listener);
    }

    public void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        this.caretPositionBeforeEdit = this.text.getCaretPosition();
        this.textBeforeEdit = this.text.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.text.selectAll();
        }
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            try {
                if (this.isTextValid() != null) {
                    this.text.setText(this.textBeforeEdit);
                } else if (this.isModified() && !this.text.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                    TrackedModifyEvent event = new TrackedModifyEvent((org.eclipse.swt.widgets.Widget)this.text, this.text.getText());
                    Object[] objectArray = this.modifyListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ((TextModifyListener)o).modifyText(event);
                        ++n2;
                    }
                    this.moveCursorToEnd();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.endEdit();
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        if (this.text.isDisposed()) {
            return;
        }
        this.isEditing();
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        if (this.moveCaretAfterEdit) {
            this.text.setSelection(this.text.getCharCount());
        }
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.text.setText(this.textBeforeEdit);
        this.text.setSelection(this.caretPositionBeforeEdit);
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    private boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setSelectAllOnStartEdit(boolean selectAll) {
        this.selectAllOnStartEdit = selectAll;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.text.setEditable(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.text.setEditable(false);
            this.text.setBackground(null);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
        this.addToUndoStack(text);
    }

    private void addToUndoStack(String text) {
        if (this.isTextValid() != null) {
            return;
        }
        String newText = text.trim();
        if (this.undoStack.size() == 0) {
            this.undoStack.add(0, newText);
        } else if (!this.undoStack.get(0).equals(newText)) {
            this.undoStack.add(0, newText);
        }
    }

    public void setTextWithoutNotify(String text) {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    public Text getWidget() {
        return this.text;
    }

    public synchronized void addModifyListener(TextModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TextModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            String result = this.validator.isValid(this.getWidget().getText());
            for (Consumer<String> listener : this.validationListeners) {
                listener.accept(result);
            }
            return result;
        }
        return null;
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    private void setBackground(Color background) {
        if (this.text.isDisposed()) {
            return;
        }
        if (!this.text.getEditable()) {
            return;
        }
        this.text.setBackground(background);
    }

    public boolean isDisposed() {
        return this.text.isDisposed();
    }

    public Display getDisplay() {
        return this.display;
    }

    public void addValidationListener(Consumer<String> listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(Consumer<String> listener) {
        this.validationListeners.remove(listener);
    }

    public String getText() {
        return this.text.getText();
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public void undo() {
        if (this.undoStack.size() > 0) {
            String currText;
            String lastEdit = this.undoStack.remove(0);
            if (lastEdit.equals(this.text.getText().trim())) {
                if (this.undoStack.size() == 0) {
                    return;
                }
                lastEdit = this.undoStack.remove(0);
            }
            this.textBeforeEdit = currText = this.text.getText();
            this.text.setText(lastEdit);
            this.moveCursorToEnd();
            this.redoStack.add(0, currText);
        }
    }

    public void redo() {
        if (this.redoStack.size() > 0) {
            String text = this.redoStack.remove(0);
            this.moveCursorToEnd();
            String currText = this.text.getText();
            this.addToUndoStack(currText);
            this.textBeforeEdit = currText;
            this.text.setText(text);
            this.moveCursorToEnd();
        }
    }

    private void moveCursorToEnd() {
        this.text.setSelection(this.text.getText().length());
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            TrackedText.this.setModified(true);
            String valid = TrackedText.this.isTextValid();
            if (valid != null) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInvalidBackground());
            } else if (TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getEditingBackground());
            } else {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInactiveBackground());
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TrackedText.this.getWidget().removeModifyListener((ModifyListener)this);
        }

        private boolean isMultiLine() {
            return (TrackedText.this.text.getStyle() & 2) != 0;
        }

        private boolean hasMultiLineCommitModifier(KeyEvent e) {
            return (e.stateMask & 0x40000) != 0;
        }

        public void keyPressed(KeyEvent e) {
            if (!TrackedText.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 0x100000B || e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedText.this.startEdit(TrackedText.this.selectAllOnStartEdit);
                    } else if (e.character != '\u0000') {
                        TrackedText.this.startEdit(false);
                    }
                } else if (e.keyCode == 0x100000B) {
                    TrackedText.this.startEdit(TrackedText.this.selectAllOnStartEdit);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (this.hasMultiLineCommitModifier(e)) {
                        e.doit = false;
                    } else {
                        TrackedText.this.startEdit(false);
                    }
                } else if (e.keyCode == 9) {
                    TrackedText.this.text.traverse((e.stateMask & 0x20000) != 0 ? 8 : 16);
                    e.doit = false;
                } else if (e.character != '\u0000') {
                    TrackedText.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    TrackedText.this.revertEdit();
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedText.this.applyEdit();
                    }
                } else if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.hasMultiLineCommitModifier(e)) {
                    TrackedText.this.applyEdit();
                    e.doit = false;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getHoverBackground());
            }
            TrackedText.this.setMouseInsideControl(true);
        }

        public void mouseExit(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInactiveBackground());
            }
            TrackedText.this.setMouseInsideControl(false);
        }

        public void mouseHover(MouseEvent e) {
            TrackedText.this.setMouseInsideControl(true);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                TrackedText.this.getWidget().selectAll();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                if (e.button == 1) {
                    TrackedText.this.startEdit(TrackedText.this.selectAllOnStartEdit);
                }
            } else if (e.button == 1 && (TrackedText.this.state & 4) != 0) {
                if (!this.isMultiLine()) {
                    TrackedText.this.getWidget().selectAll();
                }
                TrackedText.this.state &= 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!TrackedText.this.isEditing() && !this.isMultiLine()) {
                TrackedText.this.startEdit(TrackedText.this.selectAllOnStartEdit);
            }
        }

        public void focusLost(FocusEvent e) {
            if (TrackedText.this.isEditing()) {
                TrackedText.this.applyEdit();
            }
        }
    }
}

