/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.HashMap;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.IsCheckedProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;

public class DefaultIsCheckedProcessor
extends AbstractPrimitiveQueryProcessor<CheckedState>
implements IsCheckedProcessor,
ProcessorLifecycle {
    private static final boolean DEBUG = false;
    private final HashMap<NodeContext, CheckedState> checkedStates = new HashMap();
    private final HashMap<NodeContext, PrimitiveQueryUpdater> checkedQueries = new HashMap();
    private final CheckedState defaultState;
    private Tree tree;
    private boolean viewerSupportsChecking;
    Listener treeListener = new Listener(){

        public void handleEvent(Event event) {
            NodeContext context = (NodeContext)event.item.getData();
            switch (event.type) {
                case 13: {
                    if (event.detail != 32 || event.item == null) break;
                    TreeItem item = (TreeItem)event.item;
                    boolean checked = item.getChecked();
                    boolean grayed = item.getGrayed();
                    DefaultIsCheckedProcessor.this.nodeStatusChanged(context, DefaultIsCheckedProcessor.toCheckedState(checked, grayed));
                }
            }
        }
    };

    public DefaultIsCheckedProcessor() {
        this(CheckedState.NOT_CHECKED);
    }

    public DefaultIsCheckedProcessor(CheckedState defaultState) {
        if (defaultState == null) {
            throw new NullPointerException("null default state");
        }
        this.defaultState = defaultState;
    }

    public Object getIdentifier() {
        return BuiltinKeys.IS_CHECKED;
    }

    public String toString() {
        return "IsCheckedProcessor";
    }

    public CheckedState query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<CheckedState> key) {
        if (!this.viewerSupportsChecking) {
            return this.defaultState;
        }
        CheckedState checked = this.checkedStates.get(context);
        this.checkedQueries.put(context, updater);
        return checked != null ? checked : CheckedState.NOT_CHECKED;
    }

    public boolean setChecked(NodeContext context, CheckedState checked) {
        return this._setChecked(context, checked);
    }

    private boolean _setChecked(NodeContext context, CheckedState checked) {
        if (checked != this.defaultState) {
            return this.checkedStates.put(context, checked) != checked;
        }
        return this.checkedStates.remove(context) != null;
    }

    protected void nodeStatusChanged(NodeContext context, CheckedState checked) {
        this._setChecked(context, checked);
    }

    public void attached(GraphExplorer explorer) {
        Object control = explorer.getControl();
        if (control instanceof Tree) {
            this.tree = (Tree)control;
            this.viewerSupportsChecking = DefaultIsCheckedProcessor.supportsChecking((Widget)this.tree);
            if (this.viewerSupportsChecking) {
                this.tree.addListener(13, this.treeListener);
            }
        } else {
            System.out.println("WARNING: " + ((Object)((Object)this)).getClass().getSimpleName() + " attached to unsupported control: " + control);
        }
    }

    public void clear() {
        this.checkedStates.clear();
        this.checkedQueries.clear();
    }

    public void detached(GraphExplorer explorer) {
        this.clear();
        if (this.tree != null) {
            if (this.viewerSupportsChecking) {
                this.tree.removeListener(13, this.treeListener);
            }
            this.tree = null;
            this.viewerSupportsChecking = false;
        }
    }

    private static boolean supportsChecking(Widget control) {
        return (control.getStyle() & 0x20) != 0;
    }

    private static CheckedState toCheckedState(boolean checked, boolean grayed) {
        if (checked) {
            return grayed ? CheckedState.GRAYED : CheckedState.CHECKED;
        }
        return CheckedState.NOT_CHECKED;
    }
}

