/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.nodemanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.nodemanager.ChildVariableNode;
import org.simantics.sysdyn.nodemanager.SysdynVariableNode;

public class SysdynValueData
extends Bean {
    public static double[] UNRESOLVED = new double[0];
    public static Binding BINDING = Bindings.getBindingUnchecked(SysdynValueData.class);
    public transient SysdynExperiment experiment;
    public double[] values;
    public String rvi;
    public Map<String, Tuple2> rvis;

    public SysdynValueData(SysdynExperiment experiment, SysdynVariableNode node) {
        this.setInfo(experiment, node);
        this.values = this.getValueFull();
    }

    public static String transform(String s) {
        return s.substring(1).replace("/", ".").replace("%20", "_");
    }

    private List<String> vars() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.rvis.keySet()) {
            result.add(SysdynValueData.transform(s));
        }
        return result;
    }

    private double[] getValueFull() {
        if (this.experiment == null) {
            return UNRESOLVED;
        }
        List<String> variableNames = this.vars();
        double[] result = new double[variableNames.size()];
        if (this.experiment instanceof SysdynGameExperimentBase) {
            SysdynGameExperimentBase.Subscription s = ((SysdynGameExperimentBase)this.experiment).subscribe(variableNames);
            double[] arr = new double[variableNames.size()];
            s.getValues(arr);
            return arr;
        }
        Collection<SysdynResult> results = this.experiment.getActiveResults();
        int i = 0;
        while (i < variableNames.size()) {
            for (SysdynResult r : results) {
                SysdynDataSet ds = r.getDataSet(variableNames.get(i));
                if (ds != null && ds.values != null && ds.values.length > 0) {
                    result[i] = ds.values[ds.values.length - 1];
                    continue;
                }
                return UNRESOLVED;
            }
            ++i;
        }
        return result;
    }

    protected void setInfo(SysdynExperiment experiment, SysdynVariableNode node) {
        ChildVariableNode n = (ChildVariableNode)node.getParent();
        this.experiment = experiment;
        this.rvi = n.getRVI();
        this.rvis = VariableRVIUtils.getActiveRVIs(n);
    }
}

