/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.map.TObjectIntMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.Severity;
import org.simantics.issues.common.CountModelIssuesBySeverity;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.Experiment;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.Activator;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.nodemanager.SysdynVariableSessionManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ISolverMonitor;
import org.simantics.sysdyn.solver.SolverSettings;
import org.simantics.sysdyn.solver.SysdynSimulationJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SysdynExperiment
extends Experiment
implements IDynamicExperiment {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysdynExperiment.class);
    protected static final String pluginId = "org.simantics.sysdyn";
    protected Session session;
    protected Runnable modificationListener;
    public SysdynModel sysdynModel;
    protected ISolver solver = null;
    protected boolean toggled = false;
    protected Process process;
    protected boolean canceled = false;
    protected ExperimentState sysdynExperimentState;
    protected SysdynResult result;
    private String runId;
    protected String experimentName = "Experiment";
    private File experimentDir = null;
    volatile long previousVariableUpdateTime = 0L;

    public SysdynExperiment(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    public SysdynResult getCurrentResult() {
        if (this.result == null) {
            this.result = new MemoryResult(null, null);
        }
        return this.result;
    }

    public void setCurrentResult(SysdynResult result) {
        this.result = result;
    }

    public Collection<SysdynResult> getActiveResults() {
        ArrayList<SysdynResult> result = new ArrayList<SysdynResult>();
        if (this.getCurrentResult() != null) {
            result.add(this.getCurrentResult());
        }
        result.addAll(this.sysdynModel.getDisplayedResults());
        return result;
    }

    public void init(ReadGraph g) throws DatabaseException {
        try {
            this.experimentName = NameUtils.getSafeName((ReadGraph)g, (Resource)this.experiment);
        }
        catch (DatabaseException e) {
            this.experimentName = "Experiment";
        }
        this.session = g.getSession();
        this.state = ExperimentState.STOPPED;
        IExperimentListener[] iExperimentListenerArray = (IExperimentListener[])this.listeners.getListeners();
        int n = iExperimentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExperimentListener listener = iExperimentListenerArray[n2];
            listener.stateChanged(this.state);
            ++n2;
        }
        Resource configuration = g.getPossibleObject(this.model, SimulationResource.getInstance((ReadGraph)g).HasConfiguration);
        this.sysdynModel = SysdynModelManager.getInstance(this.session).getModel(g, configuration);
        this.toggleActivation(g, true);
        this.setSysdynExperimentState(ExperimentState.INITIALIZING);
        SysdynVariableSessionManager.refreshVariablesByExperiment(this.getIdentifier());
    }

    public void saveState() {
        if (this.result == null || !(this.result instanceof MemoryResult)) {
            return;
        }
    }

    protected Thread getSaveThread(final SysdynResult result, final File file, final IProgressMonitor progressMonitor) {
        return new Thread(){

            @Override
            public void run() {
                if (!SysdynExperiment.this.canceled) {
                    result.saveToFile(file, progressMonitor);
                }
            }
        };
    }

    public void simulate(boolean enabled) {
        if (enabled) {
            SysdynSimulationJob job = new SysdynSimulationJob(this.sysdynModel.getConfiguration().getLabel(), this);
            job.schedule();
        }
    }

    public abstract void createSolver(ISolverMonitor var1);

    public void ensureSolver() {
        SolverSettings.SolverType type = this.getSolverType();
        if (this.solver == null || !this.solver.getType().equals((Object)type)) {
            this.createSolver(null);
        }
    }

    public IStatus doSimulate(IProgressMonitor monitor, ISolverMonitor solverMonitor) {
        try {
            this.sysdynModel.update();
        }
        catch (DatabaseException e) {
            return new Status(4, pluginId, "Could not update model", (Throwable)e);
        }
        try {
            TObjectIntMap severeties = (TObjectIntMap)Simantics.sync((ReadInterface)new CountModelIssuesBySeverity(this.getModel(), true, Severity.ERROR));
            if (severeties.get((Object)Severity.ERROR) > 0) {
                return new Status(4, pluginId, "There are unresolved errors in the model");
            }
        }
        catch (DatabaseException e) {
            return new Status(4, pluginId, "Could not obtain issue count from model", (Throwable)e);
        }
        SolverSettings.SolverType type = this.getSolverType();
        if (this.solver == null || !this.solver.getType().equals((Object)type)) {
            this.createSolver(solverMonitor);
        }
        try {
            monitor.subTask("generating model...");
            this.solver.initialize();
            monitor.worked(1);
            monitor.subTask("building model...");
            this.solver.buildModel();
            monitor.worked(1);
            monitor.subTask("running solver...");
            this.solver.runSolver();
            monitor.worked(1);
            monitor.subTask("getting results...");
            this.solver.updateResults();
            monitor.worked(1);
        }
        catch (Exception e) {
            return new Status(4, pluginId, "Simulation failed", (Throwable)e);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public void cancelSimulation() {
        this.canceled = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void toggleSimulation(boolean enabled) {
        if (enabled) {
            this.toggled = true;
            this.changeState(ExperimentState.RUNNING);
            if (this.modificationListener == null) {
                this.modificationListener = new Runnable(){

                    @Override
                    public void run() {
                        SysdynExperiment.this.session.asyncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                SysdynExperiment.this.getState();
                            }
                        });
                    }
                };
                this.sysdynModel.addModificationListener(this.modificationListener);
            }
        } else {
            this.changeState(ExperimentState.STOPPED);
            this.toggled = false;
        }
    }

    public void refresh(RequestProcessor session) {
        try {
            session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynExperiment.this.init(graph);
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("refresh failed", (Throwable)e);
        }
    }

    public void refresh(Session session) {
        this.refresh((RequestProcessor)session);
    }

    protected void localStateChange() {
        this.setSysdynExperimentState(this.getState());
        switch (this.state) {
            case DISPOSED: {
                this.onExperimentDisposed();
                break;
            }
        }
    }

    public ExperimentState getSysdynExperimentState() {
        return this.sysdynExperimentState;
    }

    protected void setSysdynExperimentState(final ExperimentState state) {
        this.sysdynExperimentState = state;
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                Session session = graph.getSession();
                session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        SimulationResource SR = SimulationResource.getInstance((ReadGraph)graph);
                        graph.deny(SysdynExperiment.this.model, SR.HasExperimentState);
                        graph.deny(SysdynExperiment.this.experiment, SR.HasExperimentState);
                        Resource st = graph.newResource();
                        switch (state) {
                            case INITIALIZING: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Initializing);
                                break;
                            }
                            case RUNNING: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Running);
                                break;
                            }
                            case STOPPED: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Stopped);
                                break;
                            }
                            case DISPOSED: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Disposed);
                            }
                        }
                        graph.claim(SysdynExperiment.this.model, SR.HasExperimentState, st);
                        graph.claim(SysdynExperiment.this.experiment, SR.HasExperimentState, st);
                    }
                });
            }
        });
    }

    protected void onExperimentDisposed() {
        this.cancelSimulation();
        this.sysdynModel.removeModificationListener(this.modificationListener);
        this.modificationListener = null;
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SysdynExperiment.this.toggleActivation(graph, false);
            }
        });
    }

    protected void toggleActivation(ReadGraph graph, final boolean activate) {
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        final Session session = graph.getSession();
        session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

            public void perform(WriteGraph graph) throws DatabaseException {
                VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                session.asyncRequest((Write)new WriteRequest(runtime){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                        if (activate) {
                            graph.claim(SysdynExperiment.this.experiment, SIMU.IsActive, SysdynExperiment.this.experiment);
                        } else {
                            graph.denyStatement(SysdynExperiment.this.experiment, SIMU.IsActive, SysdynExperiment.this.experiment);
                        }
                    }
                });
            }
        });
    }

    public void resultsChanged() {
        long time = System.nanoTime();
        if (time - this.previousVariableUpdateTime > 10000000L) {
            this.updateSubscriptions();
            this.previousVariableUpdateTime = time;
        }
    }

    public void updateSubscriptions() {
        SysdynVariableSessionManager.refreshVariablesByExperiment(this.getIdentifier());
    }

    public Lock getDatasourceLock() {
        throw new UnsupportedOperationException();
    }

    public Datasource getDatasource() {
        throw new UnsupportedOperationException();
    }

    public void simulateDuration(double duration) {
        throw new UnsupportedOperationException();
    }

    public void rewindTo(double time) {
        throw new UnsupportedOperationException();
    }

    public File getExperimentDir() {
        if (this.experimentDir == null) {
            File modelsDir = Activator.getBundleContext().getDataFile("models");
            String name = this.experimentName;
            List<String> files = Arrays.asList(modelsDir.list());
            if (files.contains(name)) {
                int i = 2;
                while (files.contains(String.valueOf(name) + "_" + i)) {
                    ++i;
                }
                name = String.valueOf(name) + "_" + i;
            }
            this.experimentDir = new File(modelsDir, name);
            this.experimentDir.mkdir();
        }
        return this.experimentDir;
    }

    public SolverSettings.SolverType getSolverType() {
        return SolverSettings.getSelectedSolverType();
    }

    public double getSimulationTime() {
        return 0.0;
    }

    public Collection<IElement> getChildren(String path) {
        return this.getChildren(this.getConfiguration(path));
    }

    public Collection<IElement> getChildren(Configuration configuration) {
        if (configuration == null) {
            return Collections.emptyList();
        }
        ArrayList<IElement> result = new ArrayList<IElement>();
        for (IElement element : configuration.getElements()) {
            if (element instanceof Variable) {
                result.add(element);
                continue;
            }
            if (!(element instanceof Module)) continue;
            result.add(element);
        }
        return result;
    }

    public Configuration getConfiguration(String path) {
        String[] parts = path.split("/");
        if (this.sysdynModel == null) {
            return null;
        }
        Configuration configuration = this.sysdynModel.getConfiguration();
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            for (IElement element : configuration.getElements()) {
                if (element instanceof Variable) {
                    if (!part.equals(((Variable)element).getName())) continue;
                    return null;
                }
                if (!(element instanceof Module) || !part.equals(((Module)element).getName())) continue;
                configuration = ((Module)element).getType().getConfiguration();
            }
            ++i;
        }
        return configuration;
    }
}

