/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.OldSysdynExperiment;

public class SaveResultJob
extends Job {
    private final MemoryResult sysdynResult;
    private final OldSysdynExperiment experiment;
    private final Session session;
    private IProgressMonitor monitor;
    private File file;

    public SaveResultJob(OldSysdynExperiment experiment, Session session, MemoryResult result) {
        super("Save Result");
        this.experiment = experiment;
        this.sysdynResult = result;
        this.session = session;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        int resultItemsNumber = this.sysdynResult.numberOfVariables();
        monitor.beginTask("Save result", resultItemsNumber * 2 + 1);
        try {
            this.file = (File)this.session.syncRequest((Read)new Read<File>(){

                public File perform(ReadGraph graph) throws DatabaseException {
                    File projectRoot;
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource model = graph.getSingleObject(SaveResultJob.this.experiment.getResource(), l0.PartOf);
                    Resource project = graph.getSingleObject(model, l0.PartOf);
                    String projectName = (String)graph.getPossibleRelatedValue(project, l0.HasName);
                    File root = new File(Platform.getLocation().toOSString(), "www.simantics.org");
                    if (!root.isDirectory()) {
                        root.mkdir();
                    }
                    if (!(projectRoot = new File(root, projectName)).isDirectory()) {
                        projectRoot.mkdir();
                    }
                    File file = new File(projectRoot, String.valueOf(UUID.randomUUID().toString()) + ".dbb");
                    return file;
                }
            });
            Thread saveThread = this.experiment.getSaveThread(this.sysdynResult, this.file, this.monitor);
            saveThread.run();
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource model = graph.getSingleObject(SaveResultJob.this.experiment.getResource(), l0.PartOf);
                    String name = NameUtils.findFreshName((ReadGraph)graph, (String)"Result", (Resource)model, (Resource)l0.ConsistsOf, (String)"%s%d");
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource res = GraphUtils.create2((WriteGraph)graph, (Resource)sr.Result, (Object[])new Object[]{l0.HasLabel, name, l0.HasName, name, l0.PartOf, model, sr.Result_resultFile, SaveResultJob.this.file.getAbsolutePath(), sr.Result_time, System.currentTimeMillis()});
                    graph.claim(SaveResultJob.this.experiment.getResource(), sr.Experiment_result, res);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "org.simantics.sysdyn.ui", "Save results failed: \n" + e.getMessage());
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "SaveResultJob".equals(family);
    }

    protected void canceling() {
    }
}

