/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import gnu.trove.set.hash.THashSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategyBase;
import org.simantics.modeling.services.NamingException;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple4;
import org.simantics.structural.stubs.StructuralResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInsensitiveComponentFunctionNamingStrategy
extends ComponentNamingStrategyBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInsensitiveComponentFunctionNamingStrategy.class);
    protected static final boolean DEBUG_INDEX_SEARCH = false;
    private final Function index;
    private Function1<String, String> propositionPreFilter;
    CaseInsensitiveComponentNamingStrategy2 fallbackStrategy = null;

    public CaseInsensitiveComponentFunctionNamingStrategy(Function index) {
        this("%s %d", index);
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index) {
        super(generatedNameFormat);
        this.index = index;
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index, Function1<String, String> propositionPreFilter) {
        super(generatedNameFormat);
        this.index = index;
        this.propositionPreFilter = propositionPreFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource component, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource indexRoot;
        String lowercaseName;
        boolean trace = LOGGER.isTraceEnabled();
        String lowercaseProposition = proposition.toLowerCase();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
        if (name != null && (lowercaseName = name.toLowerCase()).startsWith(lowercaseProposition) && (indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot))) != null) {
            CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
            synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
                String search = String.valueOf(IndexQueries.escapeTerm((String)"NameSearch", (String)lowercaseName, (boolean)true)) + "*";
                List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
                THashSet rs = new THashSet();
                for (Resource componentResult : components) {
                    String n = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING);
                    if (trace) {
                        LOGGER.trace("validateInstanceName: found {} = {}", (Object)componentResult, (Object)n);
                    }
                    if (n == null || !n.toLowerCase().equals(lowercaseName)) continue;
                    rs.add(componentResult);
                }
                Cache c = this.getCache(graph, indexRoot);
                if (rs.size() == 0) {
                    if (!c.getRequested().contains(name)) {
                        c.addRequested(name);
                        return name;
                    }
                } else if (rs.size() == 1 && component.equals(rs.iterator().next())) {
                    return name;
                }
            }
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource container = graph.getSingleObject(component, L0.PartOf);
        Resource componentType = graph.getSingleType(component, STR.Component);
        return this.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            LOGGER.warn("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
            if (this.fallbackStrategy == null) {
                this.fallbackStrategy = new CaseInsensitiveComponentNamingStrategy2((GraphChangeListenerSupport)graph.getService(GraphChangeListenerSupport.class), this.generatedNameFormat);
            }
            return this.fallbackStrategy.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
        }
        if (this.propositionPreFilter != null) {
            proposition = (String)this.propositionPreFilter.apply((Object)proposition);
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            String search = "NameSearch:" + IndexQueries.escape((String)proposition.toLowerCase(), (boolean)true) + "*";
            Set reserved = (Set)graph.syncRequest((Read)new ComponentsRequest(new Tuple4((Object)indexRoot, (Object)this.index, (Object)search, this.getComparator())), (AsyncProcedure)TransientCacheAsyncListener.instance());
            Cache cache = this.getCache(graph, indexRoot);
            this.findStartsWithMatches(cache.getRequested(), proposition, reserved);
            String result = this.findFreshName(reserved, proposition, acceptProposition);
            cache.addRequested(result);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("validateInstanceName2: validated instance name {}", (Object)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> validateInstanceNames(ReadGraph graph, Resource configurationRoot, List<String> propositions, boolean acceptProposition, Set<String> externallyReserved) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            throw new NamingException("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        boolean trace = LOGGER.isTraceEnabled();
        Cache c = this.getCache(graph, indexRoot);
        TreeSet<Object> exts = new TreeSet<Object>(this.getComparator());
        if (externallyReserved != null) {
            exts.addAll(externallyReserved);
        }
        exts.addAll(c.requested);
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            ArrayList<String> result = new ArrayList<String>(propositions.size());
            HashMap<String, Proxy2Set> reservations = new HashMap<String, Proxy2Set>();
            for (String proposition : propositions) {
                Proxy2Set reserved;
                if (this.propositionPreFilter != null) {
                    proposition = (String)this.propositionPreFilter.apply((Object)proposition);
                }
                if ((reserved = (Proxy2Set)reservations.get(proposition)) == null) {
                    String search = "NameSearch:" + IndexQueries.escape((String)proposition.toLowerCase(), (boolean)true) + "*";
                    List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
                    if (trace) {
                        LOGGER.trace("validateInstanceNames: found {} index results for index root {} & configurationRoot {} & proposition {} with search {}", new Object[]{components.size(), indexRoot, configurationRoot, proposition, search});
                    }
                    TreeSet<Object> res = new TreeSet<Object>(this.getComparator());
                    for (Resource componentResult : components) {
                        String name = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING);
                        if (trace) {
                            LOGGER.trace("found {} = {}", (Object)componentResult, (Object)name);
                        }
                        if (name == null) continue;
                        res.add(name);
                    }
                    reserved = new Proxy2Set(exts, res);
                    reservations.put(proposition, reserved);
                }
                String name = this.findFreshName(reserved, proposition, acceptProposition);
                result.add(name);
                reserved.s2.add(name);
                if (!trace) continue;
                LOGGER.trace("validateInstanceNames: validated instance name {} -> {}", (Object)proposition, (Object)name);
            }
            if (trace) {
                LOGGER.trace("validateInstanceNames: validated instance names {} -> {}", propositions, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(ReadGraph graph, Resource root) throws DatabaseException {
        Cache cache = (Cache)Indexing.getCache((Resource)root, Cache.class);
        if (cache != null) {
            return cache;
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            cache = (Cache)Indexing.getCache((Resource)root, Cache.class);
            if (cache != null) {
                return cache;
            }
            return (Cache)Indexing.createCache((Resource)root, (Object)new Cache(this.caseInsensitive));
        }
    }

    static class Cache {
        private final Set<String> requested;

        Cache(boolean caseInsensitive) {
            this.requested = new TreeSet<Object>(CaseInsensitiveComponentFunctionNamingStrategy.getComparator(caseInsensitive));
        }

        public Set<String> getRequested() {
            return this.requested;
        }

        public void addRequested(String name) {
            this.requested.add(name);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.requested;
        }
    }

    static class ComponentsRequest
    extends UnaryRead<Tuple4, Set<String>> {
        public ComponentsRequest(Tuple4 parameter) {
            super((Object)parameter);
        }

        public Set<String> perform(ReadGraph graph) throws DatabaseException {
            Resource indexRoot = (Resource)((Tuple4)this.parameter).get(0);
            Function index = (Function)((Tuple4)this.parameter).get(1);
            String search = (String)((Tuple4)this.parameter).get(2);
            Comparator comparator = (Comparator)((Tuple4)this.parameter).get(3);
            List components = (List)index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
            TreeSet<String> reserved = new TreeSet<String>(comparator);
            boolean debug = LOGGER.isDebugEnabled();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource componentResult : components) {
                String name;
                if (debug) {
                    LOGGER.debug("{}: found {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)componentResult);
                }
                if ((name = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING)) == null) continue;
                reserved.add(name);
            }
            LOGGER.warn("found {} components", (Object)reserved.size());
            return reserved;
        }
    }

    private static class Proxy2Set
    extends AbstractSet<String> {
        Set<String> s1;
        Set<String> s2;

        public Proxy2Set(Set<String> s1, Set<String> s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.s1.size() + this.s2.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.s1.contains(o) || this.s2.contains(o);
        }
    }
}

