/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.PlatformException;
import org.simantics.SimanticsPlatform;
import org.simantics.db.Session;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.event.SessionEvent;
import org.simantics.db.event.SessionListener;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.ui.ErrorLogger;

public class SessionWatchdog
implements SessionListener,
ISessionContextChangedListener {
    SessionManager currentManager;

    public void attach(ISessionContextProvider scp) {
        scp.addContextChangedListener((ISessionContextChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach(Session session) {
        SessionManager sessionManager = null;
        SessionWatchdog sessionWatchdog = this;
        synchronized (sessionWatchdog) {
            sessionManager = this.toSessionManager(session);
            if (sessionManager == this.currentManager) {
                return;
            }
        }
        if (this.currentManager != null) {
            this.currentManager.removeSessionListener((SessionListener)this);
        }
        this.currentManager = sessionManager;
        if (sessionManager != null) {
            sessionManager.addSessionListener((SessionListener)this);
        }
    }

    private SessionManager toSessionManager(Session s) {
        if (s == null) {
            return null;
        }
        LifecycleSupport ls = (LifecycleSupport)s.peekService(LifecycleSupport.class);
        if (ls == null) {
            return null;
        }
        return ls.getSessionManager();
    }

    public void sessionContextChanged(SessionContextChangedEvent event) {
        ISessionContext sc = event.getNewValue();
        this.attach(sc != null ? sc.getSession() : null);
    }

    public void sessionOpened(SessionEvent e) {
    }

    public void sessionClosed(SessionEvent e) {
        if (e.getCause() != null) {
            ErrorLogger.defaultLogError((Throwable)e.getCause());
            this.reconnect(e.getSession());
        }
    }

    private void reconnect(Session deadSession) {
    }

    public void sessionException(SessionEvent e) {
        ErrorLogger.defaultLogError((Throwable)e.getCause());
        Session s = e.getSession();
        LifecycleSupport ls = (LifecycleSupport)s.getService(LifecycleSupport.class);
        SessionReference sr = ls.getSessionReference();
        Display display = Display.getDefault();
        display.asyncExec(this.dialogOpener(e.getCause(), sr));
    }

    private Runnable dialogOpener(final Throwable cause, final SessionReference sr) {
        return new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                if (shell == null) {
                    return;
                }
                DatabaseConnectionProblemDialog d = new DatabaseConnectionProblemDialog(shell, cause, sr);
                d.setBlockOnOpen(true);
                d.open();
            }
        };
    }

    private static void shutdown() {
        try {
            SimanticsPlatform.INSTANCE.shutdown(null);
        }
        catch (PlatformException e) {
            e.printStackTrace();
        }
        System.exit(-2);
    }

    class DatabaseConnectionProblemDialog
    extends TrayDialog {
        Throwable cause;
        SessionReference sr;

        public DatabaseConnectionProblemDialog(Shell shell, Throwable cause, SessionReference sr) {
            super(shell);
            this.cause = cause;
            this.sr = sr;
            this.setShellStyle(0x10030 | DatabaseConnectionProblemDialog.getDefaultOrientation());
        }

        protected boolean isResizable() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setSize(700, 600);
            newShell.setText("Database Connection Problem");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 10, "Continue", false);
            this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        }

        protected void buttonPressed(int buttonId) {
            if (12 == buttonId) {
                SessionWatchdog.shutdown();
            } else if (10 == buttonId) {
                this.cancelPressed();
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Text text = new Text(c, 74);
            StringBuilder sb = new StringBuilder();
            sb.append("Our apologies, it seems that the database connection to used by the workbench has been unexpectedly disconnected. We are working on these stability problems.");
            sb.append("\n\n");
            sb.append("Session Reference was: " + this.sr);
            sb.append("\n\n");
            sb.append("Unfortunately nothing can be done at this point to recover your unsaved work. The program will be forcibly closed if you select close. You may select continue to attempt recovery but be warned that this will most likely not achieve anything useful.");
            sb.append("\n\n");
            sb.append("TODO: implement a possibility to attempt reconnection here if the database is still up and running!");
            text.setText(sb.toString());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
            Label causeLabel = new Label(c, 0);
            causeLabel.setText("Exception:");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)causeLabel);
            Text causeText = new Text(c, 2122);
            StringWriter sw = new StringWriter();
            this.cause.printStackTrace(new PrintWriter(sw));
            causeText.setText(sw.toString());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)causeText);
            return c;
        }
    }
}

