/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.SyncMultiProcedure;

public class ResultCallWrappedSyncQueryProcedure<Result>
implements SyncMultiProcedure<Result> {
    private final ArrayList<Result> result;
    private Throwable exception = null;
    private final SyncMultiProcedure<Result> procedure;
    private final AtomicBoolean latch;

    public ResultCallWrappedSyncQueryProcedure(SyncMultiProcedure<Result> procedure) {
        this.procedure = procedure;
        this.latch = new AtomicBoolean(false);
        this.result = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ReadGraph graph, Result result) {
        try {
            ArrayList<Result> arrayList = this.result;
            synchronized (arrayList) {
                this.result.add(result);
            }
            this.procedure.execute(graph, result);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("AsyncMultiProcedure.execute failed for " + this.procedure), (Throwable)t);
        }
    }

    public void finished(ReadGraph graph) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.finished(graph);
            }
            catch (Throwable t) {
                Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + this.procedure), (Throwable)t);
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is finished)");
        }
    }

    public void exception(ReadGraph graph, Throwable t) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.exception = t;
                this.procedure.exception(graph, t);
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + this.procedure), (Throwable)throwable);
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is exception)");
        }
    }

    public ArrayList<Result> get() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ResultCallWrappedQueryProcedure4[" + this.procedure + "]";
    }
}

