/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.common.IssuesOfSeverity;
import org.simantics.issues.ui.ontology.IssueUIResource;

public class SeverityChildRule
implements ChildRule {
    final Resource rule;

    public SeverityChildRule(Resource rule) {
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        IssueUIResource UI = IssueUIResource.getInstance((ReadGraph)graph);
        Resource project = (Resource)parent;
        Resource severity = graph.getSingleObject(this.rule, UI.IssueBrowseContext_SeverityChildRule_HasSeverity);
        return (Collection)graph.syncRequest((Read)new IssuesOfSeverity(project, severity));
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.singleton(child);
    }
}

