/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules.domain;

import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.domain.IDomainAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedListElementsAccessor
implements IDomainAccessor<Collection<Resource>> {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");
    Resource relation;

    public RelatedListElementsAccessor(Resource relation) {
        this.relation = relation;
    }

    @Override
    public Collection<Resource> get(ReadGraph g, Resource element) throws MappingException {
        try {
            LOGGER.trace("        RelatedListElementsAccessor.get");
            Resource listResource = g.getPossibleObject(element, this.relation);
            if (listResource != null) {
                return ListUtils.toList((ReadGraph)g, (Resource)listResource);
            }
            return Collections.emptyList();
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Collection<Resource> value) throws MappingException {
        try {
            LOGGER.trace("        RelatedListElementsAccessor.set");
            Resource listResource = g.getPossibleObject(element, this.relation);
            if (listResource != null) {
                ListUtils.createExisting((WriteOnlyGraph)g, (Resource)listResource, value);
            } else {
                listResource = ListUtils.create((WriteGraph)g, value);
                g.claim(element, this.relation, listResource);
            }
            return true;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }
}

